/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.client;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_4696;
import shetiphian.core.internal.ShetiPhianCore;

public class RenderLayerOverrideHandler
implements class_4013 {
    private static final RenderLayerOverrideHandler INSTANCE = new RenderLayerOverrideHandler();
    private static final Map<class_2248, class_1921> BACKUP_LAYER_MAP = new HashMap<class_2248, class_1921>();
    public static Gson GSON = new GsonBuilder().create();

    public static void init() {
        class_3300 manager = class_310.method_1551().method_1478();
        if (manager instanceof class_3304) {
            ((class_3304)manager).method_14477((class_3302)INSTANCE);
        }
        INSTANCE.load();
    }

    public void method_14491(class_3300 resourceManager) {
        BACKUP_LAYER_MAP.forEach((arg_0, arg_1) -> ((BlockRenderLayerMap)BlockRenderLayerMap.INSTANCE).putBlock(arg_0, arg_1));
        BACKUP_LAYER_MAP.clear();
        this.load();
    }

    private void load() {
        class_1921[] layers;
        HashMap renderLayerMap = new HashMap();
        class_2960 loc = new class_2960("shetiphian:render_layer_remap.json");
        List resources = class_310.method_1551().method_1478().method_14489(loc);
        Type token = new TypeToken<Map<String, String>>(){}.getType();
        for (class_3298 resource : resources) {
            Map map;
            try (BufferedReader reader = resource.method_43039();){
                map = (Map)GSON.fromJson((Reader)reader, token);
            }
            catch (Exception e) {
                ShetiPhianCore.LOGGER.error(String.format("Error loading render_layer_remap.json form %s\n\t%s", resource.method_14480(), e.getLocalizedMessage()));
                break;
            }
            map.forEach((key, value) -> {
                if (!key.startsWith("shetiphian:example_")) {
                    try {
                        class_2960 location = new class_2960(key);
                        Optional optional = class_2378.field_11146.method_17966(location);
                        if (optional.isEmpty()) {
                            throw new Exception(String.format("No block registry entry for [%s] found", key));
                        }
                        class_2248 block = (class_2248)optional.get();
                        boolean added = false;
                        for (String layer : value.split(",")) {
                            added |= this.addBlockToMap(block, layer.trim(), renderLayerMap);
                        }
                        if (!added) {
                            throw new Exception(String.format("No valid layer key for [%s] found in [%s]. Valid Keys: [solid, cutout, cutout_mipped, translucent]", key, value));
                        }
                    }
                    catch (Exception e) {
                        ShetiPhianCore.LOGGER.error(String.format("Skipping invalid render_layer_remap.json entry ['%s':'%s'] form %s\n\t%s", key, value, resource.method_14480(), e.getLocalizedMessage()));
                    }
                }
            });
        }
        HashSet handled = new HashSet();
        for (class_1921 layer : layers = new class_1921[]{class_1921.method_23583(), class_1921.method_23579(), class_1921.method_23581(), class_1921.method_23577()}) {
            renderLayerMap.getOrDefault(layer, Collections.emptySet()).forEach(block -> {
                if (!handled.contains(block)) {
                    BACKUP_LAYER_MAP.put((class_2248)block, class_4696.method_23679((class_2680)block.method_9564()));
                    BlockRenderLayerMap.INSTANCE.putBlock(block, layer);
                    handled.add(block);
                }
            });
        }
    }

    private boolean addBlockToMap(class_2248 block, String layerName, Map<class_1921, Set<class_2248>> renderLayerMap) {
        class_1921 renderLayer;
        switch (layerName) {
            case "solid": {
                renderLayer = class_1921.method_23577();
                break;
            }
            case "cutout": {
                renderLayer = class_1921.method_23581();
                break;
            }
            case "cutout_mipped": {
                renderLayer = class_1921.method_23579();
                break;
            }
            case "translucent": {
                renderLayer = class_1921.method_23583();
                break;
            }
            default: {
                return false;
            }
        }
        if (!renderLayerMap.containsKey(renderLayer)) {
            renderLayerMap.put(renderLayer, new HashSet());
        }
        renderLayerMap.get(renderLayer).add(block);
        return true;
    }
}

