/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.simplemagnets.ItemSpawnHandler;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.extensions.SimpleMagnetsItemEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_5575;

public class DemagnetizationCoilBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private final int minRange;
    private final int maxRange;
    private final boolean hasFilter;
    private int rangeX;
    private int rangeY;
    private int rangeZ;
    private final List<class_1799> filter = new ArrayList<class_1799>(9);
    private final List<class_1799> filterView = Collections.unmodifiableList(this.filter);
    private boolean filterWhitelist;
    private boolean filterDurability = true;
    private boolean showRange;

    public DemagnetizationCoilBlockEntity(BaseBlockEntityType<?> blockEntityType, class_2338 pos, class_2680 state, int minRange, int maxRange, int range, boolean hasFilter) {
        super(blockEntityType, pos, state);
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = range;
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(class_1799.field_8037);
        }
    }

    public void update() {
        class_238 area = this.getArea();
        List affectedItems = this.field_11863.method_18023((class_5575)class_1299.field_6052, area, item -> item.method_5805() && this.shouldEffectItem(item.method_6983()));
        affectedItems.stream().map(SimpleMagnetsItemEntity.class::cast).forEach(SimpleMagnetsItemEntity::simplemagnetsMarkDontPickUp);
    }

    public class_238 getArea() {
        return new class_238(this.field_11867).method_1009((double)(this.rangeX - 1), (double)(this.rangeY - 1), (double)(this.rangeZ - 1));
    }

    public boolean shouldEffectItem(class_1799 stack) {
        if (!this.hasFilter) {
            return true;
        }
        if (stack.method_7960()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 filter = this.filter.get(i);
            if (!class_1799.method_7984((class_1799)filter, (class_1799)stack) || this.filterDurability && !class_1799.method_7975((class_1799)filter, (class_1799)stack)) continue;
            return this.filterWhitelist;
        }
        return !this.filterWhitelist;
    }

    public int getRangeX() {
        return this.rangeX;
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public int getRangeY() {
        return this.rangeY;
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public int getRangeZ() {
        return this.rangeZ;
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public List<class_1799> getFilter() {
        return this.filterView;
    }

    public void updateFilter(int index, class_1799 stack) {
        this.filter.set(index, stack);
        this.dataChanged();
    }

    public boolean getFilterWhitelist() {
        return this.filterWhitelist;
    }

    public void toggleFilterWhitelist() {
        this.filterWhitelist = !this.filterWhitelist;
        this.dataChanged();
    }

    public boolean getFilterDurability() {
        return this.filterDurability;
    }

    public void toggleFilterDurability() {
        this.filterDurability = !this.filterDurability;
        this.dataChanged();
    }

    public boolean getShowRange() {
        return this.showRange;
    }

    public void toggleShowRange() {
        this.showRange = !this.showRange;
        this.dataChanged();
    }

    protected class_2487 writeData() {
        class_2487 tag = new class_2487();
        tag.method_10569("rangeX", this.rangeX);
        tag.method_10569("rangeY", this.rangeY);
        tag.method_10569("rangeZ", this.rangeZ);
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                if (this.filter.get(i).method_7960()) continue;
                tag.method_10566("filter" + i, (class_2520)this.filter.get(i).method_7953(new class_2487()));
            }
            tag.method_10556("filterWhitelist", this.filterWhitelist);
            tag.method_10556("filterDurability", this.filterDurability);
        }
        tag.method_10556("showRange", this.showRange);
        return tag;
    }

    protected void readData(class_2487 tag) {
        if (tag.method_10545("rangeX")) {
            this.rangeX = tag.method_10550("rangeX");
        }
        if (tag.method_10545("rangeY")) {
            this.rangeY = tag.method_10550("rangeY");
        }
        if (tag.method_10545("rangeZ")) {
            this.rangeZ = tag.method_10550("rangeZ");
        }
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                this.filter.set(i, tag.method_10545("filter" + i) ? class_1799.method_7915((class_2487)tag.method_10562("filter" + i)) : class_1799.field_8037);
            }
            this.filterWhitelist = tag.method_10545("filterWhitelist") && tag.method_10577("filterWhitelist");
            this.filterDurability = tag.method_10545("filterDurability") && tag.method_10577("filterDurability");
        }
        this.showRange = tag.method_10577("showRange");
    }

    public void onLoad() {
        ItemSpawnHandler.add(this);
    }

    public static class AdvancedDemagnetizationCoilBlockEntity
    extends DemagnetizationCoilBlockEntity {
        public AdvancedDemagnetizationCoilBlockEntity(class_2338 pos, class_2680 state) {
            super(SimpleMagnets.advanced_demagnetization_coil_tile, pos, state, SMConfig.advancedCoilMinRange.get(), SMConfig.advancedCoilMaxRange.get(), SMConfig.advancedCoilRange.get(), SMConfig.advancedCoilFilter.get());
        }
    }

    public static class BasicDemagnetizationCoilBlockEntity
    extends DemagnetizationCoilBlockEntity {
        public BasicDemagnetizationCoilBlockEntity(class_2338 pos, class_2680 state) {
            super(SimpleMagnets.basic_demagnetization_coil_tile, pos, state, SMConfig.basicCoilMinRange.get(), SMConfig.basicCoilMaxRange.get(), SMConfig.basicCoilRange.get(), SMConfig.basicCoilFilter.get());
        }
    }
}

