/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import com.google.common.collect.ImmutableMap;
import de.dafuqs.arrowhead.api.CrossbowShootingCallback;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.blocks.mob_blocks.FirestarterMobBlock;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import de.dafuqs.spectrum.config.SpectrumConfig;
import de.dafuqs.spectrum.data_loaders.CrystalApothecarySimulationsDataLoader;
import de.dafuqs.spectrum.data_loaders.EntityFishingDataLoader;
import de.dafuqs.spectrum.data_loaders.NaturesStaffConversionDataLoader;
import de.dafuqs.spectrum.data_loaders.resonance.ResonanceDropsDataLoader;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.SpectrumTrackedDataHandlerRegistry;
import de.dafuqs.spectrum.entity.SpectrumTypeSpecificPredicates;
import de.dafuqs.spectrum.entity.spawners.ShootingStarSpawner;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.SpectrumPositionSources;
import de.dafuqs.spectrum.explosion.ExplosionModifierProviders;
import de.dafuqs.spectrum.explosion.ExplosionModifiers;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerIDs;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.PrioritizedBlockInteraction;
import de.dafuqs.spectrum.items.PrioritizedEntityInteraction;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.tools.GlassCrestCrossbowItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.items.trinkets.WhispyCircletItem;
import de.dafuqs.spectrum.loot.SpectrumLootConditionTypes;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import de.dafuqs.spectrum.loot.SpectrumLootPoolModifiers;
import de.dafuqs.spectrum.mixin.accessors.RecipeManagerAccessor;
import de.dafuqs.spectrum.networking.SpectrumC2SPacketReceiver;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipeSerializer;
import de.dafuqs.spectrum.registries.SpectrumAttributeTags;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockSoundGroups;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumCommands;
import de.dafuqs.spectrum.registries.SpectrumCompostableBlocks;
import de.dafuqs.spectrum.registries.SpectrumConfiguredFeatures;
import de.dafuqs.spectrum.registries.SpectrumCustomRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumDispenserBehaviors;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumEntityColorProcessors;
import de.dafuqs.spectrum.registries.SpectrumFeatures;
import de.dafuqs.spectrum.registries.SpectrumFlammableBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItemStackDamageImmunities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumMusicType;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import de.dafuqs.spectrum.registries.SpectrumPresentUnpackBehaviors;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumResonanceProcessors;
import de.dafuqs.spectrum.registries.SpectrumResourceConditions;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.registries.SpectrumStrippableBlocks;
import de.dafuqs.spectrum.registries.SpectrumStructurePoolElementTypes;
import de.dafuqs.spectrum.registries.SpectrumStructureTypes;
import de.dafuqs.spectrum.registries.SpectrumTillableBlocks;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.spells.InkSpellEffects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectrumCommon
implements ModInitializer {
    public static final String MOD_ID = "spectrum";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Spectrum");
    public static SpectrumConfig CONFIG;
    public static MinecraftServer minecraftServer;
    public static final HashMap<class_3611, Integer> fluidLuminance;

    public static void logInfo(String message) {
        LOGGER.info("[Spectrum] " + message);
    }

    public static void logWarning(String message) {
        LOGGER.warn("[Spectrum] " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[Spectrum] " + message);
    }

    public static class_2960 locate(String name) {
        return new class_2960(MOD_ID, name);
    }

    public void onInitialize() {
        SpectrumCommon.logInfo("Starting Common Startup");
        SpectrumCommon.logInfo("Loading config file...");
        AutoConfig.register(SpectrumConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SpectrumConfig)AutoConfig.getConfigHolder(SpectrumConfig.class).getConfig();
        SpectrumCommon.logInfo("Finished loading config file.");
        SpectrumRegistries.register();
        InkColors.register();
        SpectrumCommon.logInfo("Registering Banner Patterns...");
        SpectrumBannerPatterns.register();
        SpectrumCommon.logInfo("Registering Block / Item Color Registries...");
        ColorRegistry.registerColorRegistries();
        SpectrumCommon.logInfo("Registering Status Effects...");
        SpectrumStatusEffects.register();
        SpectrumStatusEffectTags.register();
        SpectrumCommon.logInfo("Registering Advancement Criteria...");
        SpectrumAdvancementCriteria.register();
        SpectrumCommon.logInfo("Registering Particle Types...");
        SpectrumParticleTypes.register();
        SpectrumCommon.logInfo("Registering Sound Events...");
        SpectrumSoundEvents.register();
        SpectrumCommon.logInfo("Registering Music...");
        SpectrumMusicType.register();
        SpectrumCommon.logInfo("Registering BlockSound Groups...");
        SpectrumBlockSoundGroups.register();
        SpectrumCommon.logInfo("Registering Fluids...");
        SpectrumFluids.register();
        SpectrumCommon.logInfo("Registering Enchantments...");
        SpectrumEnchantments.register();
        SpectrumCommon.logInfo("Registering Blocks...");
        SpectrumBlocks.register();
        SpectrumCommon.logInfo("Registering Items...");
        SpectrumPotions.register();
        SpectrumItems.register();
        SpectrumCommon.logInfo("Setting up server side Mod Compat...");
        SpectrumIntegrationPacks.register();
        SpectrumCommon.logInfo("Registering Block Entities...");
        SpectrumBlockEntities.register();
        SpectrumCommon.logInfo("Registering Worldgen Features...");
        SpectrumFeatures.register();
        SpectrumCommon.logInfo("Registering Configured and Placed Features...");
        SpectrumConfiguredFeatures.register();
        SpectrumCommon.logInfo("Registering Structure Types...");
        SpectrumStructureTypes.register();
        SpectrumCommon.logInfo("Registering Dimension...");
        SpectrumDimensions.register();
        SpectrumCommon.logInfo("Registering Recipe Types...");
        SpectrumRecipeTypes.registerSerializer();
        SpectrumCommon.logInfo("Registering Loot Conditions & Functions...");
        SpectrumLootConditionTypes.register();
        SpectrumLootFunctionTypes.register();
        SpectrumCommon.logInfo("Registering Containers...");
        SpectrumScreenHandlerIDs.register();
        SpectrumCommon.logInfo("Registering Screen Handler Types...");
        SpectrumScreenHandlerTypes.register();
        SpectrumCommon.logInfo("Registering Default Item Stack Damage Immunities...");
        SpectrumItemStackDamageImmunities.registerDefaultItemStackImmunities();
        SpectrumCommon.logInfo("Registering Enchantment Drops...");
        SpectrumLootPoolModifiers.setup();
        SpectrumCommon.logInfo("Registering Type Specific Predicates...");
        SpectrumTypeSpecificPredicates.register();
        SpectrumCommon.logInfo("Registering Items to Fuel Registry...");
        SpectrumItems.registerFuelRegistry();
        SpectrumCommon.logInfo("Registering Entities...");
        SpectrumTrackedDataHandlerRegistry.register();
        SpectrumEntityTypes.register();
        SpectrumEntityColorProcessors.register();
        SpectrumCommon.logInfo("Registering Commands...");
        SpectrumCommands.register();
        SpectrumCommon.logInfo("Registering Client To ServerPackage Receivers...");
        SpectrumC2SPacketReceiver.registerC2SReceivers();
        SpectrumCommon.logInfo("Registering Data Loaders...");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)NaturesStaffConversionDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)EntityFishingDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)CrystalApothecarySimulationsDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)ResonanceDropsDataLoader.INSTANCE);
        SpectrumCommon.logInfo("Adding to Fabric's Registries...");
        SpectrumFlammableBlocks.register();
        SpectrumStrippableBlocks.register();
        SpectrumTillableBlocks.register();
        SpectrumCompostableBlocks.register();
        SpectrumCommon.logInfo("Registering Game Events...");
        SpectrumGameEvents.register();
        SpectrumPositionSources.register();
        SpectrumCommon.logInfo("Registering Spell Effects...");
        InkSpellEffects.register();
        SpectrumCommon.logInfo("Registering Explosion Effects & Providers...");
        ExplosionModifiers.register();
        ExplosionModifierProviders.register();
        SpectrumCommon.logInfo("Registering Special Recipes...");
        SpectrumCustomRecipeSerializers.registerRecipeSerializers();
        SpectrumCommon.logInfo("Registering Dispenser, Resonance & Present Unwrap Behaviors...");
        SpectrumDispenserBehaviors.register();
        SpectrumPresentUnpackBehaviors.register();
        SpectrumResonanceProcessors.register();
        SpectrumCommon.logInfo("Registering Resource Conditions...");
        SpectrumResourceConditions.register();
        SpectrumCommon.logInfo("Registering Structure Pool Element Types...");
        SpectrumStructurePoolElementTypes.register();
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_1799 mainHandStack;
            class_1792 patt8629$temp;
            if (!world.field_9236 && !player.method_7325() && (patt8629$temp = (mainHandStack = player.method_6047()).method_7909()) instanceof ExchangeStaffItem) {
                Optional<class_2248> storedBlock;
                ExchangeStaffItem exchangeStaffItem = (ExchangeStaffItem)patt8629$temp;
                class_2680 targetBlockState = world.method_8320(pos);
                if (exchangeStaffItem.canInteractWith(targetBlockState, (class_1922)world, pos, player) && (storedBlock = ExchangeStaffItem.getStoredBlock(player.method_6047())).isPresent() && storedBlock.get() != targetBlockState.method_26204() && storedBlock.get().method_8389() != class_1802.field_8162 && ExchangeStaffItem.exchange(world, pos, player, storedBlock.get(), player.method_6047(), true, direction)) {
                    return class_1269.field_5812;
                }
                world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                SpectrumColorProviders.resetToggleableProviders();
                SpectrumMultiblocks.register();
            }
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                SpectrumAdvancementCriteria.BLOCK_BROKEN.trigger(serverPlayerEntity, state);
            }
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedEntityInteraction && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return handStack.method_7920(player, livingEntity, hand);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedBlockInteraction) {
                return handStack.method_7981(new class_1838(player, hand, hitResult));
            }
            return class_1269.field_5811;
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SpectrumCommon.logInfo("Fetching server instance...");
            minecraftServer = server;
            SpectrumCommon.logInfo("Registering MultiBlocks...");
            SpectrumMultiblocks.register();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            Pastel.clearServerInstance();
            minecraftServer = server;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> Pastel.getServerInstance().tick());
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (world.method_8510() % 100L == 0L && TimeHelper.getTimeOfDay((class_1937)world).isNight() && SpectrumCommon.CONFIG.ShootingStarWorlds.contains(world.method_27983().method_29177().toString())) {
                ShootingStarSpawner.INSTANCE.method_6445(world, true, true);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SpectrumCommon.logInfo("Querying fluid luminance...");
            Iterator it = class_2378.field_11146.method_10220().iterator();
            while (it.hasNext()) {
                class_2248 block = (class_2248)it.next();
                if (!(block instanceof class_2404)) continue;
                class_2404 fluidBlock = (class_2404)block;
                fluidLuminance.put(fluidBlock.method_9545(fluidBlock.method_9564()).method_15772(), fluidBlock.method_9564().method_26213());
            }
            SpectrumCommon.logInfo("Injecting additional recipes...");
            FirestarterMobBlock.addBlockSmeltingRecipes(server.method_3772());
            this.injectEnchantmentUpgradeRecipes(server);
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && (serverPlayerEntity = (class_3222)entity).method_7297() == 100 && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.WHISPY_CIRCLET)) {
                entity.method_6033(entity.method_6063());
                WhispyCircletItem.removeNegativeStatusEffects(entity);
            }
        });
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> {
            class_6862<class_1320> effectType;
            int oldInexorable = class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)previousStack);
            int newInexorable = class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)currentStack);
            class_6862<class_1320> class_68622 = effectType = equipmentSlot == class_1304.field_6174 ? SpectrumAttributeTags.INEXORABLE_ARMOR_EFFECTIVE : SpectrumAttributeTags.INEXORABLE_HANDHELD_EFFECTIVE;
            if (oldInexorable > 0 && newInexorable <= 0) {
                livingEntity.method_6026().stream().filter(instance -> {
                    class_1291 statusEffect = instance.method_5579();
                    Set attributes = statusEffect.method_5565().keySet();
                    return attributes.stream().anyMatch(attribute -> {
                        Optional attributeRegistryOptional = class_2378.field_23781.method_40266(effectType);
                        return attributeRegistryOptional.map(registryEntries -> registryEntries.method_40239().map(class_6880::comp_349).anyMatch(entityAttribute -> {
                            if (!statusEffect.method_5565().containsKey(entityAttribute)) {
                                return false;
                            }
                            double value = ((class_1322)statusEffect.method_5565().get(entityAttribute)).method_6186();
                            return value < 0.0;
                        })).orElse(false);
                    });
                }).forEach(instance -> instance.method_5579().method_5555(livingEntity, livingEntity.method_6127(), instance.method_5578()));
            }
        });
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, attributeModifiers) -> {
            int tightGripLevel;
            if (slot == class_1304.field_6173 && (tightGripLevel = class_1890.method_8225((class_1887)SpectrumEnchantments.TIGHT_GRIP, (class_1799)stack)) > 0) {
                float attackSpeedBonus = (float)tightGripLevel * SpectrumCommon.CONFIG.TightGripAttackSpeedBonusPercentPerLevel;
                class_1322 mod = new class_1322(UUID.fromString("b09d9b57-eefb-4499-9150-5d8d3e644a40"), "Tight Grip modifier", (double)attackSpeedBonus, class_1322.class_1323.field_6331);
                attributeModifiers.put((Object)class_5134.field_23723, (Object)mod);
            }
        });
        CrossbowShootingCallback.register((world, shooter, hand, crossbow, projectile, projectileEntity) -> {
            if (crossbow.method_7909() instanceof GlassCrestCrossbowItem && GlassCrestCrossbowItem.isOvercharged(crossbow) && !world.field_9236) {
                class_243 particleVelocity = projectileEntity.method_18798().method_1021(0.05);
                if (GlassCrestCrossbowItem.getOvercharge(crossbow) > 0.99f) {
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29645, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29643, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29642, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_28479, 5, class_243.field_1353, particleVelocity);
                    if (shooter instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)shooter;
                        Support.grantAdvancementCriterion(serverPlayerEntity, SpectrumCommon.locate("lategame/shoot_fully_overcharged_crossbow"), "shot_fully_overcharged_crossbow");
                    }
                    if (projectileEntity instanceof class_1665) {
                        class_1665 persistentProjectileEntity = (class_1665)projectileEntity;
                        persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() * 1.5);
                    }
                }
                SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_11248, 10, class_243.field_1353, particleVelocity);
                GlassCrestCrossbowItem.unOvercharge(crossbow);
            }
        });
        SpectrumCommon.logInfo("Registering RecipeCache reload listener");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = SpectrumCommon.locate("compacting_cache_clearer");

            public void method_14491(class_3300 manager) {
                CompactingChestBlockEntity.clearCache();
                if (minecraftServer != null) {
                    SpectrumCommon.this.injectEnchantmentUpgradeRecipes(minecraftServer);
                    FirestarterMobBlock.addBlockSmeltingRecipes(minecraftServer.method_3772());
                }
            }

            public class_2960 getFabricId() {
                return this.id;
            }
        });
        ItemStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, SpectrumBlockEntities.BOTTOMLESS_BUNDLE);
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.fluidStorage, SpectrumBlockEntities.FUSION_SHRINE);
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> blockEntity.fluidStorage, SpectrumBlockEntities.TITRATION_BARREL);
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (modContainer.isPresent()) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)SpectrumCommon.locate("spectrum_programmer_art"), (ModContainer)((ModContainer)modContainer.get()), (String)"Spectrum's Programmer Art", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)SpectrumCommon.locate("jinc"), (ModContainer)((ModContainer)modContainer.get()), (String)"Alternate Spectrum textures", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
        SpectrumCommon.logInfo("Common startup completed!");
    }

    public void injectEnchantmentUpgradeRecipes(MinecraftServer minecraftServer) {
        if (!EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.isEmpty()) {
            ImmutableMap collectedRecipes = (ImmutableMap)EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.stream().collect(ImmutableMap.toImmutableMap(GatedSpectrumRecipe::method_8114, enchantmentUpgradeRecipe -> enchantmentUpgradeRecipe));
            Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes = ((RecipeManagerAccessor)minecraftServer.method_3772()).getRecipes();
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Map<class_2960, class_1860<?>> r : recipes.values()) {
                newList.addAll(r.values());
            }
            for (class_1860 recipe : collectedRecipes.values()) {
                if (newList.contains(recipe)) continue;
                newList.add(recipe);
            }
            minecraftServer.method_3772().method_20702(newList);
        }
    }

    static {
        fluidLuminance = new HashMap();
    }
}

