/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.bottomless_bundle;

import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class BottomlessBundleBlockEntity
extends class_2586 {
    protected class_1799 bottomlessBundleStack;
    public final SingleVariantStorage<ItemVariant> storage = new SingleVariantStorage<ItemVariant>(){

        protected boolean canInsert(ItemVariant variant) {
            class_1799 bundledStack = BottomlessBundleItem.getFirstBundledStack(BottomlessBundleBlockEntity.this.bottomlessBundleStack);
            return bundledStack.method_7960() || variant.matches(bundledStack);
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((TransferVariant)insertedVariant, maxAmount, transaction);
            if (class_1890.method_8225((class_1887)SpectrumEnchantments.VOIDING, (class_1799)BottomlessBundleBlockEntity.this.bottomlessBundleStack) > 0) {
                return maxAmount;
            }
            return inserted;
        }

        protected ItemVariant getBlankVariant() {
            return ItemVariant.blank();
        }

        protected long getCapacity(ItemVariant variant) {
            return BottomlessBundleItem.getMaxStoredAmount(BottomlessBundleBlockEntity.this.bottomlessBundleStack);
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            BottomlessBundleBlockEntity.this.method_5431();
        }
    };

    public BottomlessBundleBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.BOTTOMLESS_BUNDLE, pos, state);
        this.bottomlessBundleStack = class_1799.field_8037;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.bottomlessBundleStack = class_1799.method_7915((class_2487)nbt.method_10562("Bundle"));
        this.storage.variant = ItemVariant.fromNbt((class_2487)nbt.method_10562("StorageVariant"));
        this.storage.amount = nbt.method_10537("StorageCount");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 bundleCompound = new class_2487();
        this.bottomlessBundleStack.method_7953(bundleCompound);
        nbt.method_10566("Bundle", (class_2520)bundleCompound);
        nbt.method_10566("StorageVariant", (class_2520)((ItemVariant)this.storage.variant).toNbt());
        nbt.method_10544("StorageCount", this.storage.amount);
    }

    public void setBundle(@NotNull class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BottomlessBundleItem) {
            this.bottomlessBundleStack = itemStack;
            this.storage.variant = ItemVariant.of((class_1799)BottomlessBundleItem.getFirstBundledStack(itemStack));
            this.storage.amount = BottomlessBundleItem.getStoredAmount(itemStack);
        }
    }

    public class_1799 retrieveBundle() {
        if (this.bottomlessBundleStack.method_7960()) {
            return SpectrumItems.BOTTOMLESS_BUNDLE.method_7854();
        }
        BottomlessBundleItem.setBundledStack(this.bottomlessBundleStack, ((ItemVariant)this.storage.getResource()).toStack(), (int)this.storage.amount);
        return this.bottomlessBundleStack;
    }
}

