/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.blocks.FilterConfigurable;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlock;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.listeners.EventQueue;
import de.dafuqs.spectrum.events.listeners.ExperienceOrbEventQueue;
import de.dafuqs.spectrum.events.listeners.ItemAndExperienceEventQueue;
import de.dafuqs.spectrum.events.listeners.ItemEntityEventQueue;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.BlackHoleChestScreenHandler;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackHoleChestBlockEntity
extends SpectrumChestBlockEntity
implements ExtendedScreenHandlerFactory,
class_1278,
EventQueue.Callback<Object> {
    public static final int INVENTORY_SIZE = 28;
    public static final int ITEM_FILTER_SLOT_COUNT = 5;
    public static final int EXPERIENCE_STORAGE_PROVIDER_ITEM_SLOT = 27;
    private static final int RANGE = 12;
    private final ItemAndExperienceEventQueue itemAndExperienceEventQueue;
    private final List<class_1792> filterItems;

    public BlackHoleChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.BLACK_HOLE_CHEST, blockPos, blockState);
        this.itemAndExperienceEventQueue = new ItemAndExperienceEventQueue((class_5716)new class_5707(this.field_11867), 12, this);
        this.filterItems = class_2371.method_10213((int)5, (Object)class_1802.field_8162);
    }

    public static void tick(@NotNull class_1937 world, class_2338 pos, class_2680 state, BlackHoleChestBlockEntity blockEntity) {
        if (world.field_9236) {
            blockEntity.lidAnimator.method_31672();
        } else {
            blockEntity.itemAndExperienceEventQueue.tick(world);
            if (world.method_8510() % 80L == 0L && !SpectrumChestBlock.isChestBlocked((class_1936)world, pos)) {
                BlackHoleChestBlockEntity.searchForNearbyEntities(blockEntity);
            }
        }
    }

    private static void searchForNearbyEntities(@NotNull BlackHoleChestBlockEntity blockEntity) {
        List itemEntities = blockEntity.field_11863.method_18023((class_5575)class_1299.field_6052, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1542 itemEntity : itemEntities) {
            if (!itemEntity.method_5805() || itemEntity.method_6983().method_7960()) continue;
            itemEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
        List experienceOrbEntities = blockEntity.field_11863.method_18023((class_5575)class_1299.field_6044, BlackHoleChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1303 experienceOrbEntity : experienceOrbEntities) {
            if (!experienceOrbEntity.method_5805()) continue;
            experienceOrbEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    protected static class_238 getBoxWithRadius(class_2338 blockPos, int radius) {
        return class_238.method_30048((class_243)class_243.method_24953((class_2382)blockPos), (double)radius, (double)radius, (double)radius);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.black_hole_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new BlackHoleChestScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        for (int i = 0; i < 5; ++i) {
            tag.method_10582("Filter" + i, class_2378.field_11142.method_10221((Object)this.filterItems.get(i)).toString());
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        for (int i = 0; i < 5; ++i) {
            if (!tag.method_10573("Filter" + i, 8)) continue;
            this.filterItems.set(i, (class_1792)class_2378.field_11142.method_10223(new class_2960(tag.method_10558("Filter" + i))));
        }
    }

    public int method_5439() {
        return 28;
    }

    public ItemAndExperienceEventQueue getEventListener() {
        return this.itemAndExperienceEventQueue;
    }

    @Override
    public boolean canAcceptEvent(class_1937 world, class_5714 listener, class_5712.class_7447 event, class_243 sourcePos) {
        if (SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867)) {
            return false;
        }
        class_1297 entity = event.method_43727().comp_713();
        if (entity instanceof class_1542) {
            return true;
        }
        return entity instanceof class_1303 && this.hasExperienceStorageItem();
    }

    @Override
    public void triggerEvent(class_1937 world, class_5714 listener, Object entry) {
        if (SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867)) {
            return;
        }
        if (entry instanceof ExperienceOrbEventQueue.EventEntry) {
            ExperienceOrbEventQueue.EventEntry experienceEntry = (ExperienceOrbEventQueue.EventEntry)entry;
            class_1303 experienceOrbEntity = experienceEntry.experienceOrbEntity;
            if (experienceOrbEntity != null && experienceOrbEntity.method_5805() && this.hasExperienceStorageItem()) {
                ExperienceStorageItem.addStoredExperience((class_1799)this.inventory.get(27), experienceOrbEntity.method_5919());
                BlackHoleChestBlockEntity.sendPlayExperienceOrbEntityAbsorbedParticle((class_3218)world, experienceOrbEntity);
                world.method_8396(null, experienceOrbEntity.method_24515(), class_3417.field_14627, class_3419.field_15245, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                experienceOrbEntity.method_5650(class_1297.class_5529.field_26999);
            }
        } else if (entry instanceof ItemEntityEventQueue.EventEntry) {
            ItemEntityEventQueue.EventEntry itemEntry = (ItemEntityEventQueue.EventEntry)entry;
            class_1542 itemEntity = itemEntry.itemEntity;
            if (itemEntity != null && itemEntity.method_5805() && this.acceptsItemStack(itemEntity.method_6983())) {
                int previousAmount = itemEntity.method_6983().method_7947();
                class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemEntity.method_6983(), (class_1263)this, class_2350.field_11036);
                if (remainingStack.method_7960()) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((class_3218)world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                    itemEntity.method_6979(class_1799.field_8037);
                    itemEntity.method_31472();
                } else if (remainingStack.method_7947() != previousAmount) {
                    BlackHoleChestBlockEntity.sendPlayItemEntityAbsorbedParticle((class_3218)world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                    itemEntity.method_6979(remainingStack);
                }
            }
        }
    }

    public static void sendPlayItemEntityAbsorbedParticle(class_3218 world, @NotNull class_1542 itemEntity) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, itemEntity.method_19538(), (class_2394)SpectrumParticleTypes.BLUE_BUBBLE_POP, 1, class_243.field_1353);
    }

    public static void sendPlayExperienceOrbEntityAbsorbedParticle(class_3218 world, @NotNull class_1303 experienceOrbEntity) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, experienceOrbEntity.method_19538(), (class_2394)SpectrumParticleTypes.GREEN_BUBBLE_POP, 1, class_243.field_1353);
    }

    @Override
    public class_3414 getOpenSound() {
        return SpectrumSoundEvents.BLACK_HOLE_CHEST_OPEN;
    }

    @Override
    public class_3414 getCloseSound() {
        return SpectrumSoundEvents.BLACK_HOLE_CHEST_CLOSE;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        FilterConfigurable.writeScreenOpeningData(buf, this.filterItems);
    }

    public List<class_1792> getItemFilters() {
        return this.filterItems;
    }

    public void setFilterItem(int slot, class_1792 item) {
        this.filterItems.set(slot, item);
        this.method_5431();
    }

    public boolean acceptsItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        boolean allAir = true;
        for (int i = 0; i < 5; ++i) {
            class_1792 filterItem = this.filterItems.get(i);
            if (filterItem.equals(itemStack.method_7909())) {
                return true;
            }
            if (filterItem.equals(class_1802.field_8162)) continue;
            allAir = false;
        }
        return allAir;
    }

    public boolean hasExperienceStorageItem() {
        return ((class_1799)this.inventory.get(27)).method_7909() instanceof ExperienceStorageItem;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.rangeClosed(0, 26).toArray();
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }
}

