/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.RestockingChestScreenHandler;
import de.dafuqs.spectrum.items.CraftingTabletItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class RestockingChestBlockEntity
extends SpectrumChestBlockEntity
implements class_1278 {
    public static final int INVENTORY_SIZE = 35;
    public static final int[] CHEST_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    public static final int[] RECIPE_SLOTS = new int[]{27, 28, 29, 30};
    public static final int[] RESULT_SLOTS = new int[]{31, 32, 33, 34};
    private int coolDownTicks = 0;

    public RestockingChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.RESTOCKING_CHEST, blockPos, blockState);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RestockingChestBlockEntity restockingChestBlockEntity) {
        if (world.field_9236) {
            restockingChestBlockEntity.lidAnimator.method_31672();
        } else if (RestockingChestBlockEntity.tickCooldown(restockingChestBlockEntity)) {
            for (int i = 0; i < 4; ++i) {
                boolean couldCraft;
                class_1799 outputItemStack = (class_1799)restockingChestBlockEntity.inventory.get(RESULT_SLOTS[i]);
                class_1799 craftingTabletItemStack = (class_1799)restockingChestBlockEntity.inventory.get(RECIPE_SLOTS[i]);
                if (craftingTabletItemStack.method_7960() || !outputItemStack.method_7960() && outputItemStack.method_7947() >= outputItemStack.method_7914() || !(couldCraft = restockingChestBlockEntity.tryCraft(restockingChestBlockEntity, i))) continue;
                restockingChestBlockEntity.setCooldown(restockingChestBlockEntity, 20);
                restockingChestBlockEntity.method_5431();
                return;
            }
        }
    }

    private static boolean tickCooldown(RestockingChestBlockEntity restockingChestBlockEntity) {
        --restockingChestBlockEntity.coolDownTicks;
        if (restockingChestBlockEntity.coolDownTicks > 0) {
            return false;
        }
        restockingChestBlockEntity.coolDownTicks = 0;
        return true;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.restocking_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new RestockingChestScreenHandler(syncId, playerInventory, (class_1263)this);
    }

    private void setCooldown(RestockingChestBlockEntity restockingChestBlockEntity, int cooldownTicks) {
        restockingChestBlockEntity.coolDownTicks = cooldownTicks;
    }

    private boolean tryCraft(RestockingChestBlockEntity restockingChestBlockEntity, int index) {
        class_1860<?> recipe;
        class_1799 craftingTabletItemStack = (class_1799)restockingChestBlockEntity.inventory.get(RECIPE_SLOTS[index]);
        if (craftingTabletItemStack.method_31574(SpectrumItems.CRAFTING_TABLET) && ((recipe = CraftingTabletItem.getStoredRecipe(this.field_11863, craftingTabletItemStack)) instanceof class_1867 || recipe instanceof class_1869)) {
            class_2371 ingredients = recipe.method_8117();
            class_1799 outputItemStack = recipe.method_8110();
            class_1799 currentItemStack = (class_1799)restockingChestBlockEntity.inventory.get(RESULT_SLOTS[index]);
            if (InventoryHelper.canCombineItemStacks(currentItemStack, outputItemStack) && InventoryHelper.hasInInventory((List<class_1856>)ingredients, (class_1263)restockingChestBlockEntity)) {
                List<class_1799> remainders = InventoryHelper.removeFromInventoryWithRemainders((List<class_1856>)ingredients, (class_1263)restockingChestBlockEntity);
                if (currentItemStack.method_7960()) {
                    restockingChestBlockEntity.inventory.set(RESULT_SLOTS[index], (Object)outputItemStack.method_7972());
                } else {
                    currentItemStack.method_7933(outputItemStack.method_7947());
                }
                for (class_1799 remainder : remainders) {
                    InventoryHelper.smartAddToInventory(remainder, (class_1263)restockingChestBlockEntity, null);
                }
                return true;
            }
        }
        return false;
    }

    public int method_5439() {
        return 35;
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("cooldown", this.coolDownTicks);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("cooldown")) {
            this.coolDownTicks = tag.method_10550("cooldown");
        }
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return RESULT_SLOTS;
        }
        return CHEST_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot <= CHEST_SLOTS[CHEST_SLOTS.length - 1];
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }
}

