/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.decay;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.decay.DecayAwayBlock;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DecayBlock
extends class_2248 {
    public static final class_2754<Conversion> CONVERSION = class_2754.method_11850((String)"conversion", Conversion.class);
    protected final float spreadChance;
    protected final boolean canSpreadToBlockEntities;
    protected final float damageOnTouching;
    protected final int tier;

    public DecayBlock(class_4970.class_2251 settings, float spreadChance, boolean canSpreadToBlockEntities, int tier, float damageOnTouching) {
        super(settings);
        this.spreadChance = spreadChance;
        this.canSpreadToBlockEntities = canSpreadToBlockEntities;
        this.damageOnTouching = damageOnTouching;
        this.tier = tier;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{CONVERSION});
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (entity instanceof class_1309 && !entity.method_5753() && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(SpectrumDamageSources.DECAY, this.damageOnTouching);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236 && SpectrumCommon.CONFIG.LogPlacingOfDecay && placer != null) {
            SpectrumCommon.logInfo(state.method_26204().method_9518().getString() + " was placed in " + world.method_27983().method_29177() + " at " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + " by " + placer.method_5820());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Conversion)((Object)state.method_11654(CONVERSION))).equals((Object)Conversion.SPECIAL)) {
            world.method_8406((class_2394)new class_2388(class_2398.field_11217, state), (double)((float)pos.method_10263() + random.method_43057()), (double)(pos.method_10264() + 1), (double)((float)pos.method_10260() + random.method_43057()), 0.0, 0.0, 0.0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpreadTo(class_1937 world, class_2338 targetBlockPos, class_2680 stateAtTargetPos) {
        class_2248 class_22482;
        if (SpectrumCommon.CONFIG.DecayIsStoppedByClaimMods && !GenericClaimModsCompat.canModify(world, targetBlockPos, null)) {
            return false;
        }
        if (!this.canSpreadToBlockEntities) {
            if (world.method_8321(targetBlockPos) != null) return false;
        }
        if ((class_22482 = stateAtTargetPos.method_26204()) instanceof DecayBlock) {
            DecayBlock decayBlock = (DecayBlock)class_22482;
            if (this.tier <= decayBlock.tier) return false;
        }
        if (stateAtTargetPos.method_26204() == class_2246.field_9987) return true;
        if (!(stateAtTargetPos.method_26204().method_36555() > -1.0f)) return false;
        if (!(stateAtTargetPos.method_26204().method_9520() < 10000.0f)) return false;
        return true;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 previousBlock, class_2338 fromPos, boolean notify) {
        class_2680 spreadState;
        class_2680 updatedState;
        class_2248 updatedBlock;
        super.method_9612(state, world, pos, previousBlock, fromPos, notify);
        if (previousBlock == class_2246.field_10124 && !((updatedBlock = (updatedState = world.method_8320(fromPos)).method_26204()) instanceof DecayBlock) && !(updatedBlock instanceof DecayAwayBlock) && (spreadState = this.getSpreadState(state, updatedState, world, fromPos)) != null) {
            world.method_39280(pos, (class_2248)this, 40 + world.field_9229.method_43048(200), class_1953.field_9311);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.method_9514(state, world, pos, random);
        this.trySpreadToRandomNeighboringBlock(state, world, pos);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.spreadChance < 1.0f && random.method_43057() > this.spreadChance) {
            return;
        }
        class_2350 randomDirection = class_2350.method_10162((class_5819)random);
        this.trySpreadInDirection((class_1937)world, state, pos, randomDirection);
    }

    private void trySpreadToRandomNeighboringBlock(class_2680 state, class_3218 world, class_2338 pos) {
        class_2350 direction;
        ArrayList<class_2350> directions = new ArrayList<class_2350>(List.of(class_2350.values()));
        Collections.shuffle(directions);
        Iterator iterator = directions.iterator();
        while (iterator.hasNext() && !this.trySpreadInDirection((class_1937)world, state, pos, direction = (class_2350)iterator.next())) {
        }
    }

    protected boolean trySpreadInDirection(@NotNull class_1937 world, class_2680 state, @NotNull class_2338 originPos, class_2350 direction) {
        class_2680 targetBlockState;
        class_2338 targetPos = originPos.method_10093(direction);
        if (this.canSpreadTo(world, targetPos, targetBlockState = world.method_8320(targetPos))) {
            @Nullable class_2680 spreadState = this.getSpreadState(state, targetBlockState, world, targetPos);
            if (spreadState != null) {
                world.method_8501(targetPos, spreadState);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract class_2680 getSpreadState(class_2680 var1, class_2680 var2, class_1937 var3, class_2338 var4);

    public static enum Conversion implements class_3542
    {
        NONE("none"),
        DEFAULT("default"),
        SPECIAL("special");

        private final String name;

        private Conversion(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

