/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.enchanter;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlock;
import de.dafuqs.spectrum.blocks.item_bowl.ItemBowlBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.compat.biome_makeover.BiomeMakeoverCompat;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.helpers.ExperienceHelper;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.CraftingBlockSoundInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter {
    public static final List<class_2382> ITEM_BOWL_OFFSETS = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(5, 0, -3));
            this.add(new class_2382(5, 0, 3));
            this.add(new class_2382(3, 0, 5));
            this.add(new class_2382(-3, 0, 5));
            this.add(new class_2382(-5, 0, 3));
            this.add(new class_2382(-5, 0, -3));
            this.add(new class_2382(-3, 0, -5));
            this.add(new class_2382(3, 0, -5));
        }
    };
    public static final int REQUIRED_TICKS_FOR_EACH_EXPERIENCE_POINT = 4;
    public static final class_2960 APPLY_CONFLICTING_ENCHANTMENTS_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("milestones/unlock_conflicted_enchanting_with_enchanter");
    public static final class_2960 OVERENCHANTING_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("milestones/unlock_overenchanting_with_enchanter");
    public static final int INVENTORY_SIZE = 2;
    protected UUID ownerUUID;
    protected boolean canOwnerApplyConflictingEnchantments;
    protected boolean canOwnerOverenchant;
    protected class_1277 virtualInventoryIncludingBowlStacks = new class_1277(10);
    protected int virtualInventoryRecipeOrientation;
    protected boolean inventoryChanged;
    private Upgradeable.UpgradeHolder upgrades;
    private GatedSpectrumRecipe currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private int currentItemProcessingTime = -1;
    @Nullable
    private class_2350 itemFacing;

    public EnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.ENCHANTER, pos, state, 2);
    }

    public static void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.currentRecipe != null) {
            class_1799 experienceStack = enchanterBlockEntity.method_5438(1);
            if (!experienceStack.method_7960() && experienceStack.method_7909() instanceof ExperienceStorageItem) {
                int experience = ExperienceStorageItem.getStoredExperience(experienceStack);
                int amount = ExperienceHelper.getExperienceOrbSizeForExperience(experience);
                if (world.field_9229.method_43048(10) < amount) {
                    float randomX = 0.2f + world.method_8409().method_43057() * 0.6f;
                    float randomZ = 0.2f + world.method_8409().method_43057() * 0.6f;
                    float randomY = -0.1f + world.method_8409().method_43057() * 0.4f;
                    world.method_8406((class_2394)SpectrumParticleTypes.LIME_SPARKLE_RISING, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 2.5 + (double)randomY, (double)((float)blockPos.method_10260() + randomZ), 0.0, -0.1, 0.0);
                }
            }
        } else if (enchanterBlockEntity.currentItemProcessingTime > -1) {
            float randomX = 0.2f + world.method_8409().method_43057() * 0.6f;
            float randomZ = 0.2f + world.method_8409().method_43057() * 0.6f;
            float randomY = -0.2f + world.method_8409().method_43057() * 0.4f;
            world.method_8406((class_2394)SpectrumParticleTypes.LIME_SPARKLE_RISING, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 2.5 + (double)randomY, (double)((float)blockPos.method_10260() + randomZ), 0.0, -0.1, 0.0);
            if (world.method_8510() % 12L == 0L) {
                ((class_638)world).method_2947(enchanterBlockEntity.field_11867, class_3417.field_14627, class_3419.field_15245, 0.8f * SpectrumCommon.CONFIG.BlockSoundVolume, 0.8f + world.field_9229.method_43057() * 0.4f, true);
                enchanterBlockEntity.doItemBowlOrbs(world);
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.upgrades == null) {
            enchanterBlockEntity.calculateUpgrades();
        }
        if (enchanterBlockEntity.inventoryChanged) {
            EnchanterBlockEntity.calculateCurrentRecipe(world, enchanterBlockEntity);
            if (enchanterBlockEntity.currentRecipe == null) {
                int requiredExperience;
                enchanterBlockEntity.currentItemProcessingTime = EnchanterBlockEntity.isValidCenterEnchantingSetup(enchanterBlockEntity) ? ((requiredExperience = EnchanterBlockEntity.getRequiredExperienceToEnchantCenterItem(enchanterBlockEntity)) > 0 ? requiredExperience * 4 : -1) : -1;
                enchanterBlockEntity.updateInClientWorld();
            }
            enchanterBlockEntity.inventoryChanged = false;
        }
        boolean craftingSuccess = false;
        if (enchanterBlockEntity.currentRecipe != null || enchanterBlockEntity.currentItemProcessingTime > 1) {
            GatedSpectrumRecipe gatedSpectrumRecipe;
            if (enchanterBlockEntity.craftingTime % 60 == 1 && !EnchanterBlockEntity.checkRecipeRequirements(world, blockPos, enchanterBlockEntity)) {
                enchanterBlockEntity.craftingTime = 0;
                SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)enchanterBlockEntity.field_11863, enchanterBlockEntity.field_11867);
                return;
            }
            if (enchanterBlockEntity.craftingTime == 1) {
                SpectrumS2CPacketSender.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.ENCHANTER_WORKING, (class_3218)enchanterBlockEntity.field_11863, enchanterBlockEntity.field_11867, Integer.MAX_VALUE);
            }
            if ((gatedSpectrumRecipe = enchanterBlockEntity.currentRecipe) instanceof EnchanterRecipe) {
                EnchanterRecipe enchanterRecipe = (EnchanterRecipe)gatedSpectrumRecipe;
                ++enchanterBlockEntity.craftingTime;
                if (enchanterBlockEntity.craftingTime == enchanterBlockEntity.craftingTimeTotal - 20) {
                    enchanterBlockEntity.doItemBowlOrbs(world);
                } else if (enchanterBlockEntity.craftingTime == enchanterBlockEntity.craftingTimeTotal) {
                    EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                    EnchanterBlockEntity.craftEnchanterRecipe(world, enchanterBlockEntity, enchanterRecipe);
                    craftingSuccess = true;
                }
                enchanterBlockEntity.method_5431();
            } else {
                gatedSpectrumRecipe = enchanterBlockEntity.currentRecipe;
                if (gatedSpectrumRecipe instanceof EnchantmentUpgradeRecipe) {
                    EnchantmentUpgradeRecipe enchantmentUpgradeRecipe = (EnchantmentUpgradeRecipe)gatedSpectrumRecipe;
                    ++enchanterBlockEntity.currentItemProcessingTime;
                    if (enchanterBlockEntity.currentItemProcessingTime == 4) {
                        enchanterBlockEntity.currentItemProcessingTime = 0;
                        int consumedItems = EnchanterBlockEntity.tickEnchantmentUpgradeRecipe(world, enchanterBlockEntity, enchantmentUpgradeRecipe, enchanterBlockEntity.craftingTimeTotal - enchanterBlockEntity.craftingTime);
                        if (consumedItems == 0) {
                            enchanterBlockEntity.inventoryChanged();
                        } else {
                            enchanterBlockEntity.craftingTime += consumedItems;
                            if (enchanterBlockEntity.craftingTime >= enchanterBlockEntity.craftingTimeTotal) {
                                EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                                EnchanterBlockEntity.craftEnchantmentUpgradeRecipe(world, enchanterBlockEntity, enchantmentUpgradeRecipe);
                                craftingSuccess = true;
                            }
                        }
                    }
                    enchanterBlockEntity.method_5431();
                } else if (enchanterBlockEntity.currentItemProcessingTime > -1) {
                    boolean drained;
                    int speedTicks = Support.getIntFromDecimalWithChance(enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED), world.field_9229);
                    enchanterBlockEntity.craftingTime += speedTicks;
                    if (world.method_8510() % 4L == 0L && !(drained = enchanterBlockEntity.drainExperience(speedTicks))) {
                        enchanterBlockEntity.currentItemProcessingTime = -1;
                        enchanterBlockEntity.updateInClientWorld();
                    }
                    if (enchanterBlockEntity.currentItemProcessingTime > 0 && enchanterBlockEntity.craftingTime >= enchanterBlockEntity.currentItemProcessingTime) {
                        EnchanterBlockEntity.playCraftingFinishedEffects(enchanterBlockEntity);
                        EnchanterBlockEntity.enchantCenterItem(enchanterBlockEntity);
                        enchanterBlockEntity.currentItemProcessingTime = -1;
                        enchanterBlockEntity.craftingTime = 0;
                        enchanterBlockEntity.updateInClientWorld();
                        craftingSuccess = true;
                    }
                    enchanterBlockEntity.method_5431();
                }
            }
            if (craftingSuccess) {
                enchanterBlockEntity.currentItemProcessingTime = -1;
                enchanterBlockEntity.craftingTime = 0;
                enchanterBlockEntity.inventoryChanged();
            }
        }
    }

    public static boolean isValidCenterEnchantingSetup(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        class_1799 centerStack = enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(0);
        boolean isEnchantableBookInCenter = SpectrumEnchantmentHelper.isEnchantableBook(centerStack);
        if (!centerStack.method_7960() && (isEnchantableBookInCenter || centerStack.method_7909().method_7870(centerStack)) && enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(1).method_7909() instanceof ExperienceStorageItem) {
            boolean centerStackIsGildedBook = centerStack.method_31574(SpectrumItems.GILDED_BOOK);
            boolean enchantedBookWithAdditionalEnchantmentsFound = false;
            Map existingEnchantments = class_1890.method_8222((class_1799)centerStack);
            block0: for (int i = 0; i < 8; ++i) {
                class_1799 virtualSlotStack = enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(2 + i);
                if (virtualSlotStack.method_7960()) continue;
                if (centerStackIsGildedBook || virtualSlotStack.method_7909() instanceof class_1772) {
                    Map currentEnchantedBookEnchantments = class_1890.method_8222((class_1799)virtualSlotStack);
                    for (class_1887 enchantment : currentEnchantedBookEnchantments.keySet()) {
                        if (!isEnchantableBookInCenter && !enchantment.method_8192(centerStack) || existingEnchantments.containsKey(enchantment) && (Integer)existingEnchantments.get(enchantment) >= (Integer)currentEnchantedBookEnchantments.get(enchantment)) continue;
                        if (enchanterBlockEntity.canOwnerApplyConflictingEnchantments) {
                            enchantedBookWithAdditionalEnchantmentsFound = true;
                            continue block0;
                        }
                        if (!SpectrumEnchantmentHelper.canCombineAny(existingEnchantments, currentEnchantedBookEnchantments)) continue;
                        enchantedBookWithAdditionalEnchantmentsFound = true;
                        continue block0;
                    }
                    continue;
                }
                return false;
            }
            return enchantedBookWithAdditionalEnchantmentsFound;
        }
        return false;
    }

    public static void playCraftingFinishedEffects(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        enchanterBlockEntity.field_11863.method_8396(null, enchanterBlockEntity.field_11867, class_3417.field_14709, class_3419.field_15245, 1.0f, 1.0f);
        SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)enchanterBlockEntity.field_11863, new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 0.5, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5), (class_2394)SpectrumParticleTypes.LIME_SPARKLE_RISING, 75, new class_243(0.5, 0.5, 0.5), new class_243(0.1, -0.1, 0.1));
    }

    private static boolean checkRecipeRequirements(class_1937 world, class_2338 blockPos, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        class_1657 lastInteractedPlayer = enchanterBlockEntity.getOwnerIfOnline();
        if (lastInteractedPlayer == null) {
            return false;
        }
        boolean playerCanCraft = true;
        GatedSpectrumRecipe gatedSpectrumRecipe = enchanterBlockEntity.currentRecipe;
        if (gatedSpectrumRecipe instanceof EnchanterRecipe) {
            EnchanterRecipe enchanterRecipe = (EnchanterRecipe)gatedSpectrumRecipe;
            playerCanCraft = enchanterRecipe.canPlayerCraft(lastInteractedPlayer);
        } else {
            gatedSpectrumRecipe = enchanterBlockEntity.currentRecipe;
            if (gatedSpectrumRecipe instanceof EnchantmentUpgradeRecipe) {
                EnchantmentUpgradeRecipe enchantmentUpgradeRecipe = (EnchantmentUpgradeRecipe)gatedSpectrumRecipe;
                playerCanCraft = enchantmentUpgradeRecipe.canPlayerCraft(lastInteractedPlayer) && (enchanterBlockEntity.canOwnerOverenchant || !enchantmentUpgradeRecipe.requiresUnlockedOverEnchanting());
            }
        }
        boolean structureComplete = EnchanterBlock.verifyStructure(world, blockPos, null);
        if (!playerCanCraft || !structureComplete) {
            if (!structureComplete) {
                world.method_8396(null, enchanterBlockEntity.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + enchanterBlockEntity.field_11863.field_9229.method_43057() * 0.2f, 0.9f + enchanterBlockEntity.field_11863.field_9229.method_43057() * 0.2f);
                world.method_8396(null, enchanterBlockEntity.method_11016(), class_3417.field_15197, class_3419.field_15245, 0.9f + enchanterBlockEntity.field_11863.field_9229.method_43057() * 0.2f, 0.5f + enchanterBlockEntity.field_11863.field_9229.method_43057() * 0.2f);
                EnchanterBlock.scatterContents(world, blockPos);
            }
            return false;
        }
        return true;
    }

    public static void enchantCenterItem(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        class_1799 centerStack = enchanterBlockEntity.method_5438(0);
        class_1799 centerStackCopy = centerStack.method_7972();
        Map<class_1887, Integer> highestEnchantments = EnchanterBlockEntity.getHighestEnchantmentsInItemBowls(enchanterBlockEntity);
        for (class_1887 enchantment : highestEnchantments.keySet()) {
            centerStackCopy = SpectrumEnchantmentHelper.addOrExchangeEnchantment(centerStackCopy, enchantment, highestEnchantments.get(enchantment), false, enchanterBlockEntity.canOwnerApplyConflictingEnchantments);
        }
        for (int i = 0; i < 8; ++i) {
            class_1799 bowlStack = enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(2 + i);
            BiomeMakeoverCompat.transferBMCursedTag(bowlStack, centerStackCopy);
        }
        int spentExperience = enchanterBlockEntity.currentItemProcessingTime / 4;
        if (centerStack.method_7947() > 1) {
            centerStackCopy.method_7939(1);
            MultiblockCrafter.spawnOutputAsItemEntity(enchanterBlockEntity.field_11863, enchanterBlockEntity.field_11867, centerStackCopy);
            centerStack.method_7934(1);
        } else {
            enchanterBlockEntity.method_5447(0, centerStackCopy);
        }
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(enchanterBlockEntity.ownerUUID, centerStackCopy, spentExperience);
        class_3222 serverPlayerEntity = (class_3222)enchanterBlockEntity.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.ENCHANTER_ENCHANTING.trigger(serverPlayerEntity, centerStackCopy, spentExperience);
        }
    }

    public static Map<class_1887, Integer> getHighestEnchantmentsInItemBowls(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        ArrayList<class_1799> bowlStacks = new ArrayList<class_1799>();
        for (int i = 0; i < 8; ++i) {
            bowlStacks.add(enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(2 + i));
        }
        return SpectrumEnchantmentHelper.collectHighestEnchantments(bowlStacks);
    }

    public static int getRequiredExperienceToEnchantCenterItem(@NotNull EnchanterBlockEntity enchanterBlockEntity) {
        boolean valid = false;
        class_1799 centerStack = enchanterBlockEntity.method_5438(0);
        if (!centerStack.method_7960() && (centerStack.method_7909().method_7870(centerStack) || SpectrumEnchantmentHelper.isEnchantableBook(centerStack))) {
            class_1799 centerStackCopy = centerStack.method_7972();
            Map<class_1887, Integer> highestEnchantmentLevels = EnchanterBlockEntity.getHighestEnchantmentsInItemBowls(enchanterBlockEntity);
            int requiredExperience = 0;
            for (class_1887 enchantment : highestEnchantmentLevels.keySet()) {
                int enchantmentLevel;
                int currentRequired = EnchanterBlockEntity.getRequiredExperienceToEnchantWithEnchantment(centerStackCopy, enchantment, enchantmentLevel = highestEnchantmentLevels.get(enchantment).intValue(), enchanterBlockEntity.canOwnerApplyConflictingEnchantments);
                if (currentRequired > 0) {
                    centerStackCopy = SpectrumEnchantmentHelper.addOrExchangeEnchantment(centerStackCopy, enchantment, enchantmentLevel, false, enchanterBlockEntity.canOwnerApplyConflictingEnchantments);
                    requiredExperience += currentRequired;
                    valid = true;
                    continue;
                }
                requiredExperience += 50;
            }
            if (valid) {
                return requiredExperience;
            }
            return -1;
        }
        return -1;
    }

    public static int getRequiredExperienceToEnchantWithEnchantment(class_1799 stack, class_1887 enchantment, int level, boolean allowEnchantmentConflicts) {
        if (!enchantment.method_8192(stack) && !SpectrumEnchantmentHelper.isEnchantableBook(stack)) {
            return -1;
        }
        int existingLevel = class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
        if (existingLevel >= level) {
            return -1;
        }
        boolean conflicts = SpectrumEnchantmentHelper.hasEnchantmentThatConflictsWith(stack, enchantment);
        if (conflicts && !allowEnchantmentConflicts) {
            return -1;
        }
        Integer requiredExperience = EnchanterBlockEntity.getEnchantingPrice(stack, enchantment, level);
        if (conflicts) {
            requiredExperience = requiredExperience * 4;
        }
        return requiredExperience;
    }

    public static Integer getEnchantingPrice(class_1799 stack, class_1887 enchantment, int level) {
        int enchantability = Math.max(1, stack.method_7909().method_7837());
        if (enchantment.method_8192(stack) || SpectrumEnchantmentHelper.isEnchantableBook(stack)) {
            return EnchanterBlockEntity.getRequiredExperienceForEnchantment(enchantability, enchantment, level);
        }
        return -1;
    }

    public static int getRequiredExperienceForEnchantment(int enchantability, class_1887 enchantment, int level) {
        if (enchantability > 0) {
            class_1887.class_1888 rarity = enchantment.method_8186();
            int rarityCost = switch (rarity) {
                case class_1887.class_1888.field_9087 -> 10;
                case class_1887.class_1888.field_9090 -> 25;
                case class_1887.class_1888.field_9088 -> 50;
                default -> 80;
            };
            float levelCost = (float)level + (float)level / (float)enchantment.method_8183();
            float specialMulti = enchantment.method_8193() ? 2.0f : (enchantment.method_8195() ? 1.5f : 1.0f);
            float selectionAvailabilityMod = 1.0f;
            if (!(enchantment instanceof SpectrumEnchantment)) {
                selectionAvailabilityMod = (enchantment.method_25950() ? 0.5f : 0.75f) + (enchantment.method_25949() ? 0.5f : 0.75f);
            }
            float enchantabilityMod = 4.0f / (float)(2 + enchantability) * 4.0f;
            return (int)Math.floor((float)rarityCost * levelCost * specialMulti * selectionAvailabilityMod * enchantabilityMod);
        }
        return -1;
    }

    public static int getExperienceWithMod(int experience, double mod, class_5819 random) {
        double modNormalized = 1.0 / (1.0 + Math.log10(mod));
        return Support.getIntFromDecimalWithChance((double)experience * modNormalized, random);
    }

    public static void craftEnchanterRecipe(class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity, @NotNull EnchanterRecipe enchanterRecipe) {
        enchanterBlockEntity.drainExperience(enchanterRecipe.getRequiredExperience());
        for (int i = 0; i < 8; ++i) {
            class_2338 itemBowlPos;
            class_2586 blockEntity;
            int resultAmountAfterEfficiencyMod = 1;
            if (!enchanterRecipe.areYieldAndEfficiencyUpgradesDisabled() && (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
                double efficiencyModifier = 1.0 / (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                resultAmountAfterEfficiencyMod = Support.getIntFromDecimalWithChance(efficiencyModifier, enchanterBlockEntity.field_11863.field_9229);
            }
            if (resultAmountAfterEfficiencyMod <= 0 || !((blockEntity = world.method_8321(itemBowlPos = enchanterBlockEntity.field_11867.method_10081(EnchanterBlockEntity.getItemBowlPositionOffset(i, enchanterBlockEntity.virtualInventoryRecipeOrientation)))) instanceof ItemBowlBlockEntity)) continue;
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.decrementBowlStack(new class_243((double)enchanterBlockEntity.field_11867.method_10263(), (double)(enchanterBlockEntity.field_11867.method_10264() + 1), (double)enchanterBlockEntity.field_11867.method_10263() + 0.5), resultAmountAfterEfficiencyMod, false);
            itemBowlBlockEntity.updateInClientWorld();
        }
        class_1799 resultStack = enchanterRecipe.method_8110().method_7972();
        class_1799 existingCenterStack = enchanterBlockEntity.method_5438(0);
        if (!enchanterRecipe.areYieldAndEfficiencyUpgradesDisabled() && (double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD) != 1.0) {
            int resultCountMod = Support.getIntFromDecimalWithChance((float)resultStack.method_7947() * enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD), world.field_9229);
            resultStack.method_7939(resultCountMod);
        }
        if (existingCenterStack.method_7947() > 1) {
            existingCenterStack.method_7934(1);
            MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, enchanterBlockEntity.field_11867, resultStack, resultStack.method_7947(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
        } else {
            enchanterBlockEntity.method_5447(0, resultStack);
        }
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(enchanterBlockEntity.ownerUUID, resultStack, enchanterRecipe.getRequiredExperience());
        class_3222 serverPlayerEntity = (class_3222)enchanterBlockEntity.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.ENCHANTER_CRAFTING.trigger(serverPlayerEntity, resultStack, enchanterRecipe.getRequiredExperience());
        }
    }

    public static int tickEnchantmentUpgradeRecipe(class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity, @NotNull EnchantmentUpgradeRecipe enchantmentUpgradeRecipe, int itemsToConsumeLeft) {
        int itemCountToConsume = Math.min(itemsToConsumeLeft, Support.getIntFromDecimalWithChance(enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED), world.field_9229));
        int consumedAmount = 0;
        int bowlsChecked = 0;
        int randomBowlPosition = world.field_9229.method_43048(8);
        int itemCountToConsumeAfterMod = itemCountToConsume;
        if ((double)enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY) != 1.0) {
            itemCountToConsumeAfterMod = Support.getIntFromDecimalWithChance((float)itemCountToConsume / enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY), world.field_9229);
        }
        while (consumedAmount < itemCountToConsumeAfterMod && bowlsChecked < 8 || itemCountToConsumeAfterMod == 0 & consumedAmount == 0) {
            class_2382 bowlOffset = EnchanterBlockEntity.getItemBowlPositionOffset(randomBowlPosition + bowlsChecked, enchanterBlockEntity.virtualInventoryRecipeOrientation);
            class_2586 blockEntity = world.method_8321(enchanterBlockEntity.field_11867.method_10081(bowlOffset));
            if (blockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
                if (itemCountToConsumeAfterMod == 0) {
                    itemBowlBlockEntity.spawnOrbParticles(new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 1.0, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5));
                    consumedAmount += itemCountToConsume;
                } else {
                    int decrementedAmount = itemBowlBlockEntity.decrementBowlStack(new class_243((double)enchanterBlockEntity.field_11867.method_10263() + 0.5, (double)enchanterBlockEntity.field_11867.method_10264() + 1.0, (double)enchanterBlockEntity.field_11867.method_10260() + 0.5), itemCountToConsumeAfterMod, true);
                    consumedAmount += decrementedAmount;
                }
            }
            ++bowlsChecked;
        }
        return consumedAmount;
    }

    public static void craftEnchantmentUpgradeRecipe(class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity, @NotNull EnchantmentUpgradeRecipe enchantmentUpgradeRecipe) {
        enchanterBlockEntity.drainExperience(enchantmentUpgradeRecipe.getRequiredExperience());
        class_1799 resultStack = enchanterBlockEntity.method_5438(0);
        resultStack = SpectrumEnchantmentHelper.addOrExchangeEnchantment(resultStack, enchantmentUpgradeRecipe.getEnchantment(), enchantmentUpgradeRecipe.getEnchantmentDestinationLevel(), false, true);
        enchanterBlockEntity.method_5447(0, resultStack);
        EnchanterBlockEntity.grantPlayerEnchantingAdvancementCriterion(enchanterBlockEntity.ownerUUID, resultStack, enchantmentUpgradeRecipe.getRequiredExperience());
        class_3222 serverPlayerEntity = (class_3222)enchanterBlockEntity.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.ENCHANTER_UPGRADING.trigger(serverPlayerEntity, enchantmentUpgradeRecipe.getEnchantment(), enchantmentUpgradeRecipe.getEnchantmentDestinationLevel(), enchantmentUpgradeRecipe.getRequiredExperience());
        }
    }

    public static class_2382 getItemBowlPositionOffset(int index, int orientation) {
        int offset = (orientation * 2 + index) % 8;
        return ITEM_BOWL_OFFSETS.get(offset);
    }

    private static void calculateCurrentRecipe(@NotNull class_1937 world, @NotNull EnchanterBlockEntity enchanterBlockEntity) {
        if (enchanterBlockEntity.currentRecipe != null && enchanterBlockEntity.currentRecipe.method_8115((class_1263)enchanterBlockEntity.virtualInventoryIncludingBowlStacks, world)) {
            return;
        }
        enchanterBlockEntity.craftingTime = 0;
        GatedSpectrumRecipe previousRecipe = enchanterBlockEntity.currentRecipe;
        enchanterBlockEntity.currentRecipe = null;
        int previousOrientation = enchanterBlockEntity.virtualInventoryRecipeOrientation;
        class_1277 recipeTestInventory = new class_1277(enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5439());
        recipeTestInventory.method_5447(0, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(0));
        recipeTestInventory.method_5447(1, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438(1));
        EnchantmentUpgradeRecipe enchantmentUpgradeRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, (class_1263)enchanterBlockEntity.virtualInventoryIncludingBowlStacks, world).orElse(null);
        if (enchantmentUpgradeRecipe == null) {
            for (int orientation = 0; orientation < 4; ++orientation) {
                int offset = orientation * 2;
                recipeTestInventory.method_5447(2, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 8) % 8 + 2));
                recipeTestInventory.method_5447(3, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 1 + 8) % 8 + 2));
                recipeTestInventory.method_5447(4, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 2 + 8) % 8 + 2));
                recipeTestInventory.method_5447(5, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 3 + 8) % 8 + 2));
                recipeTestInventory.method_5447(6, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 4 + 8) % 8 + 2));
                recipeTestInventory.method_5447(7, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 5 + 8) % 8 + 2));
                recipeTestInventory.method_5447(8, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 6 + 8) % 8 + 2));
                recipeTestInventory.method_5447(9, enchanterBlockEntity.virtualInventoryIncludingBowlStacks.method_5438((offset + 7 + 8) % 8 + 2));
                EnchanterRecipe enchanterRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.ENCHANTER, (class_1263)recipeTestInventory, world).orElse(null);
                if (enchanterRecipe == null) continue;
                enchanterBlockEntity.currentRecipe = enchanterRecipe;
                enchanterBlockEntity.virtualInventoryRecipeOrientation = orientation;
                enchanterBlockEntity.virtualInventoryIncludingBowlStacks = recipeTestInventory;
                enchanterBlockEntity.craftingTimeTotal = (int)Math.ceil((float)enchanterRecipe.getCraftingTime() / enchanterBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                break;
            }
        } else if (enchanterBlockEntity.canOwnerOverenchant || !enchantmentUpgradeRecipe.requiresUnlockedOverEnchanting()) {
            enchanterBlockEntity.currentRecipe = enchantmentUpgradeRecipe;
            enchanterBlockEntity.currentItemProcessingTime = 0;
            enchanterBlockEntity.virtualInventoryRecipeOrientation = previousOrientation;
            enchanterBlockEntity.virtualInventoryIncludingBowlStacks = recipeTestInventory;
            enchanterBlockEntity.craftingTimeTotal = enchantmentUpgradeRecipe.getRequiredItemCount();
        }
        if (enchanterBlockEntity.currentRecipe != previousRecipe) {
            enchanterBlockEntity.updateInClientWorld();
        }
    }

    private static void grantPlayerEnchantingAdvancementCriterion(UUID playerUUID, class_1799 resultStack, int experience) {
        int levels = ExperienceHelper.getLevelForExperience(experience);
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(playerUUID);
        if (serverPlayerEntity != null) {
            serverPlayerEntity.method_7281(class_3468.field_15420);
            class_174.field_1181.method_8870(serverPlayerEntity, resultStack, levels);
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        Object t;
        Optional optionalRecipe;
        String recipeString;
        super.method_11014(nbt);
        this.craftingTime = nbt.method_10550("crafting_time");
        this.craftingTimeTotal = nbt.method_10550("crafting_time_total");
        this.currentItemProcessingTime = nbt.method_10550("current_item_processing_time");
        this.inventoryChanged = nbt.method_10577("inventory_changed");
        this.canOwnerApplyConflictingEnchantments = nbt.method_10577("owner_can_apply_conflicting_enchantments");
        this.canOwnerOverenchant = nbt.method_10577("owner_can_overenchant");
        this.virtualInventoryRecipeOrientation = nbt.method_10550("virtual_recipe_orientation");
        this.virtualInventoryIncludingBowlStacks = new class_1277(10);
        this.virtualInventoryIncludingBowlStacks.method_7659(nbt.method_10554("virtual_inventory", 10));
        if (nbt.method_10573("item_facing", 8)) {
            this.itemFacing = class_2350.valueOf((String)nbt.method_10558("item_facing").toUpperCase(Locale.ROOT));
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = null;
        if (nbt.method_10545("CurrentRecipe") && !(recipeString = nbt.method_10558("CurrentRecipe")).isEmpty() && SpectrumCommon.minecraftServer != null && (optionalRecipe = SpectrumCommon.minecraftServer.method_3772().method_8130(new class_2960(recipeString))).isPresent() && (t = optionalRecipe.get()) instanceof GatedSpectrumRecipe) {
            GatedSpectrumRecipe gatedSpectrumRecipe = (GatedSpectrumRecipe)t;
            if (optionalRecipe.get() instanceof EnchanterRecipe || optionalRecipe.get() instanceof EnchantmentUpgradeRecipe) {
                this.currentRecipe = gatedSpectrumRecipe;
            }
        }
        if (this.currentRecipe == null && this.field_11863 != null && this.field_11863.field_9236) {
            this.stopCraftingMusic();
        }
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Environment(value=EnvType.CLIENT)
    protected void stopCraftingMusic() {
        CraftingBlockSoundInstance.stopPlayingOnPos(this.field_11867);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("crafting_time", this.craftingTime);
        nbt.method_10569("crafting_time_total", this.craftingTimeTotal);
        nbt.method_10569("current_item_processing_time", this.currentItemProcessingTime);
        nbt.method_10569("virtual_recipe_orientation", this.virtualInventoryRecipeOrientation);
        nbt.method_10556("inventory_changed", this.inventoryChanged);
        nbt.method_10556("owner_can_apply_conflicting_enchantments", this.canOwnerApplyConflictingEnchantments);
        nbt.method_10556("owner_can_overenchant", this.canOwnerOverenchant);
        nbt.method_10566("virtual_inventory", (class_2520)this.virtualInventoryIncludingBowlStacks.method_7660());
        if (this.itemFacing != null) {
            nbt.method_10582("item_facing", this.itemFacing.toString().toUpperCase(Locale.ROOT));
        }
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public void updateInClientWorld() {
        this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 4);
    }

    public class_2350 getItemFacingDirection() {
        return Objects.requireNonNullElse(this.itemFacing, class_2350.field_11043);
    }

    public void setItemFacingDirection(class_2350 facingDirection) {
        this.itemFacing = facingDirection;
    }

    private void doItemBowlOrbs(class_1937 world) {
        for (int i = 0; i < 8; ++i) {
            class_2338 itemBowlPos = this.field_11867.method_10081(EnchanterBlockEntity.getItemBowlPositionOffset(i, 0));
            class_2586 blockEntity = world.method_8321(itemBowlPos);
            if (!(blockEntity instanceof ItemBowlBlockEntity)) continue;
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5));
        }
    }

    public boolean drainExperience(int amount) {
        class_1799 experienceProviderStack = this.method_5438(1);
        class_1792 class_17922 = experienceProviderStack.method_7909();
        if (class_17922 instanceof ExperienceStorageItem) {
            ExperienceStorageItem experienceStorageItem = (ExperienceStorageItem)class_17922;
            int currentStoredExperience = ExperienceStorageItem.getStoredExperience(experienceProviderStack);
            if (currentStoredExperience > 0) {
                KnowledgeGemItem knowledgeGemItem;
                int amountAfterExperienceMod = EnchanterBlockEntity.getExperienceWithMod(amount, this.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE), this.field_11863.field_9229);
                int drainedExperience = Math.min(currentStoredExperience, amountAfterExperienceMod);
                if (experienceStorageItem instanceof KnowledgeGemItem && (knowledgeGemItem = (KnowledgeGemItem)experienceStorageItem).changedDisplayTier(currentStoredExperience, currentStoredExperience - drainedExperience)) {
                    SpectrumS2CPacketSender.playParticleWithPatternAndVelocity(null, (class_3218)this.field_11863, new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 2.5, (double)this.field_11867.method_10260() + 0.5), (class_2394)SpectrumParticleTypes.LIME_CRAFTING, VectorPattern.SIXTEEN, 0.05f);
                    this.updateInClientWorld();
                }
                this.method_5431();
                return ExperienceStorageItem.removeStoredExperience(experienceProviderStack, drainedExperience);
            }
        }
        return false;
    }

    @Override
    public void inventoryChanged() {
        this.virtualInventoryIncludingBowlStacks = new class_1277(10);
        this.virtualInventoryIncludingBowlStacks.method_5447(0, this.method_5438(0));
        this.virtualInventoryIncludingBowlStacks.method_5447(1, this.method_5438(1));
        this.virtualInventoryIncludingBowlStacks.method_5447(2, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(5, 0, -3)));
        this.virtualInventoryIncludingBowlStacks.method_5447(3, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(5, 0, 3)));
        this.virtualInventoryIncludingBowlStacks.method_5447(4, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(3, 0, 5)));
        this.virtualInventoryIncludingBowlStacks.method_5447(5, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-3, 0, 5)));
        this.virtualInventoryIncludingBowlStacks.method_5447(6, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-5, 0, 3)));
        this.virtualInventoryIncludingBowlStacks.method_5447(7, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-5, 0, -3)));
        this.virtualInventoryIncludingBowlStacks.method_5447(8, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(-3, 0, -5)));
        this.virtualInventoryIncludingBowlStacks.method_5447(9, this.getItemBowlStack(this.field_11863, this.field_11867.method_10069(3, 0, -5)));
        this.virtualInventoryIncludingBowlStacks.method_5431();
        this.inventoryChanged = true;
        this.currentItemProcessingTime = -1;
        super.inventoryChanged();
    }

    public class_1799 getItemBowlStack(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            return itemBowlBlockEntity.method_5438(0);
        }
        return class_1799.field_8037;
    }

    public void playSound(class_3414 soundEvent, float volume) {
        class_5819 random = this.field_11863.field_9229;
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, volume, 0.9f + random.method_43057() * 0.15f);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.canOwnerApplyConflictingEnchantments = AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)APPLY_CONFLICTING_ENCHANTMENTS_ADVANCEMENT_IDENTIFIER);
        this.canOwnerOverenchant = AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)OVERENCHANTING_ADVANCEMENT_IDENTIFIER);
        this.method_5431();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 3, 0, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }
}

