/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.ender;

import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.interfaces.PlayerOwnedWithName;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class EnderHopperBlockEntity
extends class_2586
implements PlayerOwnedWithName {
    private final class_265 INSIDE_SHAPE = class_2248.method_9541((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final class_265 ABOVE_SHAPE = class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private final class_265 INPUT_AREA_SHAPE = class_259.method_1084((class_265)this.INSIDE_SHAPE, (class_265)this.ABOVE_SHAPE);
    private UUID ownerUUID;
    private String ownerName;
    private int transferCooldown;

    public EnderHopperBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.ENDER_HOPPER, blockPos, blockState);
    }

    public static void onEntityCollided(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity, EnderHopperBlockEntity enderHopperBlockEntity) {
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            if (class_259.method_1074((class_265)class_259.method_1078((class_238)entity.method_5829().method_989((double)(-pos.method_10263()), (double)(-pos.method_10264()), (double)(-pos.method_10260()))), (class_265)enderHopperBlockEntity.getInputAreaShape(), (class_247)class_247.field_16896)) {
                EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, itemEntity);
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, EnderHopperBlockEntity enderHopperBlockEntity) {
        --enderHopperBlockEntity.transferCooldown;
        if (!enderHopperBlockEntity.needsCooldown()) {
            enderHopperBlockEntity.setCooldown(0);
            class_1263 sourceInventory = EnderHopperBlockEntity.getInputInventory(world, enderHopperBlockEntity);
            if (sourceInventory != null) {
                EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, sourceInventory);
            } else {
                List<class_1542> entities = EnderHopperBlockEntity.getInputItemEntities(world, enderHopperBlockEntity);
                for (class_1542 entity : entities) {
                    EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, entity);
                }
            }
            enderHopperBlockEntity.setCooldown(8);
        }
    }

    public static List<class_1542> getInputItemEntities(class_1937 world, EnderHopperBlockEntity enderHopperBlockEntity) {
        return enderHopperBlockEntity.getInputAreaShape().method_1090().stream().flatMap(box -> world.method_8390(class_1542.class, box.method_989(enderHopperBlockEntity.getHopperX() - 0.5, enderHopperBlockEntity.getHopperY() - 0.5, enderHopperBlockEntity.getHopperZ() - 0.5), class_1301.field_6154).stream()).collect(Collectors.toList());
    }

    private static void insertIntoEnderChest(EnderHopperBlockEntity enderHopperBlockEntity, class_1263 sourceInventory) {
        class_1657 playerEntity;
        UUID ownerUUID = enderHopperBlockEntity.getOwnerUUID();
        if (ownerUUID != null && (playerEntity = enderHopperBlockEntity.getOwnerIfOnline()) != null) {
            for (int i = 0; i < sourceInventory.method_5439(); ++i) {
                class_1799 sourceItemStack = sourceInventory.method_5438(i).method_7972();
                if (sourceItemStack.method_7960() || !InventoryHelper.canExtract(sourceInventory, sourceItemStack, i, class_2350.field_11033)) continue;
                class_1799 remainderStack = EnderHopperBlockEntity.addToEnderInventory(sourceItemStack, playerEntity, false);
                sourceInventory.method_5447(i, remainderStack);
                if (!remainderStack.method_7960()) {
                    enderHopperBlockEntity.setCooldown(40);
                }
                return;
            }
        }
    }

    private static void insertIntoEnderChest(EnderHopperBlockEntity enderHopperBlockEntity, class_1542 itemEntity) {
        class_1799 sourceItemStack;
        class_1657 playerEntity;
        UUID ownerUUID = enderHopperBlockEntity.getOwnerUUID();
        if (ownerUUID != null && (playerEntity = enderHopperBlockEntity.getOwnerIfOnline()) != null && !(sourceItemStack = itemEntity.method_6983()).method_7960()) {
            class_1799 remainderStack = EnderHopperBlockEntity.addToEnderInventory(sourceItemStack, playerEntity, false);
            if (remainderStack.method_7960()) {
                itemEntity.method_31472();
            } else {
                itemEntity.method_6979(remainderStack);
            }
        }
    }

    public static class_1799 addToEnderInventory(class_1799 additionStack, class_1657 playerEntity, boolean test) {
        class_1730 enderChestInventory = playerEntity.method_7274();
        for (int i = 0; i < enderChestInventory.method_5439(); ++i) {
            int canAcceptCount;
            int maxStackCount;
            class_1799 currentStack = enderChestInventory.method_5438(i);
            boolean doneStuff = false;
            if (currentStack.method_7960()) {
                maxStackCount = currentStack.method_7914();
                int maxAcceptCount = Math.min(additionStack.method_7947(), maxStackCount);
                if (!test) {
                    class_1799 newStack = additionStack.method_7972();
                    newStack.method_7939(maxAcceptCount);
                    enderChestInventory.method_5447(i, newStack);
                }
                additionStack.method_7939(additionStack.method_7947() - maxAcceptCount);
                doneStuff = true;
            } else if (additionStack.method_7929(currentStack) && (canAcceptCount = (maxStackCount = currentStack.method_7914()) - currentStack.method_7947()) > 0) {
                if (!test) {
                    enderChestInventory.method_5438(i).method_7933(Math.min(additionStack.method_7947(), canAcceptCount));
                }
                if (canAcceptCount >= additionStack.method_7947()) {
                    additionStack.method_7939(0);
                } else {
                    additionStack.method_7939(additionStack.method_7947() - canAcceptCount);
                }
                doneStuff = true;
            }
            if (!doneStuff || additionStack.method_7947() != 0) continue;
            return class_1799.field_8037;
        }
        return additionStack;
    }

    @Nullable
    private static class_1263 getInputInventory(class_1937 world, EnderHopperBlockEntity enderHopperBlockEntity) {
        return InventoryHelper.getInventoryAt(world, enderHopperBlockEntity.getHopperX(), enderHopperBlockEntity.getHopperY() + 1.0, enderHopperBlockEntity.getHopperZ());
    }

    protected class_2561 getContainerName() {
        if (this.hasOwner()) {
            return class_2561.method_43471((String)"block.spectrum.ender_hopper").method_10852((class_2561)class_2561.method_43469((String)"container.spectrum.owned_by_player", (Object[])new Object[]{this.ownerName}));
        }
        return class_2561.method_43471((String)"block.spectrum.ender_hopper");
    }

    public double getHopperX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    public double getHopperY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    public double getHopperZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    private class_265 getInputAreaShape() {
        return this.INPUT_AREA_SHAPE;
    }

    public class_1799 getStack(int slot) {
        class_1657 playerEntity = this.field_11863.method_18470(this.ownerUUID);
        class_1730 enderInventory = playerEntity.method_7274();
        return enderInventory.method_5438(slot);
    }

    private void setCooldown(int cooldown) {
        this.transferCooldown = cooldown;
    }

    private boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.ownerName = playerEntity.method_5477().getString();
        this.method_5431();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.ownerUUID = tag.method_10545("OwnerUUID") ? tag.method_25926("OwnerUUID") : null;
        this.ownerName = tag.method_10545("OwnerName") ? tag.method_10558("OwnerName") : null;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.ownerUUID != null) {
            tag.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            tag.method_10582("OwnerName", this.ownerName);
        }
    }
}

