/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.jade_vines;

import de.dafuqs.spectrum.blocks.jade_vines.JadeVine;
import de.dafuqs.spectrum.blocks.jade_vines.JadeVineBulbBlock;
import de.dafuqs.spectrum.blocks.jade_vines.JadeVinePlantBlock;
import de.dafuqs.spectrum.blocks.jade_vines.JadeVineRootsBlockEntity;
import de.dafuqs.spectrum.items.magic_items.NaturesStaffItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2354;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeVineRootsBlock
extends class_2237
implements JadeVine,
NaturesStaffItem.NaturesStaffTriggered {
    public static final class_2746 DEAD = JadeVine.DEAD;

    public JadeVineRootsBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)DEAD, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canBePlantedOn(class_2680 blockState) {
        return blockState.method_26164(class_3481.field_17619);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (!((Boolean)state.method_11654((class_2769)DEAD)).booleanValue()) {
            JadeVine.spawnParticlesClient(world, pos);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return SpectrumItems.GERMINATED_JADE_VINE_BULB.method_7854();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        class_2586 blockEntity;
        super.method_9615(state, world, pos, oldState, notify);
        if (oldState.method_26204() instanceof class_2354 && (blockEntity = world.method_8321(pos)) instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            jadeVineRootsBlockEntity.setFenceBlockState(oldState.method_26204().method_9564());
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (!newState.method_27852((class_2248)this) && (blockEntity = world.method_8321(pos)) instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            world.method_8501(pos, jadeVineRootsBlockEntity.getFenceBlockState());
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public boolean method_9558(@NotNull class_2680 state, class_4538 world, class_2338 pos) {
        return JadeVineRootsBlock.canBePlantedOn(world.method_8320(pos));
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DEAD});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new JadeVineRootsBlockEntity(pos, state);
    }

    public boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)DEAD) == false;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (!world.field_9236 && this.method_9542(state)) {
            int age = this.getAge((class_1937)world, pos, state);
            if (JadeVine.isExposedToSunlight((class_1937)world, pos) || age < 0) {
                this.exposedToSunlight(world, pos);
            } else if (this.canGrow((class_1937)world, pos)) {
                if (world.field_9229.method_43056() && this.tryGrowUpwards(state, (class_1937)world, pos)) {
                    this.rememberGrownTime((class_1937)world, pos);
                    world.method_8396(null, pos, class_3417.field_17611, class_3419.field_15245, 0.5f, 0.9f + 0.2f * world.field_9229.method_43057() * 0.2f);
                } else if (this.tryGrowDownwards(state, (class_1937)world, pos)) {
                    this.rememberGrownTime((class_1937)world, pos);
                    world.method_8396(null, pos, class_3417.field_17611, class_3419.field_15245, 0.5f, 0.9f + 0.2f * world.field_9229.method_43057() * 0.2f);
                } else {
                    boolean couldGrow;
                    int targetAge = age;
                    if (age == 6) {
                        if (world.method_30273() == 0) {
                            targetAge = 7;
                        }
                    } else if (age == 7) {
                        if (world.method_30273() > 2) {
                            targetAge = 6;
                        }
                    } else {
                        targetAge = age + 1;
                    }
                    if (targetAge != age && (couldGrow = this.setPlantToAge(world, pos, targetAge))) {
                        world.method_8396(null, pos, class_3417.field_17611, class_3419.field_15245, 0.5f, 0.9f + 0.2f * world.field_9229.method_43057() * 0.2f);
                    }
                    this.rememberGrownTime((class_1937)world, pos);
                }
            }
        }
    }

    private void exposedToSunlight(class_3218 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(this.getLowestRootsPos((class_1937)world, pos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            if (jadeVineRootsBlockEntity.wasExposedToSunlight()) {
                this.setDead(world, pos);
                world.method_8396(null, pos, class_3417.field_17611, class_3419.field_15245, 0.5f, 0.9f + 0.2f * world.field_9229.method_43057() * 0.2f);
            } else {
                jadeVineRootsBlockEntity.setExposedToSunlight(true);
            }
        }
    }

    boolean setPlantToAge(@NotNull class_3218 world, @NotNull class_2338 blockPos, int age) {
        class_2338 downPos;
        class_2680 downState;
        JadeVineRootsBlock jadeVineRootsBlock;
        class_2338 upPos;
        class_2680 upState;
        class_2248 class_22482;
        this.setToAge((class_1937)world, blockPos, age);
        boolean anyGrown = false;
        int i = 1;
        while ((class_22482 = (upState = world.method_8320(upPos = blockPos.method_10086(i))).method_26204()) instanceof JadeVineRootsBlock) {
            jadeVineRootsBlock = (JadeVineRootsBlock)class_22482;
            if (jadeVineRootsBlock.setToAge((class_1937)world, upPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, upPos, 8);
            }
            ++i;
        }
        i = 1;
        while ((class_22482 = (downState = world.method_8320(downPos = blockPos.method_10087(i))).method_26204()) instanceof JadeVineRootsBlock) {
            jadeVineRootsBlock = (JadeVineRootsBlock)class_22482;
            if (jadeVineRootsBlock.setToAge((class_1937)world, downPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, downPos, 8);
            }
            ++i;
        }
        class_2338 plantPos = blockPos.method_10087(i);
        class_2680 plantState = world.method_8320(plantPos);
        class_2248 plantBlock = plantState.method_26204();
        if (plantBlock instanceof JadeVinePlantBlock) {
            JadeVinePlantBlock jadeVinePlantBlock = (JadeVinePlantBlock)plantBlock;
            if (jadeVinePlantBlock.setToAge((class_1937)world, plantPos, age) && jadeVinePlantBlock.setToAge((class_1937)world, plantPos.method_10074(), age) && jadeVinePlantBlock.setToAge((class_1937)world, plantPos.method_10087(2), age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, plantPos, 16);
                JadeVine.spawnParticlesServer(world, plantPos.method_10074(), 16);
                JadeVine.spawnParticlesServer(world, plantPos.method_10087(2), 16);
            }
        } else if (plantBlock instanceof JadeVineBulbBlock) {
            JadeVineBulbBlock jadeVineBulbBlock = (JadeVineBulbBlock)plantBlock;
            if (jadeVineBulbBlock.setToAge((class_1937)world, plantPos, age)) {
                anyGrown = true;
                JadeVine.spawnParticlesServer(world, plantPos, 16);
            }
        } else if (plantState.method_26215() && age > 0) {
            world.method_8501(plantPos, SpectrumBlocks.JADE_VINE_BULB.method_9564());
            anyGrown = true;
            JadeVine.spawnParticlesServer(world, plantPos, 16);
        }
        return anyGrown;
    }

    int getAge(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)DEAD)).booleanValue()) {
            return 0;
        }
        class_2338 lowestRootsPos = this.getLowestRootsPos(world, blockPos);
        class_2680 plantState = world.method_8320(lowestRootsPos.method_10074());
        class_2248 plantBlock = plantState.method_26204();
        if (plantBlock instanceof JadeVinePlantBlock) {
            return (Integer)plantState.method_11654((class_2769)JadeVinePlantBlock.AGE);
        }
        if (plantBlock instanceof JadeVineBulbBlock) {
            return 1;
        }
        return -1;
    }

    boolean canGrow(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(this.getLowestRootsPos(world, blockPos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            return world.method_8314(class_1944.field_9284, blockPos) > 8 && jadeVineRootsBlockEntity.isLaterNight(world);
        }
        return false;
    }

    boolean tryGrowUpwards(@NotNull class_2680 blockState, @NotNull class_1937 world, @NotNull class_2338 blockPos) {
        blockPos = blockPos.method_10084();
        while (world.method_8320(blockPos).method_26204() instanceof JadeVineRootsBlock) {
            blockPos = blockPos.method_10084();
        }
        class_2680 targetState = world.method_8320(blockPos);
        if (JadeVineRootsBlock.canBePlantedOn(targetState)) {
            world.method_8501(blockPos, blockState);
            class_2586 blockEntity = world.method_8321(blockPos);
            if (blockEntity instanceof JadeVineRootsBlockEntity) {
                JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
                jadeVineRootsBlockEntity.setFenceBlockState(targetState.method_26204().method_9564());
            }
            return true;
        }
        return false;
    }

    boolean tryGrowDownwards(@NotNull class_2680 blockState, @NotNull class_1937 world, @NotNull class_2338 blockPos) {
        blockPos = blockPos.method_10074();
        while (world.method_8320(blockPos).method_26204() instanceof JadeVineRootsBlock) {
            blockPos = blockPos.method_10074();
        }
        class_2680 targetState = world.method_8320(blockPos);
        if (targetState.method_26204() instanceof JadeVineBulbBlock) {
            if (world.method_8320(blockPos.method_10074()).method_26215() && world.method_8320(blockPos.method_10087(2)).method_26215()) {
                world.method_8501(blockPos, (class_2680)SpectrumBlocks.JADE_VINES.method_9564().method_11657(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.BASE)));
                world.method_8501(blockPos.method_10074(), (class_2680)SpectrumBlocks.JADE_VINES.method_9564().method_11657(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.MIDDLE)));
                world.method_8501(blockPos.method_10087(2), (class_2680)SpectrumBlocks.JADE_VINES.method_9564().method_11657(JadeVinePlantBlock.PART, (Comparable)((Object)JadeVinePlantBlock.JadeVinesPlantPart.TIP)));
                return true;
            }
        } else {
            if (targetState.method_26215()) {
                world.method_8501(blockPos, SpectrumBlocks.JADE_VINE_BULB.method_9564());
                return true;
            }
            if (JadeVineRootsBlock.canBePlantedOn(targetState)) {
                class_2586 newBlockEntity;
                world.method_8501(blockPos, SpectrumBlocks.JADE_VINE_ROOTS.method_9564());
                long lastGrowTime = -1L;
                class_2586 currentBlockEntity = world.method_8321(blockPos.method_10084());
                if (currentBlockEntity instanceof JadeVineRootsBlockEntity) {
                    JadeVineRootsBlockEntity rootsBlockEntity = (JadeVineRootsBlockEntity)currentBlockEntity;
                    lastGrowTime = rootsBlockEntity.getLastGrownTime();
                }
                if ((newBlockEntity = world.method_8321(blockPos)) instanceof JadeVineRootsBlockEntity) {
                    JadeVineRootsBlockEntity rootsBlockEntity = (JadeVineRootsBlockEntity)newBlockEntity;
                    rootsBlockEntity.setFenceBlockState(targetState.method_26204().method_9564());
                    if (lastGrowTime > 0L) {
                        rootsBlockEntity.setLastGrownTime(lastGrowTime);
                    } else {
                        rootsBlockEntity.setLastGrownTime(world.method_8510());
                    }
                }
                return true;
            }
        }
        return false;
    }

    void setDead(@NotNull class_3218 world, @NotNull class_2338 blockPos) {
        this.setPlantToAge(world, blockPos, 0);
    }

    void rememberGrownTime(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(this.getLowestRootsPos(world, blockPos));
        if (blockEntity instanceof JadeVineRootsBlockEntity) {
            JadeVineRootsBlockEntity jadeVineRootsBlockEntity = (JadeVineRootsBlockEntity)blockEntity;
            jadeVineRootsBlockEntity.setLastGrownTime(world.method_8532());
        }
    }

    public class_2338 getLowestRootsPos(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        int i = 0;
        while (world.method_8320(blockPos.method_10087(i + 1)).method_26204() instanceof JadeVineRootsBlock && blockPos.method_10264() - ++i >= world.method_31607()) {
        }
        return blockPos.method_10087(i);
    }

    @Override
    public boolean setToAge(@NotNull class_1937 world, class_2338 blockPos, int age) {
        class_2680 currentState = world.method_8320(blockPos);
        boolean dead = (Boolean)currentState.method_11654((class_2769)DEAD);
        if (age == 0 && !dead) {
            world.method_8501(blockPos, (class_2680)currentState.method_11657((class_2769)DEAD, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        if (age > 0 && dead) {
            world.method_8501(blockPos, (class_2680)currentState.method_11657((class_2769)DEAD, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseNaturesStaff(class_1937 world, class_2338 pos, class_2680 state) {
        return (Boolean)state.method_11654((class_2769)DEAD);
    }

    @Override
    public boolean onNaturesStaffUse(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.setPlantToAge((class_3218)world, pos, 1);
        JadeVine.spawnParticlesServer((class_3218)world, pos, 16);
        return false;
    }
}

