/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.particle_spawner;

import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import net.minecraft.class_1160;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class ParticleSpawnerConfiguration {
    private final class_2396<?> particleType;
    private final class_2382 cmyColor;
    private final boolean glowing;
    private final float particlesPerSecond;
    private final class_1160 sourcePosition;
    private final class_1160 sourcePositionVariance;
    private final class_1160 velocity;
    private final class_1160 velocityVariance;
    private final float scale;
    private final float scaleVariance;
    private final int lifetimeTicks;
    private final int lifetimeVariance;
    private final float gravity;
    private final boolean collisions;
    private final class_1160 rgbColor;

    public ParticleSpawnerConfiguration(class_2396<?> particleType, class_2382 cmyColor, boolean glowing, float particlesPerSecond, class_1160 sourcePosition, class_1160 sourcePositionVariance, class_1160 velocity, class_1160 velocityVariance, float scale, float scaleVariance, int lifetimeTicks, int lifetimeVariance, float gravity, boolean collisions) {
        this.particleType = particleType;
        this.cmyColor = cmyColor;
        this.glowing = glowing;
        this.particlesPerSecond = particlesPerSecond;
        this.sourcePosition = sourcePosition;
        this.sourcePositionVariance = sourcePositionVariance;
        this.velocity = velocity;
        this.velocityVariance = velocityVariance;
        this.scale = scale;
        this.scaleVariance = scaleVariance;
        this.lifetimeTicks = lifetimeTicks;
        this.lifetimeVariance = lifetimeVariance;
        this.gravity = gravity;
        this.collisions = collisions;
        this.rgbColor = ParticleSpawnerConfiguration.CMYtoRGB(cmyColor);
    }

    public static class_1160 CMYtoRGB(class_2382 cmy) {
        float r = 1.0f - (float)cmy.method_10263() / 100.0f;
        float g = 1.0f - (float)cmy.method_10264() / 100.0f;
        float b = 1.0f - (float)cmy.method_10260() / 100.0f;
        return new class_1160(r, g, b);
    }

    public class_2396<?> getParticleType() {
        return this.particleType;
    }

    public class_2382 getCmyColor() {
        return this.cmyColor;
    }

    public boolean glows() {
        return this.glowing;
    }

    public float getParticlesPerSecond() {
        return this.particlesPerSecond;
    }

    public class_1160 getSourcePosition() {
        return this.sourcePosition;
    }

    public class_1160 getSourcePositionVariance() {
        return this.sourcePositionVariance;
    }

    public class_1160 getVelocity() {
        return this.velocity;
    }

    public class_1160 getVelocityVariance() {
        return this.velocityVariance;
    }

    public float getScale() {
        return this.scale;
    }

    public float getScaleVariance() {
        return this.scaleVariance;
    }

    public int getLifetimeTicks() {
        return this.lifetimeTicks;
    }

    public int getLifetimeVariance() {
        return this.lifetimeVariance;
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean hasCollisions() {
        return this.collisions;
    }

    public void write(class_2540 buf) {
        buf.method_10814(class_2378.field_11141.method_10221(this.particleType).toString());
        buf.writeInt(this.cmyColor.method_10263());
        buf.writeInt(this.cmyColor.method_10264());
        buf.writeInt(this.cmyColor.method_10260());
        buf.writeBoolean(this.glowing);
        buf.writeFloat(this.particlesPerSecond);
        buf.writeFloat(this.sourcePosition.method_4943());
        buf.writeFloat(this.sourcePosition.method_4945());
        buf.writeFloat(this.sourcePosition.method_4947());
        buf.writeFloat(this.sourcePositionVariance.method_4943());
        buf.writeFloat(this.sourcePositionVariance.method_4945());
        buf.writeFloat(this.sourcePositionVariance.method_4947());
        buf.writeFloat(this.velocity.method_4943());
        buf.writeFloat(this.velocity.method_4945());
        buf.writeFloat(this.velocity.method_4947());
        buf.writeFloat(this.velocityVariance.method_4943());
        buf.writeFloat(this.velocityVariance.method_4945());
        buf.writeFloat(this.velocityVariance.method_4947());
        buf.writeFloat(this.scale);
        buf.writeFloat(this.scaleVariance);
        buf.writeInt(this.lifetimeTicks);
        buf.writeInt(this.lifetimeVariance);
        buf.writeFloat(this.gravity);
        buf.writeBoolean(this.collisions);
    }

    public static ParticleSpawnerConfiguration fromBuf(class_2540 buf) {
        class_2960 particleIdentifier = new class_2960(buf.method_19772());
        class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(particleIdentifier);
        class_2382 cmyColor = new class_2382(buf.readInt(), buf.readInt(), buf.readInt());
        boolean glowing = buf.readBoolean();
        float particlesPerSecond = buf.readFloat();
        class_1160 sourcePosition = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 sourcePositionVariance = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 velocity = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 velocityVariance = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        float scale = buf.readFloat();
        float scaleVariance = buf.readFloat();
        int lifetimeTicks = buf.readInt();
        int lifetimeVariance = buf.readInt();
        float gravity = buf.readFloat();
        boolean collisions = buf.readBoolean();
        return new ParticleSpawnerConfiguration(particleType, cmyColor, glowing, particlesPerSecond, sourcePosition, sourcePositionVariance, velocity, velocityVariance, scale, scaleVariance, lifetimeTicks, lifetimeVariance, gravity, collisions);
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("particle_type_identifier", class_2378.field_11141.method_10221(this.particleType).toString());
        nbt.method_10548("particles_per_tick", this.particlesPerSecond);
        nbt.method_10556("glowing", this.glowing);
        nbt.method_10548("source_pos_x", this.sourcePosition.method_4943());
        nbt.method_10548("source_pos_y", this.sourcePosition.method_4945());
        nbt.method_10548("source_pos_z", this.sourcePosition.method_4947());
        nbt.method_10548("source_pos_variance_x", this.sourcePositionVariance.method_4943());
        nbt.method_10548("source_pos_variance_y", this.sourcePositionVariance.method_4945());
        nbt.method_10548("source_pos_variance_z", this.sourcePositionVariance.method_4947());
        nbt.method_10548("source_velocity_x", this.velocity.method_4943());
        nbt.method_10548("source_velocity_y", this.velocity.method_4945());
        nbt.method_10548("source_velocity_z", this.velocity.method_4947());
        nbt.method_10548("source_velocity_variance_x", this.velocityVariance.method_4943());
        nbt.method_10548("source_velocity_variance_y", this.velocityVariance.method_4945());
        nbt.method_10548("source_velocity_variance_z", this.velocityVariance.method_4947());
        nbt.method_10569("color_c", this.cmyColor.method_10263());
        nbt.method_10569("color_m", this.cmyColor.method_10264());
        nbt.method_10569("color_y", this.cmyColor.method_10260());
        nbt.method_10548("scale", this.scale);
        nbt.method_10548("scale_variance", this.scaleVariance);
        nbt.method_10569("lifetime", this.lifetimeTicks);
        nbt.method_10569("lifetime_variance", this.lifetimeVariance);
        nbt.method_10548("gravity", this.gravity);
        nbt.method_10556("collisions", this.collisions);
        return nbt;
    }

    public static ParticleSpawnerConfiguration fromNbt(class_2487 tag) {
        class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(new class_2960(tag.method_10558("particle_type_identifier")));
        float particlesPerSecond = tag.method_10583("particles_per_tick");
        boolean glowing = tag.method_10577("glowing");
        class_1160 particleSourcePosition = new class_1160(tag.method_10583("source_pos_x"), tag.method_10583("source_pos_y"), tag.method_10583("source_pos_z"));
        class_1160 particleSourcePositionVariance = new class_1160(tag.method_10583("source_pos_variance_x"), tag.method_10583("source_pos_variance_y"), tag.method_10583("source_pos_variance_z"));
        class_1160 velocity = new class_1160(tag.method_10583("source_velocity_x"), tag.method_10583("source_velocity_y"), tag.method_10583("source_velocity_z"));
        class_1160 velocityVariance = new class_1160(tag.method_10583("source_velocity_variance_x"), tag.method_10583("source_velocity_variance_y"), tag.method_10583("source_velocity_variance_z"));
        class_2382 cmyColor = new class_2382(tag.method_10550("color_c"), tag.method_10550("color_m"), tag.method_10550("color_y"));
        float scale = tag.method_10583("scale");
        float scaleVariance = tag.method_10583("scale_variance");
        int lifetimeTicks = tag.method_10550("lifetime");
        int lifetimeVariance = tag.method_10550("lifetime_variance");
        float gravity = tag.method_10583("gravity");
        boolean collisions = tag.method_10577("collisions");
        return new ParticleSpawnerConfiguration(particleType, cmyColor, glowing, particlesPerSecond, particleSourcePosition, particleSourcePositionVariance, velocity, velocityVariance, scale, scaleVariance, lifetimeTicks, lifetimeVariance, gravity, collisions);
    }

    public void spawnParticles(class_1937 world, @NotNull class_2338 pos) {
        for (float particlesToSpawn = this.particlesPerSecond / 20.0f; particlesToSpawn >= 1.0f || world.field_9229.method_43057() < particlesToSpawn; particlesToSpawn -= 1.0f) {
            this.spawnParticle(world, pos, world.field_9229);
        }
    }

    private void spawnParticle(class_1937 world, @NotNull class_2338 pos, class_5819 random) {
        int randomLifetime;
        float randomScale = this.scaleVariance == 0.0f ? this.scale : (float)((double)(this.scale + this.scaleVariance) - random.method_43058() * (double)this.scaleVariance * 2.0);
        int n = randomLifetime = this.lifetimeVariance == 0 ? this.lifetimeTicks : (int)((double)(this.lifetimeTicks + this.lifetimeVariance) - random.method_43058() * (double)this.lifetimeVariance * 2.0);
        if (randomScale > 0.0f && randomLifetime > 0) {
            double randomOffsetX = this.sourcePositionVariance.method_4943() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.method_4943() - random.method_43058() * (double)this.sourcePositionVariance.method_4943() * 2.0;
            double randomOffsetY = this.sourcePositionVariance.method_4945() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.method_4945() - random.method_43058() * (double)this.sourcePositionVariance.method_4945() * 2.0;
            double randomOffsetZ = this.sourcePositionVariance.method_4947() == 0.0f ? 0.0 : (double)this.sourcePositionVariance.method_4947() - random.method_43058() * (double)this.sourcePositionVariance.method_4947() * 2.0;
            double randomVelocityX = this.velocityVariance.method_4943() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4943() - random.method_43058() * (double)this.velocityVariance.method_4943() * 2.0;
            double randomVelocityY = this.velocityVariance.method_4945() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4945() - random.method_43058() * (double)this.velocityVariance.method_4945() * 2.0;
            double randomVelocityZ = this.velocityVariance.method_4947() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4947() - random.method_43058() * (double)this.velocityVariance.method_4947() * 2.0;
            world.method_8406((class_2394)new DynamicParticleEffect(this.particleType, this.gravity, this.rgbColor, randomScale, randomLifetime, this.collisions, this.glowing), (double)pos.method_10263() + 0.5 + (double)this.sourcePosition.method_4943() + randomOffsetX, (double)pos.method_10264() + 0.5 + (double)this.sourcePosition.method_4945() + randomOffsetY, (double)pos.method_10260() + 0.5 + (double)this.sourcePosition.method_4947() + randomOffsetZ, (double)this.velocity.method_4943() + randomVelocityX, (double)this.velocity.method_4945() + randomVelocityY, (double)this.velocity.method_4947() + randomVelocityZ);
        }
    }
}

