/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class PastelNetwork {
    protected final Map<PastelNodeType, Set<PastelNodeBlockEntity>> nodes = new ConcurrentHashMap<PastelNodeType, Set<PastelNodeBlockEntity>>();
    @Nullable
    protected Graph<PastelNodeBlockEntity, DefaultEdge> graph;
    protected final class_1937 world;
    protected final UUID uuid;
    protected final SchedulerMap<PastelTransmission> transmissions = new SchedulerMap();

    public PastelNetwork(class_1937 world, @Nullable UUID uuid) {
        this.world = world;
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        for (PastelNodeType type : PastelNodeType.values()) {
            this.nodes.put(type, new HashSet());
        }
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public Graph<PastelNodeBlockEntity, DefaultEdge> getGraph() {
        if (this.graph == null) {
            this.graph = PastelNetwork.buildGraph(this);
        }
        return this.graph;
    }

    @NotNull
    private static SimpleGraph<PastelNodeBlockEntity, DefaultEdge> buildGraph(@NotNull PastelNetwork network) {
        SimpleGraph g = new SimpleGraph(DefaultEdge.class);
        for (PastelNodeBlockEntity node : network.getAllNodes()) {
            g.addVertex((Object)node);
        }
        for (PastelNodeBlockEntity node : network.getAllNodes()) {
            for (PastelNodeBlockEntity node2 : network.getAllNodes()) {
                if (node == node2 || !node.canConnect(node2)) continue;
                g.addEdge((Object)node, (Object)node2);
            }
        }
        return g;
    }

    public void addNode(PastelNodeBlockEntity node) {
        if (!this.nodes.get((Object)node.getNodeType()).add(node)) {
            return;
        }
        if (this.graph != null) {
            this.graph.addVertex((Object)node);
            for (PastelNodeBlockEntity existingNode : this.getAllNodes()) {
                if (node == existingNode || !node.canConnect(existingNode)) continue;
                this.graph.addEdge((Object)node, (Object)existingNode);
            }
        }
    }

    protected boolean removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        boolean hadNode = this.nodes.get((Object)node.getNodeType()).remove(node);
        if (!hadNode) {
            return false;
        }
        if (this.graph != null) {
            this.graph.removeVertex((Object)node);
        }
        return true;
    }

    public boolean hasNodes() {
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            if (nodeList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<PastelNodeBlockEntity> getNodes(PastelNodeType type) {
        return this.nodes.get((Object)type);
    }

    public Map<PastelNodeType, Set<PastelNodeBlockEntity>> getNodes() {
        return this.nodes;
    }

    public int getNodeCount() {
        int nodes = 0;
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            nodes += nodeList.size();
        }
        return nodes;
    }

    public List<PastelNodeBlockEntity> getAllNodes() {
        ArrayList<PastelNodeBlockEntity> nodes = new ArrayList<PastelNodeBlockEntity>();
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodeList : this.nodes.entrySet()) {
            nodes.addAll((Collection<PastelNodeBlockEntity>)this.nodes.get((Object)nodeList.getKey()));
        }
        return nodes;
    }

    public boolean canConnect(PastelNodeBlockEntity newNode) {
        if (newNode.method_10997() != this.world) {
            return false;
        }
        for (Set<PastelNodeBlockEntity> nodeList : this.nodes.values()) {
            for (PastelNodeBlockEntity currentNode : nodeList) {
                if (!currentNode.canConnect(newNode)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        this.transmissions.tick();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }

    public int getColor() {
        return ColorHelper.getRandomColor(this.uuid.hashCode());
    }

    public boolean equals(Object other) {
        if (other instanceof PastelNetwork) {
            PastelNetwork p = (PastelNetwork)other;
            return this.uuid.equals(p.uuid);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.uuid.toString());
        for (PastelNodeType type : PastelNodeType.values()) {
            builder.append("-").append(this.getNodes(type).size());
        }
        return builder.toString();
    }

    public String getNodeDebugText() {
        return "Prov: " + this.getNodes(PastelNodeType.PROVIDER).size() + " - Send: " + this.getNodes(PastelNodeType.SENDER).size() + " - Gath: " + this.getNodes(PastelNodeType.GATHER).size() + " - Stor: " + this.getNodes(PastelNodeType.STORAGE).size() + " - Conn: " + this.getNodes(PastelNodeType.CONNECTION).size();
    }

    public PastelNodeBlockEntity getNodeAt(class_2338 blockPos) {
        class_2586 blockEntity = this.world.method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }
}

