/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultEdge;

public class PastelTransmissionLogic {
    public static final int MAX_TRANSFER_AMOUNT = 1;
    public static final int TRANSFER_TICKS_PER_NODE = 30;
    private final ServerPastelNetwork network;
    private DijkstraShortestPath<PastelNodeBlockEntity, DefaultEdge> dijkstra;
    private Map<PastelNodeBlockEntity, Map<PastelNodeBlockEntity, GraphPath<PastelNodeBlockEntity, DefaultEdge>>> pathCache = new HashMap<PastelNodeBlockEntity, Map<PastelNodeBlockEntity, GraphPath<PastelNodeBlockEntity, DefaultEdge>>>();

    public PastelTransmissionLogic(ServerPastelNetwork network) {
        this.network = network;
    }

    public void invalidateCache() {
        this.dijkstra = null;
        this.pathCache = new HashMap<PastelNodeBlockEntity, Map<PastelNodeBlockEntity, GraphPath<PastelNodeBlockEntity, DefaultEdge>>>();
    }

    @Nullable
    public GraphPath<PastelNodeBlockEntity, DefaultEdge> getPath(Graph<PastelNodeBlockEntity, DefaultEdge> graph, PastelNodeBlockEntity source, PastelNodeBlockEntity destination) {
        Map e;
        if (this.dijkstra == null) {
            this.dijkstra = new DijkstraShortestPath(graph);
        }
        if ((e = (Map)this.pathCache.getOrDefault(source, null)) != null && e.containsKey(destination)) {
            return (GraphPath)e.get(destination);
        }
        ShortestPathAlgorithm.SingleSourcePaths paths = this.dijkstra.getPaths((Object)source);
        GraphPath path = paths.getPath((Object)destination);
        if (this.pathCache.containsKey(source)) {
            this.pathCache.get(source).put(destination, (GraphPath<PastelNodeBlockEntity, DefaultEdge>)path);
        } else {
            HashMap<PastelNodeBlockEntity, GraphPath> newMap = new HashMap<PastelNodeBlockEntity, GraphPath>();
            newMap.put(destination, path);
            this.pathCache.put(source, newMap);
        }
        return path;
    }

    public void tick() {
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.GATHER, TransferMode.PUSH_PULL);
        this.transferBetween(PastelNodeType.PROVIDER, PastelNodeType.GATHER, TransferMode.PULL);
        this.transferBetween(PastelNodeType.STORAGE, PastelNodeType.GATHER, TransferMode.PULL);
        this.transferBetween(PastelNodeType.SENDER, PastelNodeType.STORAGE, TransferMode.PUSH);
    }

    private void transferBetween(PastelNodeType sourceType, PastelNodeType destinationType, TransferMode transferMode) {
        for (PastelNodeBlockEntity sourceNode : this.network.getNodes(sourceType)) {
            Storage<ItemVariant> sourceStorage;
            if (!sourceNode.canTransfer() || (sourceStorage = sourceNode.getConnectedStorage()) == null || !sourceStorage.supportsExtraction()) continue;
            this.tryTransferToType(sourceNode, sourceStorage, destinationType, transferMode);
        }
    }

    private void tryTransferToType(PastelNodeBlockEntity sourceNode, Storage<ItemVariant> sourceStorage, PastelNodeType type, TransferMode transferMode) {
        for (PastelNodeBlockEntity destinationNode : this.network.getNodes(type)) {
            boolean success;
            Storage<ItemVariant> destinationStorage;
            if (!destinationNode.canTransfer() || (destinationStorage = destinationNode.getConnectedStorage()) == null || !destinationStorage.supportsInsertion() || !(success = this.transferBetween(sourceNode, sourceStorage, destinationNode, destinationStorage, transferMode)) || transferMode == TransferMode.PULL) continue;
            return;
        }
    }

    private boolean transferBetween(PastelNodeBlockEntity sourceNode, Storage<ItemVariant> sourceStorage, PastelNodeBlockEntity destinationNode, Storage<ItemVariant> destinationStorage, TransferMode transferMode) {
        Predicate<ItemVariant> filter = sourceNode.getTransferFilterTo(destinationNode);
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : sourceStorage) {
                long storedAmount;
                ItemVariant storedResource;
                if (view.isResourceBlank() || (storedResource = (ItemVariant)view.getResource()).isBlank() || !filter.test(storedResource) || (storedAmount = view.getAmount()) <= 0L) continue;
                long transferrableAmount = 1L;
                long itemCountUnderway = destinationNode.getItemCountUnderway();
                transferrableAmount = (int)destinationStorage.simulateInsert((Object)storedResource, transferrableAmount + itemCountUnderway, (TransactionContext)transaction);
                if ((transferrableAmount -= itemCountUnderway) <= 0L || (transferrableAmount = sourceStorage.extract((Object)storedResource, transferrableAmount, (TransactionContext)transaction)) <= 0L) continue;
                Optional<PastelTransmission> optionalTransmission = this.createTransmissionOnValidPath(sourceNode, destinationNode, storedResource, transferrableAmount);
                if (!optionalTransmission.isPresent()) continue;
                PastelTransmission transmission = optionalTransmission.get();
                int verticesCount = transmission.getNodePositions().size() - 1;
                int travelTime = 30 * verticesCount;
                this.network.addTransmission(transmission, travelTime);
                SpectrumS2CPacketSender.sendPastelTransmissionParticle(this.network, travelTime, transmission);
                if (transferMode == TransferMode.PULL) {
                    destinationNode.markTransferred();
                } else if (transferMode == TransferMode.PUSH) {
                    sourceNode.markTransferred();
                } else {
                    destinationNode.markTransferred();
                    sourceNode.markTransferred();
                }
                destinationNode.addItemCountUnderway(transferrableAmount);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            transaction.abort();
        }
        return false;
    }

    public Optional<PastelTransmission> createTransmissionOnValidPath(PastelNodeBlockEntity source, PastelNodeBlockEntity destination, ItemVariant variant, long amount) {
        GraphPath<PastelNodeBlockEntity, DefaultEdge> graphPath = this.getPath(this.network.getGraph(), source, destination);
        if (graphPath != null) {
            ArrayList<class_2338> vertexPositions = new ArrayList<class_2338>();
            for (PastelNodeBlockEntity vertex : graphPath.getVertexList()) {
                vertexPositions.add(vertex.method_11016());
            }
            return Optional.of(new PastelTransmission(vertexPositions, variant, amount));
        }
        return Optional.empty();
    }

    private static enum TransferMode {
        PUSH,
        PULL,
        PUSH_PULL;

    }
}

