/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmissionLogic;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.helpers.SchedulerMap;
import de.dafuqs.spectrum.helpers.TickLooper;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ServerPastelNetwork
extends PastelNetwork {
    private final TickLooper transferLooper = new TickLooper(10);
    protected final SchedulerMap<PastelTransmission> transmissions = new SchedulerMap();
    protected final PastelTransmissionLogic transmissionLogic = new PastelTransmissionLogic(this);

    public ServerPastelNetwork(class_1937 world, @Nullable UUID uuid) {
        super(world, uuid);
    }

    public void incorporate(PastelNetwork networkToIncorporate) {
        for (Map.Entry<PastelNodeType, Set<PastelNodeBlockEntity>> nodesToIncorporate : networkToIncorporate.getNodes().entrySet()) {
            PastelNodeType type = nodesToIncorporate.getKey();
            for (PastelNodeBlockEntity nodeToIncorporate : nodesToIncorporate.getValue()) {
                ((Set)this.nodes.get((Object)type)).add(nodeToIncorporate);
                nodeToIncorporate.setNetwork(this);
            }
        }
        this.graph = null;
        this.transmissionLogic.invalidateCache();
    }

    @Override
    public void addNode(PastelNodeBlockEntity node) {
        super.addNode(node);
        this.transmissionLogic.invalidateCache();
    }

    @Override
    public boolean removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        boolean result = super.removeNode(node, reason);
        this.transmissionLogic.invalidateCache();
        return result;
    }

    @Override
    public void tick() {
        this.transmissions.tick();
        this.transferLooper.tick();
        if (this.transferLooper.reachedCap()) {
            this.transferLooper.reset();
            try {
                this.transmissionLogic.tick();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addTransmission(PastelTransmission transmission, int travelTime) {
        transmission.setNetwork(this);
        this.transmissions.put(transmission, travelTime);
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_25927("UUID", this.uuid);
        compound.method_10582("World", this.world.method_27983().method_29177().toString());
        compound.method_10566("Looper", this.transferLooper.toNbt());
        class_2499 transmissionList = new class_2499();
        for (Map.Entry<PastelTransmission, Integer> entry : this.transmissions) {
            class_2487 transmissionCompound = new class_2487();
            transmissionCompound.method_10569("Delay", entry.getValue().intValue());
            transmissionCompound.method_10566("Transmission", (class_2520)entry.getKey().toNbt());
            transmissionList.add((Object)transmissionCompound);
        }
        compound.method_10566("Transmissions", (class_2520)transmissionList);
        return compound;
    }

    public static ServerPastelNetwork fromNbt(class_2487 compound) {
        class_3218 world = SpectrumCommon.minecraftServer.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)class_2960.method_12829((String)compound.method_10558("World"))));
        UUID uuid = compound.method_25926("UUID");
        ServerPastelNetwork network = new ServerPastelNetwork((class_1937)world, uuid);
        if (compound.method_10573("Looper", 10)) {
            network.transferLooper.readNbt(compound.method_10562("Looper"));
        }
        for (class_2520 e : compound.method_10554("Transmissions", 10)) {
            class_2487 t = (class_2487)e;
            int delay = t.method_10550("Delay");
            PastelTransmission transmission = PastelTransmission.fromNbt(t.method_10562("Transmission"));
            network.addTransmission(transmission, delay);
        }
        return network;
    }
}

