/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.alg.connectivity.ConnectivityInspector;

public class ServerPastelNetworkManager
extends class_18
implements PastelNetworkManager {
    private static final String PERSISTENT_STATE_ID = "spectrum_pastel_network_manager";
    private final List<ServerPastelNetwork> networks = new ArrayList<ServerPastelNetwork>();

    public boolean method_79() {
        return true;
    }

    public static ServerPastelNetworkManager get(class_3218 world) {
        return (ServerPastelNetworkManager)world.method_17983().method_17924(ServerPastelNetworkManager::fromNbt, ServerPastelNetworkManager::new, PERSISTENT_STATE_ID);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 networkList = new class_2499();
        for (ServerPastelNetwork network : this.networks) {
            class_2487 compound = network.toNbt();
            networkList.add((Object)compound);
        }
        nbt.method_10566("Networks", (class_2520)networkList);
        return nbt;
    }

    public static ServerPastelNetworkManager fromNbt(class_2487 nbt) {
        ServerPastelNetworkManager manager = new ServerPastelNetworkManager();
        for (class_2520 element : nbt.method_10554("Networks", 10)) {
            manager.networks.add(ServerPastelNetwork.fromNbt((class_2487)element));
        }
        return manager;
    }

    private ServerPastelNetwork createNetwork(class_1937 world, @Nullable UUID uuid) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, uuid);
        this.networks.add(network);
        return network;
    }

    public void tick() {
        for (int i = 0; i < this.networks.size(); ++i) {
            this.networks.get(i).tick();
        }
    }

    @Override
    public PastelNetwork joinNetwork(PastelNodeBlockEntity node, @Nullable UUID uuid) {
        if (uuid == null) {
            for (ServerPastelNetwork network : this.networks) {
                if (!network.canConnect(node)) continue;
                network.addNode(node);
                this.checkNetworkMergesForNewNode(network, node);
                return network;
            }
        } else {
            for (int i = 0; i < this.networks.size(); ++i) {
                PastelNetwork network = this.networks.get(i);
                if (!network.getUUID().equals(uuid)) continue;
                network.addNode(node);
                return network;
            }
        }
        ServerPastelNetwork network = this.createNetwork(node.method_10997(), uuid);
        network.addNode(node);
        return network;
    }

    @Override
    public void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        ServerPastelNetwork network = (ServerPastelNetwork)node.getNetwork();
        if (network != null) {
            network.removeNode(node, reason);
            if (network.hasNodes()) {
                this.checkForNetworkSplit(network);
            } else if (reason == NodeRemovalReason.BROKEN || reason == NodeRemovalReason.MOVED) {
                this.networks.remove(network);
            }
        }
    }

    private void checkForNetworkSplit(ServerPastelNetwork network) {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(network.getGraph());
        List connectedSets = connectivityInspector.connectedSets();
        if (connectedSets.size() != 1) {
            for (int i = 1; i < connectedSets.size(); ++i) {
                Set disconnectedNodes = (Set)connectedSets.get(i);
                ServerPastelNetwork newNetwork = this.createNetwork(network.world, null);
                for (PastelNodeBlockEntity disconnectedNode : disconnectedNodes) {
                    ((Set)network.nodes.get((Object)disconnectedNode.getNodeType())).remove(disconnectedNode);
                    network.getGraph().removeVertex((Object)disconnectedNode);
                    ((PastelNetwork)newNetwork).addNode(disconnectedNode);
                    disconnectedNode.setNetwork(newNetwork);
                }
            }
        }
    }

    private void checkNetworkMergesForNewNode(ServerPastelNetwork network, PastelNodeBlockEntity newNode) {
        int biggestNetworkNodeCount = network.getNodeCount();
        ServerPastelNetwork biggestNetwork = network;
        ArrayList<ServerPastelNetwork> smallerNetworks = new ArrayList<ServerPastelNetwork>();
        for (ServerPastelNetwork currentNetwork : this.networks) {
            if (currentNetwork == network || !currentNetwork.canConnect(newNode)) continue;
            if (currentNetwork.getNodeCount() > biggestNetworkNodeCount) {
                smallerNetworks.add(biggestNetwork);
                biggestNetwork = currentNetwork;
                break;
            }
            smallerNetworks.add(currentNetwork);
            break;
        }
        if (smallerNetworks.size() == 0) {
            return;
        }
        for (ServerPastelNetwork smallerNetwork : smallerNetworks) {
            biggestNetwork.incorporate(smallerNetwork);
            this.networks.remove(smallerNetwork);
        }
    }
}

