/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import de.dafuqs.spectrum.blocks.decoration.SpectrumFacingBlock;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlock
extends SpectrumFacingBlock
implements class_2343 {
    public static final Map<class_2350, class_265> SHAPES = new HashMap<class_2350, class_265>(){
        {
            this.put(class_2350.field_11036, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));
            this.put(class_2350.field_11033, class_2248.method_9541((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
            this.put(class_2350.field_11043, class_2248.method_9541((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0));
            this.put(class_2350.field_11035, class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0));
            this.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0));
            this.put(class_2350.field_11039, class_2248.method_9541((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        }
    };
    protected final PastelNodeType pastelNodeType;

    public PastelNodeBlock(class_4970.class_2251 settings, PastelNodeType pastelNodeType) {
        super(settings);
        this.pastelNodeType = pastelNodeType;
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 targetDirection = ((class_2350)state.method_11654((class_2769)field_10927)).method_10153();
        return world.method_8320(pos.method_10093(targetDirection)).method_26207().method_15799();
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        PastelNodeBlockEntity blockEntity;
        if (!newState.method_27852(state.method_26204()) && (blockEntity = this.getBlockEntity((class_1936)world, pos)) != null) {
            blockEntity.onBroken();
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8038();
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(direction.method_10153()));
        return blockState.method_27852((class_2248)this) && blockState.method_11654((class_2769)field_10927) == direction ? (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)direction.method_10153()) : (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)direction);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (placer instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)placer;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof PastelNodeBlockEntity) {
                PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
                SpectrumAdvancementCriteria.PASTEL_NETWORK_CREATING.trigger(serverPlayerEntity, (ServerPastelNetwork)pastelNodeBlockEntity.getNetwork());
            }
        }
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        tooltip.add((class_2561)this.pastelNodeType.getTooltip().method_27692(class_124.field_1068));
        tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.pastel_network_nodes.tooltip.placing").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"block.spectrum.pastel_network_nodes.tooltip.range", (Object[])new Object[]{12}).method_27692(class_124.field_1080));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : state;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        PastelNodeBlockEntity blockEntity = this.getBlockEntity((class_1936)world, pos);
        if (player.method_5998(hand).method_31574(SpectrumItems.PAINTBRUSH)) {
            return PastelNodeBlock.sendDebugMessage(world, player, blockEntity);
        }
        if (this.pastelNodeType.usesFilters()) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            player.method_17355((class_3908)blockEntity);
            return class_1269.field_21466;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @NotNull
    private static class_1269 sendDebugMessage(class_1937 world, class_1657 player, PastelNodeBlockEntity blockEntity) {
        if (world.field_9236) {
            if (blockEntity != null) {
                PastelNetwork network = blockEntity.network;
                player.method_43496((class_2561)class_2561.method_43471((String)"block.spectrum.pastel_network_nodes.connection_debug"));
                if (network == null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"C: No connected network :("));
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)("C: " + network.getUUID().toString())));
                    player.method_43496((class_2561)class_2561.method_43470((String)("C: " + network.getNodeDebugText())));
                }
            }
            return class_1269.field_5812;
        }
        if (blockEntity != null) {
            PastelNetwork network = blockEntity.network;
            if (network == null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"S: No connected network :("));
            } else {
                player.method_43496((class_2561)class_2561.method_43470((String)("S: " + network.getUUID().toString())));
                player.method_43496((class_2561)class_2561.method_43470((String)("S: " + network.getNodeDebugText())));
            }
        }
        return class_1269.field_21466;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)field_10927));
    }

    @Nullable
    public PastelNodeBlockEntity getBlockEntity(class_1936 world, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PastelNodeBlockEntity) {
            PastelNodeBlockEntity pastelNodeBlockEntity = (PastelNodeBlockEntity)blockEntity;
            return pastelNodeBlockEntity;
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PastelNodeBlockEntity(pos, state);
    }
}

