/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import de.dafuqs.spectrum.blocks.FilterConfigurable;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlock;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeType;
import de.dafuqs.spectrum.inventories.FilteringScreenHandler;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PastelNodeBlockEntity
extends class_2586
implements FilterConfigurable,
ExtendedScreenHandlerFactory {
    public static final int ITEM_FILTER_COUNT = 5;
    public static final int RANGE = 12;
    protected PastelNetwork network;
    @Nullable
    protected UUID networkUUIDToMerge = null;
    protected long lastTransferTick = 0L;
    protected final long cachedRedstonePowerTick = 0L;
    protected boolean cachedNoRedstonePower = true;
    protected long itemCountUnderway = 0L;
    protected BlockApiCache<Storage<ItemVariant>, class_2350> connectedStorageCache = null;
    protected class_2350 cachedDirection = null;
    private final List<class_1792> filterItems = class_2371.method_10213((int)5, (Object)class_1802.field_8162);

    public PastelNodeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.PASTEL_NODE, blockPos, blockState);
    }

    @Nullable
    public Storage<ItemVariant> getConnectedStorage() {
        if (this.connectedStorageCache == null) {
            class_2680 state = this.method_11010();
            if (!(state.method_26204() instanceof PastelNodeBlock)) {
                return null;
            }
            this.cachedDirection = (class_2350)state.method_11654((class_2769)PastelNodeBlock.field_10927);
            this.connectedStorageCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016().method_10093(this.cachedDirection.method_10153()));
        }
        return (Storage)this.connectedStorageCache.find((Object)this.cachedDirection);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (!world.field_9236) {
            if (this.networkUUIDToMerge != null) {
                this.network = Pastel.getServerInstance().joinNetwork(this, this.networkUUIDToMerge);
                this.networkUUIDToMerge = null;
            } else if (this.network == null) {
                this.network = Pastel.getServerInstance().joinNetwork(this, null);
            }
        }
    }

    public boolean canTransfer() {
        long time = this.field_11863.method_8510();
        if (time > this.cachedRedstonePowerTick) {
            this.cachedNoRedstonePower = this.field_11863.method_8482(this.field_11867) == 0;
        }
        return this.field_11863.method_8510() > this.lastTransferTick && this.cachedNoRedstonePower;
    }

    public void markTransferred() {
        this.lastTransferTick = this.field_11863.method_8510();
        this.method_5431();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("Network")) {
            UUID networkUUID = nbt.method_25926("Network");
            if (this.field_11863 == null) {
                this.networkUUIDToMerge = networkUUID;
            } else {
                this.network = Pastel.getInstance(this.field_11863.field_9236).joinNetwork(this, networkUUID);
            }
        }
        if (nbt.method_10573("LastTransferTick", 4)) {
            this.lastTransferTick = nbt.method_10537("LastTransferTick");
        }
        if (nbt.method_10573("ItemCountUnderway", 4)) {
            this.itemCountUnderway = nbt.method_10537("ItemCountUnderway");
        }
        if (this.getNodeType().usesFilters()) {
            this.readFilterNbt(nbt, this.filterItems);
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.network != null) {
            nbt.method_25927("Network", this.network.getUUID());
        }
        nbt.method_10544("LastTransferTick", this.lastTransferTick);
        nbt.method_10544("ItemCountUnderway", this.itemCountUnderway);
        if (this.getNodeType().usesFilters()) {
            this.writeFilterNbt(nbt, this.filterItems);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public void method_11012() {
        super.method_11012();
        Pastel.getInstance(this.field_11863.field_9236).removeNode(this, NodeRemovalReason.UNLOADED);
    }

    public void onBroken() {
        Pastel.getInstance(this.field_11863.field_9236).removeNode(this, NodeRemovalReason.BROKEN);
    }

    public boolean canConnect(PastelNodeBlockEntity node) {
        return this.field_11867.method_19771((class_2382)node.field_11867, 12.0);
    }

    public PastelNetwork getNetwork() {
        return this.network;
    }

    public PastelNodeType getNodeType() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof PastelNodeBlock) {
            PastelNodeBlock pastelNodeBlock = (PastelNodeBlock)class_22482;
            return pastelNodeBlock.pastelNodeType;
        }
        return PastelNodeType.CONNECTION;
    }

    public void setNetwork(PastelNetwork network) {
        this.network = network;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.updateInClientWorld();
            this.method_5431();
        }
    }

    public long getItemCountUnderway() {
        return this.itemCountUnderway;
    }

    public void addItemCountUnderway(long count) {
        this.itemCountUnderway += count;
        this.itemCountUnderway = Math.max(0L, this.itemCountUnderway);
        this.method_5431();
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    @Override
    public List<class_1792> getItemFilters() {
        return this.filterItems;
    }

    @Override
    public void setFilterItem(int slot, class_1792 item) {
        this.filterItems.set(slot, item);
    }

    public Predicate<ItemVariant> getTransferFilterTo(PastelNodeBlockEntity other) {
        if (this.getNodeType().usesFilters() && !this.hasEmptyFilter()) {
            if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
                return itemVariant -> this.filterItems.contains(itemVariant.getItem()) && other.filterItems.contains(itemVariant.getItem());
            }
            return itemVariant -> this.filterItems.contains(itemVariant.getItem());
        }
        if (other.getNodeType().usesFilters() && !other.hasEmptyFilter()) {
            return itemVariant -> other.filterItems.contains(itemVariant.getItem());
        }
        return itemVariant -> true;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.spectrum.pastel_node");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FilteringScreenHandler(syncId, inv, this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        FilterConfigurable.writeScreenOpeningData(buf, this.filterItems);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PastelNodeBlockEntity)) return false;
        PastelNodeBlockEntity blockEntity = (PastelNodeBlockEntity)obj;
        if (!this.field_11867.equals((Object)blockEntity.field_11867)) return false;
        return true;
    }

    public int hashCode() {
        return this.field_11867.hashCode();
    }
}

