/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.PaintbrushTriggered;
import de.dafuqs.spectrum.blocks.RedstonePoweredBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalVariant;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class PedestalBlock
extends class_2237
implements RedstonePoweredBlock,
PaintbrushTriggered {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("place_pedestal");
    public static final class_2746 POWERED = class_2746.method_11825((String)"powered");
    private static final class_265 SHAPE;
    private final PedestalVariant variant;

    public PedestalBlock(class_4970.class_2251 settings, PedestalVariant variant) {
        super(settings);
        this.variant = variant;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static void upgradeToVariant(@NotNull class_1937 world, class_2338 blockPos, PedestalVariant newPedestalVariant) {
        world.method_8501(blockPos, newPedestalVariant.getPedestalBlock().method_9605((class_1750)new class_2968(world, blockPos, class_2350.field_11033, null, class_2350.field_11036)));
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        IMultiblock currentlyRenderedMultiBlock;
        if (world.field_9236 && (currentlyRenderedMultiBlock = PatchouliAPI.get().getCurrentMultiblock()) != null && (currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK) || currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK) || currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_CHECK) || currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK))) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnUpgradeParticleEffectsForTier(class_2338 blockPos, @NotNull PedestalRecipeTier newPedestalRecipeTier) {
        class_638 world = class_310.method_1551().field_1687;
        class_5819 random = world.method_8409();
        switch (newPedestalRecipeTier) {
            case COMPLEX: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7952);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case ADVANCED: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7963);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case SIMPLE: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffectC = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7955);
                class_2400 particleEffectM = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7958);
                class_2400 particleEffectY = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7947);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectY, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectC, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() + 1.1, 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.method_43057() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() - 0.1, 0.0, 0.05, 0.0);
                }
                break;
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (placer instanceof class_3222 && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setOwner((class_1657)((class_3222)placer));
            if (itemStack.method_7938()) {
                pedestalBlockEntity.method_17488(itemStack.method_7964());
            }
            blockEntity.method_5431();
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{POWERED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 actionResult = this.checkAndDoPaintbrushTrigger(state, world, pos, player, hand, hit);
        if (actionResult.method_23665()) {
            return actionResult;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        this.openScreen(world, pos, player);
        return class_1269.field_21466;
    }

    protected void openScreen(class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setOwner(player);
            player.method_17355((class_3908)blockEntity);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2248 class_22482 = newState.method_26204();
        if (class_22482 instanceof PedestalBlock) {
            class_2586 blockEntity;
            PedestalBlock newStateBlock = (PedestalBlock)class_22482;
            if (!state.method_27852((class_2248)newStateBlock) && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity) {
                PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
                if (state.method_26204().equals(newStateBlock)) {
                    PedestalVariant newVariant = newStateBlock.getVariant();
                    pedestalBlockEntity.setVariant(newVariant);
                }
            }
        } else {
            InWorldInteractionBlock.scatterContents(world, pos);
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PedestalBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, @NotNull class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return PedestalBlock.method_31618(type, SpectrumBlockEntities.PEDESTAL, PedestalBlockEntity::clientTick);
        }
        return PedestalBlock.method_31618(type, SpectrumBlockEntities.PEDESTAL, PedestalBlockEntity::serverTick);
    }

    public void method_9612(class_2680 state, @NotNull class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (this.checkGettingPowered(world, pos)) {
                this.power(world, pos);
            } else {
                this.unPower(world, pos);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(@NotNull class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            class_1160 vec3f = new class_1160(0.5f, 0.5f, 0.5f);
            float xOffset = random.method_43057();
            float zOffset = random.method_43057();
            world.method_8406((class_2394)new class_2390(vec3f, 1.0f), (double)((float)pos.method_10263() + xOffset), (double)(pos.method_10264() + 1), (double)((float)pos.method_10260() + zOffset), 0.0, 0.0, 0.0);
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            PedestalBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2680 placementState = this.method_9564();
        if (ctx.method_8045().method_8482(ctx.method_8037()) > 0) {
            placementState = (class_2680)placementState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return placementState;
    }

    public PedestalVariant getVariant() {
        return this.variant;
    }

    @Override
    public class_1269 onPaintBrushTrigger(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            GatedRecipe gatedRecipe;
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            if (pedestalBlockEntity.craftingTime > 0) {
                return class_1269.field_5814;
            }
            if (pedestalBlockEntity.currentRecipe == null) {
                return class_1269.field_5814;
            }
            class_1860<?> class_18602 = pedestalBlockEntity.currentRecipe;
            if (class_18602 instanceof GatedRecipe && !(gatedRecipe = (GatedRecipe)class_18602).canPlayerCraft(player)) {
                return class_1269.field_5814;
            }
            if (!world.field_9236) {
                pedestalBlockEntity.shouldCraft = true;
                SpectrumS2CPacketSender.spawnPedestalStartCraftingParticles(pedestalBlockEntity);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5814;
    }

    static {
        class_265 foot = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
        class_265 neck = class_2248.method_9541((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        class_265 head = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        foot = class_259.method_1084((class_265)foot, (class_265)neck);
        SHAPE = class_259.method_1084((class_265)foot, (class_265)head);
    }
}

