/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.pedestal.BuiltinPedestalVariant;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalVariant;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.inventories.AutoCraftingInventory;
import de.dafuqs.spectrum.inventories.PedestalScreenHandler;
import de.dafuqs.spectrum.items.CraftingTabletItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.ShapedPedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.ShapelessPedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;

public class PedestalBlockEntity
extends class_2624
implements MultiblockCrafter,
class_1737,
class_1278,
ExtendedScreenHandlerFactory {
    public static final int INVENTORY_SIZE = 16;
    public static final int FIRST_POWDER_SLOT_ID = 9;
    public static final int CRAFTING_TABLET_SLOT_ID = 14;
    public static final int OUTPUT_SLOT_ID = 15;
    protected final AutoCraftingInventory autoCraftingInventory;
    protected final class_3913 propertyDelegate;
    protected UUID ownerUUID;
    protected PedestalVariant pedestalVariant;
    protected class_2371<class_1799> inventory;
    protected boolean shouldCraft;
    protected float storedXP;
    protected int craftingTime;
    protected int craftingTimeTotal;
    @Nullable
    public class_1860<?> currentRecipe;
    protected PedestalRecipeTier cachedMaxPedestalTier;
    protected long cachedMaxPedestalTierTick;
    protected Upgradeable.UpgradeHolder upgrades;
    protected boolean inventoryChanged;

    public PedestalBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.PEDESTAL, blockPos, blockState);
        this.pedestalVariant = blockState.method_26204() instanceof PedestalBlock ? ((PedestalBlock)blockState.method_26204()).getVariant() : BuiltinPedestalVariant.BASIC_AMETHYST;
        this.autoCraftingInventory = new AutoCraftingInventory(3, 3);
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> PedestalBlockEntity.this.craftingTime;
                    default -> PedestalBlockEntity.this.craftingTimeTotal;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        PedestalBlockEntity.this.craftingTime = value;
                        break;
                    }
                    case 1: {
                        PedestalBlockEntity.this.craftingTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public static void updateInClientWorld(PedestalBlockEntity pedestalBlockEntity) {
        ((class_3218)pedestalBlockEntity.field_11863).method_14178().method_14128(pedestalBlockEntity.field_11867);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        class_1860<?> currentRecipe = pedestalBlockEntity.getCurrentRecipe();
        if (currentRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            Map<BuiltinGemstoneColor, Integer> gemstonePowderInputs = pedestalRecipe.getPowderInputs();
            for (Map.Entry<BuiltinGemstoneColor, Integer> entry : gemstonePowderInputs.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(entry.getKey().getDyeColor());
                float particleAmount = Support.getIntFromDecimalWithChance((double)amount * 0.125, world.field_9229);
                int i = 0;
                while ((float)i < particleAmount) {
                    float randomX = 2.0f - world.method_8409().method_43057() * 5.0f;
                    float randomZ = 2.0f - world.method_8409().method_43057() * 5.0f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                    ++i;
                }
            }
        }
    }

    public static void spawnCraftingStartParticles(@NotNull class_1937 world, class_2338 blockPos) {
        PedestalBlockEntity pedestalBlockEntity;
        class_1860<?> currentRecipe;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof PedestalBlockEntity && (currentRecipe = (pedestalBlockEntity = (PedestalBlockEntity)blockEntity).getCurrentRecipe()) instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)currentRecipe;
            Map<BuiltinGemstoneColor, Integer> gemstonePowderInputs = pedestalRecipe.getPowderInputs();
            for (Map.Entry<BuiltinGemstoneColor, Integer> entry : gemstonePowderInputs.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(entry.getKey().getDyeColor());
                amount *= 4;
                class_5819 random = world.field_9229;
                for (int i = 0; i < amount; ++i) {
                    class_2338 offsetPos;
                    class_2680 offsetState;
                    class_2350 direction = class_2350.method_10162((class_5819)random);
                    if (direction == class_2350.field_11033 || (offsetState = world.method_8320(offsetPos = blockPos.method_10093(direction))).method_26206((class_1922)world, offsetPos, direction.method_10153())) continue;
                    double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                    double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                    double f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + d, (double)blockPos.method_10264() + e, (double)blockPos.method_10260() + f, 0.0, 0.03, 0.0);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        if (pedestalBlockEntity.upgrades == null) {
            pedestalBlockEntity.calculateUpgrades();
        }
        shouldMarkDirty = false;
        calculatedRecipe = PedestalBlockEntity.calculateRecipe(world, pedestalBlockEntity);
        pedestalBlockEntity.inventoryChanged = false;
        if (pedestalBlockEntity.currentRecipe != calculatedRecipe) {
            pedestalBlockEntity.shouldCraft = false;
            pedestalBlockEntity.currentRecipe = calculatedRecipe;
            pedestalBlockEntity.craftingTime = 0;
            if (calculatedRecipe instanceof PedestalRecipe) {
                calculatedPedestalRecipe = (PedestalRecipe)calculatedRecipe;
                pedestalBlockEntity.craftingTimeTotal = (int)Math.ceil((float)calculatedPedestalRecipe.getCraftingTime() / pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                player = pedestalBlockEntity.getOwnerIfOnline();
                if (player instanceof class_3222) {
                    serverPlayerEntity = (class_3222)player;
                    SpectrumAdvancementCriteria.PEDESTAL_RECIPE_CALCULATED.trigger(serverPlayerEntity, calculatedPedestalRecipe.method_8116((class_1263)pedestalBlockEntity), (int)calculatedPedestalRecipe.getExperience(), pedestalBlockEntity.craftingTimeTotal);
                }
            } else {
                pedestalBlockEntity.craftingTimeTotal = (int)Math.ceil((float)SpectrumCommon.CONFIG.VanillaRecipeCraftingTimeTicks / pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
            }
            pedestalBlockEntity.method_5431();
            SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)pedestalBlockEntity.method_10997(), pedestalBlockEntity.method_11016());
            PedestalBlockEntity.updateInClientWorld(pedestalBlockEntity);
        }
        if (!(pedestalBlockEntity.craftingTime != 0 || pedestalBlockEntity.shouldCraft || blockState.method_26204() instanceof PedestalBlock && ((Boolean)blockState.method_11654((class_2769)PedestalBlock.POWERED)).booleanValue())) {
            return;
        }
        maxCountPerStack = pedestalBlockEntity.method_5444();
        craftingFinished = false;
        if (!(calculatedRecipe instanceof PedestalRecipe)) ** GOTO lbl-1000
        pedestalRecipe = (PedestalRecipe)calculatedRecipe;
        if (pedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, (class_1263)pedestalBlockEntity, maxCountPerStack)) {
            ++pedestalBlockEntity.craftingTime;
            if (pedestalBlockEntity.craftingTime == pedestalBlockEntity.craftingTimeTotal) {
                pedestalBlockEntity.craftingTime = 0;
                craftingFinished = PedestalBlockEntity.craftPedestalRecipe(pedestalBlockEntity, pedestalRecipe, (class_1263)pedestalBlockEntity, maxCountPerStack);
                if (craftingFinished) {
                    pedestalBlockEntity.inventoryChanged = true;
                }
                shouldMarkDirty = true;
            }
        } else if (calculatedRecipe instanceof class_3955) {
            vanillaCraftingRecipe = (class_3955)calculatedRecipe;
            if (pedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, (class_1263)pedestalBlockEntity, maxCountPerStack)) {
                ++pedestalBlockEntity.craftingTime;
                if (pedestalBlockEntity.craftingTime == pedestalBlockEntity.craftingTimeTotal) {
                    pedestalBlockEntity.craftingTime = 0;
                    craftingFinished = pedestalBlockEntity.craftVanillaRecipe(vanillaCraftingRecipe, (class_1263)pedestalBlockEntity, maxCountPerStack);
                    if (craftingFinished) {
                        pedestalBlockEntity.inventoryChanged = true;
                    }
                    shouldMarkDirty = true;
                }
            }
        }
        if (pedestalBlockEntity.craftingTime == 1 && pedestalBlockEntity.craftingTimeTotal > 1) {
            SpectrumS2CPacketSender.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.PEDESTAL_CRAFTING, (class_3218)pedestalBlockEntity.field_11863, pedestalBlockEntity.method_11016(), pedestalBlockEntity.craftingTimeTotal - pedestalBlockEntity.craftingTime);
        }
        if ((outputItemStack = (class_1799)pedestalBlockEntity.inventory.get(15)) != class_1799.field_8037) {
            if (world.method_8320(blockPos.method_10084()).method_26220((class_1922)world, blockPos.method_10084()).method_1110()) {
                PedestalBlockEntity.spawnOutputAsItemEntity(world, blockPos, pedestalBlockEntity, outputItemStack);
                PedestalBlockEntity.playCraftingFinishedSoundEvent(pedestalBlockEntity, calculatedRecipe);
            } else {
                aboveBlockEntity = world.method_8321(blockPos.method_10084());
                if (aboveBlockEntity instanceof class_1263) {
                    aboveInventory = (class_1263)aboveBlockEntity;
                    putIntoAboveInventorySuccess = PedestalBlockEntity.tryPutOutputIntoAboveInventory(pedestalBlockEntity, aboveInventory, outputItemStack);
                    if (putIntoAboveInventorySuccess) {
                        PedestalBlockEntity.playCraftingFinishedSoundEvent(pedestalBlockEntity, calculatedRecipe);
                    } else if (craftingFinished) {
                        pedestalBlockEntity.playSound(class_3417.field_19198);
                    }
                } else if (craftingFinished) {
                    pedestalBlockEntity.playSound(class_3417.field_19198);
                }
            }
        }
        if (shouldMarkDirty) {
            PedestalBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
        }
    }

    @Contract(pure=true)
    public static PedestalVariant getVariant(@NotNull PedestalBlockEntity pedestalBlockEntity) {
        return pedestalBlockEntity.pedestalVariant;
    }

    public static void spawnOutputAsItemEntity(class_1937 world, class_2338 blockPos, @NotNull PedestalBlockEntity pedestalBlockEntity, class_1799 outputItemStack) {
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, pedestalBlockEntity.field_11867, outputItemStack, outputItemStack.method_7947(), new class_243(0.0, 0.1, 0.0));
        pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
        MultiblockCrafter.spawnExperience(world, pedestalBlockEntity.field_11867, pedestalBlockEntity.storedXP, pedestalBlockEntity.method_10997().field_9229);
        pedestalBlockEntity.storedXP = 0.0f;
        SpectrumS2CPacketSender.sendPlayPedestalCraftingFinishedParticle(world, blockPos, outputItemStack);
    }

    public static boolean tryPutOutputIntoAboveInventory(PedestalBlockEntity pedestalBlockEntity, class_1263 targetInventory, class_1799 outputItemStack) {
        if (targetInventory instanceof class_2614) {
            return false;
        }
        class_1799 remainingStack = InventoryHelper.smartAddToInventory(outputItemStack, targetInventory, class_2350.field_11033);
        if (remainingStack.method_7960()) {
            pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
            return true;
        }
        pedestalBlockEntity.inventory.set(15, (Object)remainingStack);
        return false;
    }

    public static void playCraftingFinishedSoundEvent(PedestalBlockEntity pedestalBlockEntity, class_1860<?> craftingRecipe) {
        if (craftingRecipe instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)craftingRecipe;
            pedestalBlockEntity.playSound(pedestalRecipe.getSoundEvent(pedestalBlockEntity.field_11863.field_9229));
        } else {
            pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC);
        }
    }

    @Nullable
    public static class_1860<?> calculateRecipe(class_1937 world, @NotNull PedestalBlockEntity pedestalBlockEntity) {
        PedestalRecipe pedestalRecipe;
        if (!pedestalBlockEntity.inventoryChanged) {
            return pedestalBlockEntity.currentRecipe;
        }
        class_1860<?> class_18602 = pedestalBlockEntity.currentRecipe;
        if (class_18602 instanceof PedestalRecipe && (pedestalRecipe = (PedestalRecipe)class_18602).method_8115((class_1263)pedestalBlockEntity, world)) {
            return pedestalBlockEntity.currentRecipe;
        }
        if (SpectrumCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
            class_3955 craftingRecipe;
            pedestalBlockEntity.autoCraftingInventory.setInputInventory(pedestalBlockEntity.inventory.subList(0, 9));
            class_18602 = pedestalBlockEntity.currentRecipe;
            if (class_18602 instanceof class_3955 && (craftingRecipe = (class_3955)class_18602).method_8115((class_1263)pedestalBlockEntity.autoCraftingInventory, world)) {
                return pedestalBlockEntity.currentRecipe;
            }
        }
        if ((pedestalRecipe = (PedestalRecipe)world.method_8433().method_8132(SpectrumRecipeTypes.PEDESTAL, (class_1263)pedestalBlockEntity, world).orElse(null)) == null) {
            if (SpectrumCommon.CONFIG.canPedestalCraftVanillaRecipes()) {
                return world.method_8433().method_8132(class_3956.field_17545, (class_1263)pedestalBlockEntity.autoCraftingInventory, world).orElse(null);
            }
            return null;
        }
        if (!pedestalRecipe.canCraft(pedestalBlockEntity)) {
            return null;
        }
        return pedestalRecipe;
    }

    private boolean canAcceptRecipeOutput(@Nullable class_1860<?> recipe, class_1263 inventory, int maxCountPerStack) {
        if (recipe != null) {
            class_1799 output;
            if (recipe instanceof PedestalRecipe) {
                PedestalRecipe pedestalRecipe = (PedestalRecipe)recipe;
                output = pedestalRecipe.method_8116(inventory);
            } else if (recipe instanceof class_3955) {
                class_3955 craftingRecipe = (class_3955)recipe;
                this.autoCraftingInventory.setInputInventory(inventory, 0, 9);
                output = craftingRecipe.method_8116((class_1263)this.autoCraftingInventory);
            } else {
                output = class_1799.field_8037;
            }
            if (output.method_7960()) {
                return false;
            }
            class_1799 existingOutput = this.method_5438(15);
            if (existingOutput.method_7960()) {
                return true;
            }
            if (!existingOutput.method_7962(output)) {
                return false;
            }
            if (existingOutput.method_7947() < maxCountPerStack && existingOutput.method_7947() < existingOutput.method_7914()) {
                return true;
            }
            return existingOutput.method_7947() < output.method_7914();
        }
        return false;
    }

    private static boolean craftPedestalRecipe(PedestalBlockEntity pedestalBlockEntity, @Nullable PedestalRecipe recipe, class_1263 inventory, int maxCountPerStack) {
        double yieldModifier;
        if (!pedestalBlockEntity.canAcceptRecipeOutput(recipe, inventory, maxCountPerStack)) {
            return false;
        }
        class_1799 outputStack = recipe.method_8116((class_1263)pedestalBlockEntity);
        recipe.consumeIngredients(pedestalBlockEntity);
        if (!recipe.areYieldUpgradesDisabled() && (yieldModifier = (double)pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.YIELD)) != 1.0) {
            int modifiedCount = Support.getIntFromDecimalWithChance((double)outputStack.method_7947() * yieldModifier, pedestalBlockEntity.field_11863.field_9229);
            outputStack.method_7939(Math.min(outputStack.method_7914(), modifiedCount));
        }
        float experience = recipe.getExperience() * pedestalBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE);
        pedestalBlockEntity.storedXP += experience;
        class_1657 player = pedestalBlockEntity.getOwnerIfOnline();
        if (player != null) {
            outputStack.method_7982(pedestalBlockEntity.field_11863, player, outputStack.method_7947());
        }
        pedestalBlockEntity.grantPlayerPedestalCraftingAdvancement(outputStack, (int)experience, pedestalBlockEntity.craftingTimeTotal);
        PedestalVariant newPedestalVariant = PedestalRecipe.getUpgradedPedestalVariantForOutput(outputStack);
        if (newPedestalVariant != null && newPedestalVariant.isBetterThan(PedestalBlockEntity.getVariant(pedestalBlockEntity))) {
            pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_UPGRADE);
            PedestalBlock.upgradeToVariant(pedestalBlockEntity.field_11863, pedestalBlockEntity.method_11016(), newPedestalVariant);
            SpectrumS2CPacketSender.spawnPedestalUpgradeParticles(pedestalBlockEntity.field_11863, pedestalBlockEntity.field_11867, newPedestalVariant);
            pedestalBlockEntity.pedestalVariant = newPedestalVariant;
            pedestalBlockEntity.currentRecipe = null;
        } else {
            class_1799 existingOutput = inventory.method_5438(15);
            if (!existingOutput.method_7960()) {
                outputStack.method_7939(Math.min(existingOutput.method_7914(), existingOutput.method_7947() + outputStack.method_7947()));
            }
            inventory.method_5447(15, outputStack);
        }
        pedestalBlockEntity.method_5431();
        pedestalBlockEntity.inventoryChanged = true;
        PedestalBlockEntity.updateInClientWorld(pedestalBlockEntity);
        return true;
    }

    public static class_1792 getGemstonePowderItemForSlot(int slot) {
        return switch (slot) {
            case 9 -> SpectrumItems.TOPAZ_POWDER;
            case 10 -> SpectrumItems.AMETHYST_POWDER;
            case 11 -> SpectrumItems.CITRINE_POWDER;
            case 12 -> SpectrumItems.ONYX_POWDER;
            case 13 -> SpectrumItems.MOONSTONE_POWDER;
            default -> class_1802.field_8162;
        };
    }

    public static int getSlotForGemstonePowder(BuiltinGemstoneColor gemstoneColor) {
        return switch (gemstoneColor) {
            case BuiltinGemstoneColor.CYAN -> 9;
            case BuiltinGemstoneColor.MAGENTA -> 10;
            case BuiltinGemstoneColor.YELLOW -> 11;
            case BuiltinGemstoneColor.BLACK -> 12;
            default -> 13;
        };
    }

    public void setVariant(PedestalVariant pedestalVariant) {
        this.pedestalVariant = pedestalVariant;
        this.propertyDelegate.method_17391(2, pedestalVariant.getRecipeTier().ordinal());
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.pedestal");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new PedestalScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate, this.pedestalVariant.getRecipeTier().ordinal(), this.getHighestAvailableRecipeTier().ordinal(), this.field_11867);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack = class_1262.method_5428(this.inventory, (int)slot);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.inventoryChanged = true;
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_7683(class_1662 recipeMatcher) {
        for (class_1799 itemStack : this.inventory) {
            recipeMatcher.method_7400(itemStack);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        if (nbt.method_10545("StoredXP")) {
            this.storedXP = nbt.method_10583("StoredXP");
        }
        if (nbt.method_10545("CraftingTime")) {
            this.craftingTime = nbt.method_10568("CraftingTime");
        }
        if (nbt.method_10545("CraftingTimeTotal")) {
            this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
        if (nbt.method_10545("inventory_changed")) {
            this.inventoryChanged = nbt.method_10577("inventory_changed");
        }
        this.currentRecipe = null;
        if (nbt.method_10545("CurrentRecipe")) {
            class_2960 recipeIdentifier = new class_2960(nbt.method_10558("CurrentRecipe"));
            this.currentRecipe = MultiblockCrafter.getRecipeFromId(this.field_11863, recipeIdentifier);
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("StoredXP", this.storedXP);
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbt.method_10556("inventory_changed", this.inventoryChanged);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public boolean isCrafting() {
        return this.craftingTime > 0;
    }

    private void playSound(class_3414 soundEvent) {
        class_5819 random = this.field_11863.field_9229;
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, 0.9f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f);
    }

    private boolean craftVanillaRecipe(@Nullable class_3955 recipe, class_1263 inventory, int maxCountPerStack) {
        if (this.canAcceptRecipeOutput((class_1860<?>)recipe, inventory, maxCountPerStack)) {
            this.autoCraftingInventory.setInputInventory(inventory, 0, 9);
            class_1799 recipeOutput = recipe.method_8116((class_1263)this.autoCraftingInventory);
            class_1657 player = this.getOwnerIfOnline();
            if (player != null) {
                recipeOutput.method_7982(this.field_11863, player, recipeOutput.method_7947());
            }
            this.decrementInputStacks(inventory);
            class_1799 existingOutput = inventory.method_5438(15);
            if (existingOutput.method_7960()) {
                inventory.method_5447(15, recipeOutput.method_7972());
            } else {
                existingOutput.method_7933(recipeOutput.method_7947());
                inventory.method_5447(15, existingOutput);
            }
            return true;
        }
        return false;
    }

    private void decrementInputStacks(class_1263 inventory) {
        for (int i = 0; i < 9; ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_1799 remainder = itemStack.getRecipeRemainder();
            if (remainder.method_7960()) {
                itemStack.method_7934(1);
                continue;
            }
            if (((class_1799)this.inventory.get(i)).method_7947() == 1) {
                this.inventory.set(i, (Object)remainder);
                continue;
            }
            ((class_1799)this.inventory.get(i)).method_7934(1);
            class_1542 itemEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, remainder);
            itemEntity.method_5762(0.0, 0.05, 0.0);
            this.field_11863.method_8649((class_1297)itemEntity);
        }
    }

    private void grantPlayerPedestalCraftingAdvancement(class_1799 output, int experience, int duration) {
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.PEDESTAL_CRAFTING.trigger(serverPlayerEntity, output, experience, duration);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot < 9) {
            return true;
        }
        if (slot == 14 && stack.method_31574(SpectrumItems.CRAFTING_TABLET)) {
            return true;
        }
        return stack.method_7909().equals(PedestalBlockEntity.getGemstonePowderItemForSlot(slot));
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{15};
        }
        if (side == class_2350.field_11036) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        }
        switch (this.pedestalVariant.getRecipeTier()) {
            case COMPLEX: {
                return new int[]{9, 10, 11, 12, 13};
            }
            case ADVANCED: {
                return new int[]{9, 10, 11, 12};
            }
        }
        return new int[]{9, 10, 11};
    }

    public boolean method_5492(int slot, @NotNull class_1799 stack, @Nullable class_2350 dir) {
        if (stack.method_31574(PedestalBlockEntity.getGemstonePowderItemForSlot(slot))) {
            return true;
        }
        if (slot < 9 && ((class_1799)this.inventory.get(14)).method_31574(SpectrumItems.CRAFTING_TABLET)) {
            int resultRecipeSlot;
            class_1799 craftingTabletItem = (class_1799)this.inventory.get(14);
            if (((class_1799)this.inventory.get(slot)).method_7947() > 0) {
                return false;
            }
            class_1860<?> storedRecipe = CraftingTabletItem.getStoredRecipe(this.field_11863, craftingTabletItem);
            int width = 3;
            if (storedRecipe instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)storedRecipe;
                width = shapedRecipe.method_8150();
                if (slot % 3 >= width) {
                    return false;
                }
            } else if (storedRecipe instanceof ShapedPedestalRecipe) {
                ShapedPedestalRecipe pedestalRecipe = (ShapedPedestalRecipe)storedRecipe;
                width = pedestalRecipe.getWidth();
                if (slot % 3 >= width) {
                    return false;
                }
            } else if (!(storedRecipe instanceof class_1867) && !(storedRecipe instanceof ShapelessPedestalRecipe)) {
                return false;
            }
            if ((resultRecipeSlot = this.getCraftingRecipeSlotDependingOnWidth(slot, width)) < storedRecipe.method_8117().size()) {
                class_1856 ingredient = (class_1856)storedRecipe.method_8117().get(resultRecipeSlot);
                return ingredient.method_8093(stack);
            }
            return false;
        }
        return slot < 14;
    }

    private int getCraftingRecipeSlotDependingOnWidth(int slot, int recipeWidth) {
        int line = slot / 3;
        int posInLine = slot % 3;
        return line * recipeWidth + posInLine;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 15;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nullable
    public class_1860<?> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public class_1799 getCurrentCraftingRecipeOutput() {
        if (this.currentRecipe == null) {
            return class_1799.field_8037;
        }
        class_1860<?> class_18602 = this.currentRecipe;
        if (class_18602 instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)class_18602;
            return pedestalRecipe.method_8116((class_1263)this);
        }
        class_18602 = this.currentRecipe;
        if (class_18602 instanceof class_3955) {
            class_3955 craftingRecipe = (class_3955)class_18602;
            this.autoCraftingInventory.setInputInventory((class_1263)this, 0, 9);
            return craftingRecipe.method_8116((class_1263)this.autoCraftingInventory);
        }
        return class_1799.field_8037;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.pedestalVariant.getRecipeTier().ordinal());
        buf.writeInt(this.getHighestAvailableRecipeTier().ordinal());
        buf.method_10807(this.field_11867);
    }

    public PedestalRecipeTier getHighestAvailableRecipeTier() {
        PedestalRecipeTier denominator;
        if (this.field_11863.method_8510() <= this.cachedMaxPedestalTierTick + 20L) {
            return this.cachedMaxPedestalTier;
        }
        PedestalRecipeTier pedestalTier = this.getPedestalTier();
        PedestalRecipeTier structureTier = this.getStructureTier();
        this.cachedMaxPedestalTier = denominator = PedestalRecipeTier.values()[Math.min(pedestalTier.ordinal(), structureTier.ordinal())];
        this.cachedMaxPedestalTierTick = this.field_11863.method_8510();
        return denominator;
    }

    private PedestalRecipeTier getPedestalTier() {
        return this.pedestalVariant.getRecipeTier();
    }

    @NotNull
    private PedestalRecipeTier getStructureTier() {
        IMultiblock multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.COMPLEX;
        }
        multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_CHECK);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.ADVANCED;
        }
        multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.ADVANCED;
        }
        multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK);
        if (multiblock.validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467)) {
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getOwnerIfOnline(), multiblock);
            return PedestalRecipeTier.SIMPLE;
        }
        return PedestalRecipeTier.BASIC;
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 3, 2, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    public void setInventoryChanged() {
        this.inventoryChanged = true;
    }
}

