/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.present;

import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.blocks.present.PresentItem;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.interfaces.PlayerOwnedWithName;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class PresentBlockEntity
extends class_2586
implements PlayerOwnedWithName {
    protected final class_2371<class_1799> stacks = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    protected Map<class_1767, Integer> colors = new HashMap<class_1767, Integer>();
    private UUID ownerUUID;
    private String ownerName;
    private UUID openerUUID;
    protected int openingTicks = 0;

    public PresentBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.PRESENT, pos, state);
    }

    public void setDataFromPresentStack(class_1799 stack) {
        List<class_1799> s = PresentItem.getBundledStacks(stack).toList();
        for (int i = 0; i < 5 && i < s.size(); ++i) {
            this.stacks.set(i, (Object)s.get(i));
        }
        this.colors = PresentItem.getColors(stack);
        Optional<class_3545<UUID, String>> wrapper = PresentItem.getWrapper(stack);
        if (wrapper.isPresent()) {
            this.ownerUUID = (UUID)wrapper.get().method_15442();
            this.ownerName = (String)wrapper.get().method_15441();
        }
        this.method_5431();
    }

    public void triggerAdvancement() {
        class_1657 wrapper;
        UUID wrapperUUID;
        class_1657 opener;
        UUID openerUUID = this.getOpenerUUID();
        if (openerUUID != null && (opener = PlayerOwned.getPlayerEntityIfOnline(openerUUID)) != null) {
            Support.grantAdvancementCriterion((class_3222)opener, "gift_or_open_present", "gifted_or_opened_present");
        }
        if ((wrapperUUID = this.getOwnerUUID()) != null && (wrapper = PlayerOwned.getPlayerEntityIfOnline(wrapperUUID)) != null) {
            Support.grantAdvancementCriterion((class_3222)wrapper, "gift_or_open_present", "gifted_or_opened_present");
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.stacks);
        this.colors = PresentItem.getColors(nbt);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.ownerName = PlayerOwned.readOwnerName(nbt);
        this.openerUUID = nbt.method_10545("OpenerUUID") ? nbt.method_25926("OpenerUUID") : null;
        if (nbt.method_10573("OpeningTick", 99)) {
            this.openingTicks = nbt.method_10550("OpeningTick");
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.stacks.isEmpty()) {
            class_1262.method_5426((class_2487)nbt, this.stacks);
        }
        if (!this.colors.isEmpty()) {
            PresentItem.setColors(nbt, this.colors);
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        PlayerOwned.writeOwnerName(nbt, this.ownerName);
        if (this.openerUUID != null) {
            nbt.method_25927("OpenerUUID", this.openerUUID);
        }
        if (this.openingTicks > 0) {
            nbt.method_10569("OpeningTick", this.openingTicks);
        }
    }

    public int openingTick() {
        ++this.openingTicks;
        this.method_5431();
        return this.openingTicks;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.ownerName = playerEntity.method_5477().getString();
        this.method_5431();
    }

    public void setOpenerUUID(class_1657 opener) {
        this.openerUUID = opener.method_5667();
        this.method_5431();
    }

    public UUID getOpenerUUID() {
        return this.openerUUID;
    }

    public class_1799 retrievePresent(PresentBlock.WrappingPaper wrappingPaper) {
        class_1799 presentStack = SpectrumBlocks.PRESENT.method_8389().method_7854();
        for (class_1799 contentStack : this.stacks) {
            PresentItem.addToPresent(presentStack, contentStack);
        }
        PresentItem.wrap(presentStack, wrappingPaper, this.colors);
        if (this.ownerUUID != null && this.ownerName != null) {
            PresentItem.setWrapper(presentStack, this.ownerUUID, this.ownerName);
        }
        return presentStack;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 5; ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960()) continue;
            return false;
        }
        return true;
    }
}

