/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.redstone;

import de.dafuqs.spectrum.blocks.redstone.RedstoneWirelessBlock;
import de.dafuqs.spectrum.events.RedstoneTransferGameEvent;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.listeners.EventQueue;
import de.dafuqs.spectrum.events.listeners.WirelessRedstoneSignalEventQueue;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneWirelessBlockEntity
extends class_2586
implements EventQueue.Callback<WirelessRedstoneSignalEventQueue.EventEntry> {
    private static final int RANGE = 16;
    private final WirelessRedstoneSignalEventQueue listener;
    private int cachedSignal;
    private int currentSignal;

    public RedstoneWirelessBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.REDSTONE_WIRELESS, blockPos, blockState);
        this.listener = new WirelessRedstoneSignalEventQueue((class_5716)new class_5707(this.field_11867), 16, this);
    }

    private static boolean isSender(class_1937 world, class_2338 blockPos) {
        if (world == null) {
            return false;
        }
        return (Boolean)world.method_8320(blockPos).method_11654((class_2769)RedstoneWirelessBlock.SENDER);
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 pos, class_2680 state, @NotNull RedstoneWirelessBlockEntity blockEntity) {
        if (RedstoneWirelessBlockEntity.isSender(world, pos)) {
            if (blockEntity.currentSignal != blockEntity.cachedSignal) {
                blockEntity.currentSignal = blockEntity.cachedSignal;
                blockEntity.field_11863.method_33596(null, (class_5712)SpectrumGameEvents.WIRELESS_REDSTONE_SIGNALS.get(state.method_11654(RedstoneWirelessBlock.CHANNEL)).get(blockEntity.currentSignal), blockEntity.method_11016());
            }
        } else {
            blockEntity.listener.tick(world);
        }
    }

    public static class_1767 getChannel(class_1937 world, class_2338 pos) {
        if (world == null) {
            return class_1767.field_7964;
        }
        return (class_1767)world.method_8320(pos).method_11654(RedstoneWirelessBlock.CHANNEL);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("signal", this.currentSignal);
        tag.method_10569("cached_signal", this.cachedSignal);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.currentSignal = tag.method_10550("output_signal");
        this.cachedSignal = tag.method_10550("cached_signal");
    }

    @Nullable
    public WirelessRedstoneSignalEventQueue getEventListener() {
        return this.listener;
    }

    public int getRange() {
        return 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canAcceptEvent(class_1937 world, class_5714 listener, class_5712.class_7447 message, class_243 sourcePos) {
        if (this.method_11015()) return false;
        class_5712 class_57122 = message.method_43724();
        if (!(class_57122 instanceof RedstoneTransferGameEvent)) return false;
        RedstoneTransferGameEvent redstoneTransferGameEvent = (RedstoneTransferGameEvent)class_57122;
        if (RedstoneWirelessBlockEntity.isSender(this.field_11863, this.field_11867)) return false;
        if (redstoneTransferGameEvent.getDyeColor() != RedstoneWirelessBlockEntity.getChannel(this.field_11863, this.field_11867)) return false;
        return true;
    }

    @Override
    public void triggerEvent(class_1937 world, class_5714 listener, WirelessRedstoneSignalEventQueue.EventEntry redstoneEvent) {
        if (!RedstoneWirelessBlockEntity.isSender(this.field_11863, this.field_11867) && redstoneEvent.gameEvent.getDyeColor() == RedstoneWirelessBlockEntity.getChannel(this.field_11863, this.field_11867)) {
            int receivedSignal;
            this.currentSignal = receivedSignal = redstoneEvent.gameEvent.getPower();
            if (receivedSignal == 0) {
                world.method_8652(this.field_11867, (class_2680)world.method_8320(this.field_11867).method_11657((class_2769)RedstoneWirelessBlock.field_10911, (Comparable)Boolean.valueOf(false)), 2);
            } else {
                world.method_8652(this.field_11867, (class_2680)world.method_8320(this.field_11867).method_11657((class_2769)RedstoneWirelessBlock.field_10911, (Comparable)Boolean.valueOf(true)), 2);
            }
            world.method_8408(this.field_11867, SpectrumBlocks.REDSTONE_WIRELESS);
        }
    }

    public void setSignalStrength(int newSignal) {
        if (RedstoneWirelessBlockEntity.isSender(this.field_11863, this.field_11867)) {
            this.cachedSignal = newSignal;
        } else {
            this.currentSignal = newSignal;
        }
    }

    public int getCurrentSignal() {
        if (RedstoneWirelessBlockEntity.isSender(this.field_11863, this.field_11867)) {
            return 0;
        }
        return this.currentSignal;
    }

    public int getCurrentSignalStrength() {
        return this.currentSignal;
    }
}

