/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.shooting_star;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlockEntity;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarItem;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import net.minecraft.class_10;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShootingStarBlock
extends class_2237 {
    protected static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public final Type shootingStarType;

    public ShootingStarBlock(class_4970.class_2251 settings, Type shootingStarType) {
        super(settings);
        this.shootingStarType = shootingStarType;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ShootingStarBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(world, pos, state);
        world.method_35230(pos, SpectrumBlockEntities.SHOOTING_STAR).ifPresent(blockEntity -> blockEntity.method_38240(itemStack));
        return itemStack;
    }

    public void method_9576(@NotNull class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && !player.method_7337()) {
            class_1799 itemStack = this.shootingStarType.getBlock().method_8389().method_7854();
            world.method_35230(pos, SpectrumBlockEntities.SHOOTING_STAR).ifPresent(blockEntity -> ShootingStarItem.getWithRemainingHits(itemStack, blockEntity.remainingHits, blockEntity.hardened));
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9567(@NotNull class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (!world.field_9236 && (blockEntity = world.method_8321(pos)) instanceof ShootingStarBlockEntity) {
            ShootingStarBlockEntity shootingStarBlockEntity = (ShootingStarBlockEntity)blockEntity;
            shootingStarBlockEntity.setData(ShootingStarItem.getRemainingHits(itemStack), ShootingStarItem.isHardened(itemStack));
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public static enum Type {
        GLISTERING("glistering"),
        FIERY("fiery"),
        COLORFUL("colorful"),
        PRISTINE("pristine"),
        GEMSTONE("gemstone");

        public static final class_2960 BOUNCE_LOOT_TABLE;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type getWeightedRandomType(@NotNull class_5819 random) {
            int r = random.method_43048(8);
            if (r == 0) {
                return FIERY;
            }
            if (r == 1) {
                return PRISTINE;
            }
            if (r < 3) {
                return GLISTERING;
            }
            if (r < 5) {
                return COLORFUL;
            }
            return GEMSTONE;
        }

        public static Type getType(int type) {
            Type[] types = Type.values();
            if (type < 0 || type >= types.length) {
                type = 0;
            }
            return types[type];
        }

        public static Type getType(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }

        @Contract(value="_ -> new")
        @NotNull
        public static class_2960 getLootTableIdentifier(int index) {
            return Type.getLootTableIdentifier(Type.values()[index]);
        }

        @Contract(value="_ -> new")
        @NotNull
        public static class_2960 getLootTableIdentifier(@NotNull Type type) {
            switch (type) {
                case FIERY: {
                    return SpectrumCommon.locate("entity/shooting_star/shooting_star_fiery");
                }
                case COLORFUL: {
                    return SpectrumCommon.locate("entity/shooting_star/shooting_star_colorful");
                }
                case GEMSTONE: {
                    return SpectrumCommon.locate("entity/shooting_star/shooting_star_gemstone");
                }
                case PRISTINE: {
                    return SpectrumCommon.locate("entity/shooting_star/shooting_star_pristine");
                }
            }
            return SpectrumCommon.locate("entity/shooting_star/shooting_star_glistering");
        }

        public String getName() {
            return this.name;
        }

        public class_2248 getBlock() {
            switch (this) {
                case PRISTINE: {
                    return SpectrumBlocks.PRISTINE_SHOOTING_STAR;
                }
                case GEMSTONE: {
                    return SpectrumBlocks.GEMSTONE_SHOOTING_STAR;
                }
                case FIERY: {
                    return SpectrumBlocks.FIERY_SHOOTING_STAR;
                }
                case COLORFUL: {
                    return SpectrumBlocks.COLORFUL_SHOOTING_STAR;
                }
            }
            return SpectrumBlocks.GLISTERING_SHOOTING_STAR;
        }

        @NotNull
        public class_1160 getRandomParticleColor(class_5819 random) {
            switch (this) {
                case GLISTERING: {
                    int r = random.method_43048(5);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7947);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(class_1767.field_7952);
                    }
                    if (r == 2) {
                        return ColorHelper.getRGBVec(class_1767.field_7946);
                    }
                    if (r == 3) {
                        return ColorHelper.getRGBVec(class_1767.field_7961);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7966);
                }
                case COLORFUL: {
                    return ColorHelper.getRGBVec(class_1767.values()[random.method_43048(class_1767.values().length)]);
                }
                case FIERY: {
                    int r = random.method_43048(2);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7946);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7964);
                }
                case PRISTINE: {
                    int r = random.method_43048(3);
                    if (r == 0) {
                        return ColorHelper.getRGBVec(class_1767.field_7966);
                    }
                    if (r == 1) {
                        return ColorHelper.getRGBVec(class_1767.field_7951);
                    }
                    return ColorHelper.getRGBVec(class_1767.field_7955);
                }
            }
            int r = random.method_43048(4);
            if (r == 0) {
                return ColorHelper.getRGBVec(class_1767.field_7955);
            }
            if (r == 1) {
                return ColorHelper.getRGBVec(class_1767.field_7958);
            }
            if (r == 2) {
                return ColorHelper.getRGBVec(class_1767.field_7952);
            }
            return ColorHelper.getRGBVec(class_1767.field_7947);
        }

        static {
            BOUNCE_LOOT_TABLE = SpectrumCommon.locate("entity/shooting_star/shooting_star_bounce");
        }
    }

    public static class ShootingStarBlockDispenserBehavior
    extends class_2347 {
        public class_1799 method_10135(@NotNull class_2342 pointer, @NotNull class_1799 stack) {
            class_2350 direction = (class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_3218 world = pointer.method_10207();
            double d = pointer.method_10216() + (double)((float)direction.method_10148() * 1.125f);
            double e = pointer.method_10214() + (double)((float)direction.method_10164() * 1.125f);
            double f = pointer.method_10215() + (double)((float)direction.method_10165() * 1.125f);
            ShootingStarEntity shootingStarEntity = new ShootingStarEntity((class_1937)world, d, e + 0.05, f);
            Type type = ((ShootingStarItem)stack.method_7909()).getType();
            shootingStarEntity.setShootingStarType(type, true, ShootingStarItem.isHardened(stack));
            shootingStarEntity.setAvailableHits(ShootingStarItem.getRemainingHits(stack));
            shootingStarEntity.method_36456(direction.method_10144());
            shootingStarEntity.method_5762((double)direction.method_10148() * 0.4, (double)direction.method_10164() * 0.4, (double)direction.method_10165() * 0.4);
            world.method_8649((class_1297)shootingStarEntity);
            stack.method_7934(1);
            return stack;
        }
    }
}

