/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.titration_barrel;

import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorageUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlock
extends class_2383
implements class_2343 {
    public static final class_2754<BarrelState> BARREL_STATE = class_2754.method_11850((String)"barrel_state", BarrelState.class);

    public TitrationBarrelBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TitrationBarrelBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity barrelEntity = (TitrationBarrelBlockEntity)blockEntity;
            BarrelState barrelState = (BarrelState)((Object)state.method_11654(BARREL_STATE));
            switch (barrelState) {
                case EMPTY: 
                case FILLED: {
                    if (player.method_5715()) {
                        if (barrelState != BarrelState.FILLED) break;
                        this.tryExtractLastStack(state, world, pos, player, barrelEntity);
                        break;
                    }
                    class_1799 handStack = player.method_5998(hand);
                    if (handStack.method_7960()) {
                        int itemCount = InventoryHelper.countItemsInInventory((class_1263)barrelEntity.inventory);
                        class_3611 fluid = ((FluidVariant)barrelEntity.fluidStorage.variant).getFluid();
                        if (fluid == class_3612.field_15906) {
                            if (itemCount == 64) {
                                player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.content_count_without_fluid_full", (Object[])new Object[]{itemCount}), true);
                                break;
                            }
                            player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.content_count_without_fluid", (Object[])new Object[]{itemCount}), true);
                            break;
                        }
                        String fluidName = fluid.method_15785().method_15759().method_26204().method_9518().getString();
                        if (itemCount == 64) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.content_count_with_fluid_full", (Object[])new Object[]{fluidName, itemCount}), true);
                            break;
                        }
                        player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.content_count_with_fluid", (Object[])new Object[]{fluidName, itemCount}), true);
                        break;
                    }
                    if (handStack.method_31573(SpectrumItemTags.COLORED_PLANKS)) {
                        if (barrelEntity.canBeSealed(player)) {
                            if (!player.method_7337()) {
                                handStack.method_7934(1);
                            }
                            this.sealBarrel(world, pos, state, barrelEntity, player);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe"), true);
                        }
                        return class_1269.field_21466;
                    }
                    if (ContainerItemContext.forPlayerInteraction((class_1657)player, (class_1268)hand).find(FluidStorage.ITEM) != null) {
                        if (FluidStorageUtil.interactWithFluidStorage(barrelEntity.fluidStorage, (class_1657)player, (class_1268)hand)) {
                            if (barrelEntity.getFluidVariant().isBlank()) {
                                if (state.method_11654(BARREL_STATE) == BarrelState.FILLED && barrelEntity.inventory.method_5442()) {
                                    world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
                                }
                            } else if (state.method_11654(BARREL_STATE) == BarrelState.EMPTY) {
                                world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.FILLED)));
                            }
                        }
                        return class_1269.field_21466;
                    }
                    int countBefore = handStack.method_7947();
                    class_1799 leftoverStack = InventoryHelper.addToInventoryUpToSingleStackWithMaxTotalCount(handStack, barrelEntity.getInventory(), 64);
                    player.method_6122(hand, leftoverStack);
                    if (countBefore == leftoverStack.method_7947()) break;
                    world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
                    if (barrelState == BarrelState.EMPTY) {
                        world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.FILLED)));
                        break;
                    }
                    world.method_8455(pos, (class_2248)this);
                    break;
                }
                case SEALED: {
                    if (player.method_5715()) {
                        this.unsealBarrel(world, pos, state, barrelEntity);
                        break;
                    }
                    if (player.method_7337() && player.method_6047().method_31574(SpectrumItems.PAINTBRUSH)) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.debug_added_day"), true);
                        barrelEntity.addDayOfSealTime();
                        world.method_8396(null, pos, SpectrumSoundEvents.NEW_RECIPE, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.days_of_sealing_before_opened", (Object[])new Object[]{barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                    break;
                }
                case TAPPED: {
                    if (player.method_5715()) {
                        Optional recipe = world.method_8433().method_8132(SpectrumRecipeTypes.TITRATION_BARREL, (class_1263)barrelEntity.inventory, world);
                        if (recipe.isPresent()) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.days_of_sealing_after_opened_with_extractable_amount", (Object[])new Object[]{((ITitrationBarrelRecipe)recipe.get()).method_8110().method_7964().getString(), barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                            break;
                        }
                        player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.titration_barrel.invalid_recipe_after_opened", (Object[])new Object[]{barrelEntity.getSealMinecraftDays(), barrelEntity.getSealRealDays()}), true);
                        break;
                    }
                    class_1799 harvestedStack = barrelEntity.tryHarvest(world, pos, state, player.method_5998(hand), player);
                    if (harvestedStack.method_7960()) break;
                    player.method_31548().method_7398(harvestedStack);
                    world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
        }
        return class_1269.field_21466;
    }

    private void tryExtractLastStack(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, TitrationBarrelBlockEntity barrelEntity) {
        Optional<class_1799> stack = InventoryHelper.extractLastStack((class_1263)barrelEntity.inventory);
        if (stack.isPresent()) {
            player.method_31548().method_7398(stack.get());
            barrelEntity.method_5431();
            if (barrelEntity.inventory.method_5442() && barrelEntity.getFluidVariant().isBlank()) {
                world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.EMPTY)));
            } else {
                world.method_8455(pos, (class_2248)this);
            }
            world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private void sealBarrel(class_1937 world, class_2338 pos, class_2680 state, TitrationBarrelBlockEntity barrelEntity, class_1657 player) {
        barrelEntity.giveRecipeRemainders(player);
        world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.SEALED)));
        barrelEntity.seal();
        world.method_8396(null, pos, class_3417.field_17603, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void unsealBarrel(class_1937 world, class_2338 pos, class_2680 state, TitrationBarrelBlockEntity barrelEntity) {
        world.method_8501(pos, (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)BarrelState.TAPPED)));
        barrelEntity.tap();
        world.method_8396(null, pos, class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
        class_2487 nbt = ctx.method_8041().method_7941("BlockEntityTag");
        if (nbt != null) {
            long tapTime;
            boolean inventoryEmpty = nbt.method_10554("Inventory", 10).isEmpty();
            long fluidAmount = nbt.method_10537("FluidAmount");
            long sealTime = nbt.method_10573("SealTime", 4) ? nbt.method_10537("SealTime") : -1L;
            long l = tapTime = nbt.method_10573("TapTime", 4) ? nbt.method_10537("TapTime") : -1L;
            BarrelState barrelState = tapTime > -1L ? BarrelState.TAPPED : (sealTime > -1L ? BarrelState.SEALED : (inventoryEmpty && fluidAmount == 0L ? BarrelState.EMPTY : BarrelState.FILLED));
            state = (class_2680)state.method_11657(BARREL_STATE, (Comparable)((Object)barrelState));
        }
        return state;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, BARREL_STATE});
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity blockEntity = (TitrationBarrelBlockEntity)class_25862;
            switch ((BarrelState)((Object)state.method_11654(BARREL_STATE))) {
                case EMPTY: {
                    return 0;
                }
                case FILLED: {
                    int isNotEmpty = blockEntity.inventory.method_5442() ? 0 : 1;
                    float icurr = InventoryHelper.countItemsInInventory((class_1263)blockEntity.inventory);
                    float imax = 64.0f;
                    float fcurr = blockEntity.fluidStorage.amount;
                    float fmax = blockEntity.fluidStorage.getCapacity();
                    return class_3532.method_15375((float)((icurr / imax + fcurr / fmax) / 2.0f * 14.0f)) + isNotEmpty;
                }
                case SEALED: {
                    return 15;
                }
                case TAPPED: {
                    class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
                    Optional<ITitrationBarrelRecipe> recipe = blockEntity.getRecipeForInventory(world);
                    if (recipe.isEmpty()) {
                        return 0;
                    }
                    float curr = blockEntity.extractedBottles;
                    float max = recipe.get().getOutputCountAfterAngelsShare(biome.method_8712(), blockEntity.getSealSeconds());
                    return class_3532.method_15375((float)((1.0f - curr / max) * 15.0f));
                }
            }
        }
        return 0;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_27852((class_2248)this) && state.method_11654(BARREL_STATE) == BarrelState.FILLED) {
            TitrationBarrelBlock.scatterContents(world, pos);
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public static void scatterContents(@NotNull class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof TitrationBarrelBlockEntity) {
            TitrationBarrelBlockEntity titrationBarrelBlockEntity = (TitrationBarrelBlockEntity)blockEntity;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)titrationBarrelBlockEntity.getInventory());
        }
    }

    static enum BarrelState implements class_3542
    {
        EMPTY,
        FILLED,
        SEALED,
        TAPPED;


        public String method_15434() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

