/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.titration_barrel;

import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlock;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.Date;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlockEntity
extends class_2586 {
    protected static final int INVENTORY_SIZE = 5;
    public static final int MAX_ITEM_COUNT = 64;
    protected class_1277 inventory = new class_1277(5);
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            TitrationBarrelBlockEntity.this.method_5431();
        }
    };
    protected long sealTime = -1L;
    protected long tapTime = -1L;
    protected String recipe;
    protected int extractedBottles = 0;

    public TitrationBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.TITRATION_BARREL, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660());
        nbt.method_10566("FluidVariant", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
        nbt.method_10544("FluidAmount", this.fluidStorage.amount);
        nbt.method_10544("SealTime", this.sealTime);
        nbt.method_10544("TapTime", this.tapTime);
        nbt.method_10569("ExtractedBottles", this.extractedBottles);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = new class_1277(5);
        if (nbt.method_10573("Inventory", 9)) {
            this.inventory.method_7659(nbt.method_10554("Inventory", 10));
        }
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("FluidVariant"));
        this.fluidStorage.amount = nbt.method_10537("FluidAmount");
        this.sealTime = nbt.method_10573("SealTime", 4) ? nbt.method_10537("SealTime") : -1L;
        this.tapTime = nbt.method_10573("TapTime", 4) ? nbt.method_10537("TapTime") : -1L;
        this.extractedBottles = nbt.method_10573("ExtractedBottles", 99) ? nbt.method_10550("ExtractedBottles") : 0;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public void seal() {
        this.sealTime = new Date().getTime();
        this.method_5431();
    }

    public void tap() {
        this.tapTime = new Date().getTime();
        this.method_5431();
    }

    public void reset(class_1937 world, class_2338 blockPos, class_2680 state) {
        this.sealTime = -1L;
        this.tapTime = -1L;
        this.fluidStorage.variant = FluidVariant.blank();
        this.fluidStorage.amount = 0L;
        this.extractedBottles = 0;
        this.inventory.method_5448();
        world.method_8501(this.field_11867, (class_2680)state.method_11657(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.EMPTY)));
        world.method_8396(null, blockPos, class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
        this.method_5431();
    }

    public long getSealMilliseconds() {
        if (this.sealTime == -1L) {
            return 0L;
        }
        long tapTime = this.tapTime == -1L ? new Date().getTime() : this.tapTime;
        return tapTime - this.sealTime;
    }

    public long getSealSeconds() {
        return this.getSealMilliseconds() / 1000L;
    }

    public int getSealMinecraftDays() {
        return (int)(this.getSealMilliseconds() / 1000L / 60L / 20L);
    }

    public String getSealRealDays() {
        return Support.getWithOneDecimalAfterComma((float)this.getSealMilliseconds() / 1000.0f / 60.0f / 20.0f / 72.0f);
    }

    private boolean isEmpty(float temperature, int extractedBottles, ITitrationBarrelRecipe recipe) {
        if (recipe.method_31584() || !this.getFluidVariant().isOf((Object)recipe.getFluidInput())) {
            return true;
        }
        return extractedBottles >= recipe.getOutputCountAfterAngelsShare(temperature, this.getSealSeconds());
    }

    public void addDayOfSealTime() {
        this.sealTime -= 86400000L;
        this.method_5431();
    }

    public class_1799 tryHarvest(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1799 handStack, @Nullable class_1657 player) {
        class_1799 harvestedStack = class_1799.field_8037;
        class_1959 biome = (class_1959)world.method_23753(blockPos).comp_349();
        boolean shouldReset = false;
        class_5250 message = null;
        int daysSealed = this.getSealMinecraftDays();
        int inventoryCount = InventoryHelper.countItemsInInventory((class_1263)this.inventory);
        Optional<ITitrationBarrelRecipe> optionalRecipe = this.getRecipeForInventory(world);
        if (optionalRecipe.isEmpty()) {
            message = this.inventory.method_5442() && this.getFluidVariant().isBlank() ? class_2561.method_43471((String)"block.spectrum.titration_barrel.empty_when_tapping") : class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping");
            shouldReset = true;
        } else {
            ITitrationBarrelRecipe recipe = optionalRecipe.get();
            if (this.getFluidVariant().isOf((Object)recipe.getFluidInput())) {
                if (recipe.canPlayerCraft(player)) {
                    boolean canTap = true;
                    class_1792 tappingItem = recipe.getTappingItem();
                    if (tappingItem != class_1802.field_8162) {
                        if (handStack.method_31574(tappingItem)) {
                            handStack.method_7934(1);
                        } else {
                            message = class_2561.method_43471((String)"block.spectrum.titration_barrel.tapping_item_required").method_10852(tappingItem.method_7848());
                            canTap = false;
                        }
                    }
                    if (canTap) {
                        long secondsFermented = (this.tapTime - this.sealTime) / 1000L;
                        harvestedStack = recipe.tap((class_1263)this.inventory, secondsFermented, biome.method_8715());
                        ++this.extractedBottles;
                        shouldReset = this.isEmpty(biome.method_8712(), this.extractedBottles, recipe);
                    }
                } else {
                    message = class_2561.method_43471((String)"block.spectrum.titration_barrel.recipe_not_unlocked");
                }
            } else {
                message = this.getFluidVariant().isBlank() ? class_2561.method_43471((String)"block.spectrum.titration_barrel.missing_liquid_when_tapping") : class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping");
                shouldReset = true;
            }
        }
        if (player != null) {
            SpectrumAdvancementCriteria.TITRATION_BARREL_TAPPING.trigger((class_3222)player, harvestedStack, daysSealed, inventoryCount);
            if (message != null) {
                player.method_7353((class_2561)message, true);
            }
        }
        if (shouldReset) {
            this.reset(world, blockPos, blockState);
        }
        this.method_5431();
        return harvestedStack;
    }

    public Optional<ITitrationBarrelRecipe> getRecipeForInventory(class_1937 world) {
        return world.method_8433().method_8132(SpectrumRecipeTypes.TITRATION_BARREL, (class_1263)this.inventory, world);
    }

    public void giveRecipeRemainders(class_1657 player) {
        for (class_1799 stack : this.inventory.field_5828) {
            class_1799 remainder = stack.getRecipeRemainder();
            if (remainder.method_7960()) continue;
            player.method_31548().method_7398(remainder);
        }
    }

    @NotNull
    public FluidVariant getFluidVariant() {
        if (this.fluidStorage.amount > 0L) {
            return (FluidVariant)this.fluidStorage.variant;
        }
        return FluidVariant.blank();
    }

    public boolean canBeSealed(class_1657 player) {
        int itemCount = InventoryHelper.countItemsInInventory((class_1263)this.inventory);
        class_3611 fluid = ((FluidVariant)this.fluidStorage.variant).getFluid();
        if (itemCount == 0 && fluid == class_3612.field_15906) {
            return true;
        }
        if (this.field_11863 != null) {
            Optional<ITitrationBarrelRecipe> optionalRecipe = this.getRecipeForInventory(this.field_11863);
            return optionalRecipe.isPresent() && optionalRecipe.get().canPlayerCraft(player) && this.getFluidVariant().getFluid() == optionalRecipe.get().getFluidInput();
        }
        return false;
    }
}

