/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.cca.azure_dike;

import de.dafuqs.spectrum.cca.azure_dike.AzureDikeComponent;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.entity.PlayerCopyCallback;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class DefaultAzureDikeComponent
implements AzureDikeComponent,
AutoSyncedComponent,
PlayerCopyCallback {
    public static final int BASE_RECHARGE_RATE_DELAY_TICKS_DEFAULT = 40;
    public static final int BASE_RECHARGE_RATE_DELAY_TICKS_AFTER_DAMAGE = 200;
    private final class_1309 provider;
    private int protection = 0;
    private int currentRechargeDelay = 0;
    private int maxProtection = 0;
    private int rechargeDelayDefault = 0;
    private int rechargeDelayTicksAfterDamage = 0;

    public DefaultAzureDikeComponent(class_1309 entity) {
        this.provider = entity;
    }

    @Override
    public int getProtection() {
        return this.protection;
    }

    @Override
    public int getMaxProtection() {
        return this.maxProtection;
    }

    @Override
    public int getRechargeDelayDefault() {
        return this.rechargeDelayDefault;
    }

    @Override
    public int getCurrentRechargeDelay() {
        return this.currentRechargeDelay;
    }

    @Override
    public int getRechargeDelayTicksAfterDamage() {
        return this.rechargeDelayTicksAfterDamage;
    }

    @Override
    public float absorbDamage(float incomingDamage) {
        this.currentRechargeDelay = this.rechargeDelayTicksAfterDamage;
        if (this.protection > 0) {
            int usedProtection = Math.min(this.protection, (int)incomingDamage);
            this.protection -= usedProtection;
            if (usedProtection > 0) {
                AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
                class_1309 class_13092 = this.provider;
                if (class_13092 instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)class_13092;
                    SpectrumAdvancementCriteria.AZURE_DIKE_CHARGE.trigger(serverPlayerEntity, this.protection, this.rechargeDelayDefault, -usedProtection);
                }
            }
            return incomingDamage - (float)usedProtection;
        }
        return incomingDamage;
    }

    @Override
    public void set(int maxProtection, int rechargeDelayDefault, int fasterRechargeAfterDamageTicks, boolean resetCharge) {
        this.maxProtection = maxProtection;
        this.rechargeDelayDefault = rechargeDelayDefault;
        this.rechargeDelayTicksAfterDamage = fasterRechargeAfterDamageTicks;
        this.currentRechargeDelay = this.rechargeDelayDefault;
        this.protection = resetCharge ? 0 : Math.min(this.protection, this.maxProtection);
        AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
    }

    public void readFromNbt(class_2487 tag) {
        this.protection = tag.method_10550("protection");
        this.currentRechargeDelay = tag.method_10550("current_recharge_delay");
        this.maxProtection = tag.method_10550("max_protection");
        this.rechargeDelayDefault = tag.method_10550("recharge_delay_default");
        this.rechargeDelayTicksAfterDamage = tag.method_10550("recharge_delay_after_damage");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("protection", this.protection);
        tag.method_10569("current_recharge_delay", this.currentRechargeDelay);
        tag.method_10569("max_protection", this.maxProtection);
        tag.method_10569("recharge_delay_default", this.rechargeDelayDefault);
        tag.method_10569("recharge_delay_after_damage", this.rechargeDelayTicksAfterDamage);
    }

    public void serverTick() {
        if (this.currentRechargeDelay > 0) {
            --this.currentRechargeDelay;
        } else if (this.protection < this.maxProtection) {
            ++this.protection;
            this.currentRechargeDelay = this.rechargeDelayDefault;
            AzureDikeProvider.AZURE_DIKE_COMPONENT.sync((Object)this.provider);
            class_1309 class_13092 = this.provider;
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)class_13092;
                SpectrumAdvancementCriteria.AZURE_DIKE_CHARGE.trigger(serverPlayerEntity, this.protection, this.rechargeDelayDefault, 1);
            }
        }
    }

    public void copyData(@NotNull class_3222 original, @NotNull class_3222 clone, boolean lossless) {
        AzureDikeComponent o = (AzureDikeComponent)AzureDikeProvider.AZURE_DIKE_COMPONENT.get((Object)original);
        AzureDikeComponent c = (AzureDikeComponent)AzureDikeProvider.AZURE_DIKE_COMPONENT.get((Object)clone);
        c.set(o.getMaxProtection(), o.getRechargeDelayDefault(), o.getRechargeDelayTicksAfterDamage(), lossless);
    }
}

