/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.dafuqs.revelationary.RevelationRegistry;
import de.dafuqs.revelationary.advancement_criteria.AdvancementCountCriterion;
import de.dafuqs.revelationary.advancement_criteria.AdvancementGottenCriterion;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.PlaceableItemBlock;
import de.dafuqs.spectrum.blocks.enchanter.ExtendedEnchantable;
import de.dafuqs.spectrum.blocks.gemstone.SpectrumBuddingBlock;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.mixin.accessors.LootTableAccessor;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.mininglevel.v1.FabricMineableTags;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class SanityCommand {
    private static final List<class_2960> ADVANCEMENT_GATING_WARNING_WHITELIST = List.of(SpectrumCommon.locate("find_preservation_ruins"), SpectrumCommon.locate("fail_to_glitch_into_preservation_ruin"), SpectrumCommon.locate("midgame/craft_blacklisted_memory_success"), SpectrumCommon.locate("lategame/collect_myceylon"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spectrum_sanity").requires(source -> source.method_9259(2))).executes(context -> SanityCommand.execute((class_2168)context.getSource(), "spectrum"))).then(class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).executes(context -> SanityCommand.execute((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"mod_id")))));
    }

    private static int execute(class_2168 source, String modId) {
        class_1887 enchantment;
        class_1799 output;
        class_5321 registryKey;
        SpectrumCommon.logInfo("##### SANITY CHECK START ######");
        for (Map.Entry entry : class_2378.field_11146.method_29722()) {
            class_2680 blockState;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (blockState = ((class_2248)entry.getValue()).method_9564()).method_26204().method_36555() <= 0.0f || blockState.method_26164(class_3481.field_33715) || blockState.method_26164(class_3481.field_33713) || blockState.method_26164(class_3481.field_33716) || blockState.method_26164(class_3481.field_33714) || blockState.method_26164(FabricMineableTags.SHEARS_MINEABLE) || blockState.method_26164(FabricMineableTags.SWORD_MINEABLE) || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK)) continue;
            SpectrumCommon.logWarning("[SANITY: Mineable Tags] Block " + registryKey.method_29177() + " is not contained in a any vanilla mineable tag.");
        }
        for (Map.Entry entry : class_2378.field_11146.method_29722()) {
            class_2248 block;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals(modId) || (block = (class_2248)entry.getValue()) instanceof PlaceableItemBlock || block instanceof SpectrumBuddingBlock) continue;
            class_2680 blockState = ((class_2248)entry.getValue()).method_9564();
            class_2960 lootTableID = block.method_26162();
            if (blockState.method_26204().method_36555() <= -1.0f || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK)) continue;
            if (lootTableID.equals((Object)class_39.field_844) || lootTableID.method_12832().equals("blocks/air")) {
                SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + registryKey.method_29177() + " has a non-existent loot table");
                continue;
            }
            class_52 lootTable = source.method_9225().method_8503().method_3857().method_367(lootTableID);
            class_55[] class_55Array = ((LootTableAccessor)lootTable).getPools();
            if (class_55Array.length != 0) continue;
            SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + registryKey.method_29177() + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap<BuiltinGemstoneColor, Integer> colorMap = new HashMap<BuiltinGemstoneColor, Integer>();
            for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
                colorMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put((Object)((Object)pedestalRecipeTier), colorMap);
        }
        MinecraftServer minecraftServer = source.method_9225().method_8503();
        class_1863 recipeManager = minecraftServer.method_3772();
        class_2989 advancementLoader = minecraftServer.method_3851();
        for (PedestalRecipe pedestalRecipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            if ((pedestalRecipe.getTier() == PedestalRecipeTier.BASIC || pedestalRecipe.getTier() == PedestalRecipeTier.SIMPLE) && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.BLACK, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalRecipe.method_8114() + "' of tier '" + pedestalRecipe.getTier() + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
            }
            if (pedestalRecipe.getTier() != PedestalRecipeTier.COMPLEX && pedestalRecipe.getPowderInputs().getOrDefault(BuiltinGemstoneColor.WHITE, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalRecipe.method_8114() + "' of tier '" + pedestalRecipe.getTier() + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry entry : pedestalRecipe.getPowderInputs().entrySet()) {
                ((HashMap)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).put((BuiltinGemstoneColor)entry.getKey(), (Integer)((HashMap)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).get(entry.getKey()) + (Integer)entry.getValue());
            }
        }
        for (Map.Entry item : class_2378.field_11142.method_29722()) {
            if (class_2477.method_10517().method_4678(((class_1792)item.getValue()).method_7876())) continue;
            SpectrumCommon.logWarning("[SANITY: Item Lang] Missing translation string " + ((class_1792)item.getValue()).method_7876());
        }
        for (Iterator block : class_2378.field_11146.method_29722()) {
            if (class_2477.method_10517().method_4678(((class_2248)block.getValue()).method_9539())) continue;
            SpectrumCommon.logWarning("[SANITY: Block Lang] Missing translation string " + ((class_2248)block.getValue()).method_9539());
        }
        HashSet recipeGroups = new HashSet();
        recipeManager.method_8127().forEach(identifier -> {
            Object patt8662$temp;
            Optional recipe = recipeManager.method_8130(identifier);
            if (recipe.isPresent() && (patt8662$temp = recipe.get()) instanceof GatedSpectrumRecipe) {
                GatedSpectrumRecipe gatedSpectrumRecipe = (GatedSpectrumRecipe)patt8662$temp;
                String group = gatedSpectrumRecipe.method_8112();
                if (group == null) {
                    SpectrumCommon.logWarning("Recipe with null group found! :" + gatedSpectrumRecipe.method_8114());
                } else if (!group.isEmpty()) {
                    recipeGroups.add(group);
                }
            }
        });
        for (String recipeGroup : recipeGroups) {
            if (class_2477.method_10517().method_4678("recipeGroup.spectrum." + recipeGroup)) continue;
            SpectrumCommon.logWarning("[SANITY: Recipe Group Lang] Recipe group " + recipeGroup + " is not localized.");
        }
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.PEDESTAL, "Pedestal", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ANVIL_CRUSHING, "Anvil Crushing", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_BREWING, "Potion Workshop Brewing", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING, "Potion Workshop Reagent", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_REACTING, "Potion Workshop Crafting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING, "Midnight Solution Converting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.SPIRIT_INSTILLING, "Spirit Instilling", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.INK_CONVERTING, "Ink Converting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.CRYSTALLARIEUM, "Crystallarieum", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.CINDERHEARTH, "Cinderhearth", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.TITRATION_BARREL, "Titration Barrel", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, advancementLoader);
        for (Map.Entry cloaks : RevelationRegistry.getBlockStateEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)cloaks.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Block Cloaks] Advancement '" + ((class_2960)cloaks.getKey()).toString() + "' for block / item cloaking does not exist. Registered cloaks: " + ((List)cloaks.getValue()).size());
        }
        for (class_161 advancement : advancementLoader.method_12893()) {
            for (class_175 criterion : advancement.method_682().values()) {
                String[][] conditions = criterion.method_774();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    AdvancementGottenCriterion.Conditions hasAdvancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    class_2960 advancementIdentifier = hasAdvancementConditions.getAdvancementIdentifier();
                    class_161 advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier);
                    if (advancementCriterionAdvancement != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Has_Advancement Criteria] Advancement '" + advancement.method_688() + "' references advancement '" + (class_2960)advancementIdentifier + "' that does not exist");
                    continue;
                }
                if (!(conditions instanceof AdvancementCountCriterion.Conditions)) continue;
                AdvancementCountCriterion.Conditions hasAdvancementConditions = (AdvancementCountCriterion.Conditions)conditions;
                for (class_2960 advancementIdentifier : hasAdvancementConditions.getAdvancementIdentifiers()) {
                    class_161 advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier);
                    if (advancementCriterionAdvancement != null) continue;
                    SpectrumCommon.logWarning("[SANITY: Advancement_Count Criteria] Advancement '" + advancement.method_688() + "' references advancement '" + advancementIdentifier + "' that does not exist");
                }
            }
        }
        for (class_161 advancement : advancementLoader.method_12893()) {
            String string = advancement.method_688().method_12832();
            if (!advancement.method_688().method_12836().equals(modId) || string.startsWith("hidden") || string.startsWith("progression") || string.startsWith("milestones") || advancement.method_687() == null) continue;
            class_2960 previousAdvancementIdentifier = null;
            for (String[] requirement : advancement.method_680()) {
                if (requirement.length <= 0 || !requirement[0].equals("gotten_previous")) continue;
                class_184 conditions = ((class_175)advancement.method_682().get("gotten_previous")).method_774();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    AdvancementGottenCriterion.Conditions advancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    previousAdvancementIdentifier = advancementConditions.getAdvancementIdentifier();
                    break;
                }
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + advancement.method_688() + "' has a \"gotten_previous\" requirement, but its not revelationary:advancement_gotten");
            }
            if (ADVANCEMENT_GATING_WARNING_WHITELIST.contains(advancement.method_688())) continue;
            if (previousAdvancementIdentifier == null) {
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + advancement.method_688() + "' does not have its parent set as requirement");
                continue;
            }
            class_161 parent = advancement.method_687();
            if (parent.method_688().equals(previousAdvancementIdentifier) || parent.method_687() != null && parent.method_687().method_688().equals(previousAdvancementIdentifier)) continue;
            SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + advancement.method_688() + "' has its \"gotten_previous\" advancement set to something else than their parent. Intended?");
        }
        for (PedestalRecipe recipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            class_2960 class_29602 = recipe.method_8114();
            if (class_29602.method_12832().startsWith("mod_integration/") || class_29602.method_12832().contains("/glass/") || class_29602.method_12832().contains("/saplings/") || class_29602.method_12832().contains("/detectors/") || class_29602.method_12832().contains("/gem_lamps/") || class_29602.method_12832().contains("/decostones/") || class_29602.method_12832().contains("/runes/") || class_29602.method_12832().contains("/pastel_network/") || class_29602.method_12832().contains("/gemstone_chimes/") || class_29602.method_12832().contains("/pastel_network/") || class_29602.method_12832().contains("/player_only_glass/")) continue;
            if (recipe.getTier() == PedestalRecipeTier.BASIC && !class_29602.method_12832().contains("/tier1/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] BASIC recipe not in the correct tier folder: '" + class_29602 + "'");
                continue;
            }
            if (recipe.getTier() == PedestalRecipeTier.SIMPLE && !class_29602.method_12832().contains("/tier2/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] SIMPLE recipe not in the correct tier folder: '" + class_29602 + "'");
                continue;
            }
            if (recipe.getTier() == PedestalRecipeTier.ADVANCED && !class_29602.method_12832().contains("/tier3/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] ADVANCED recipe not in the correct tier folder: '" + class_29602 + "'");
                continue;
            }
            if (recipe.getTier() != PedestalRecipeTier.COMPLEX || class_29602.method_12832().contains("/tier4/")) continue;
            SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] COMPLEX recipe not in the correct tier folder: '" + class_29602 + "'");
        }
        for (AnvilCrushingRecipe anvilCrushingRecipe : recipeManager.method_30027(SpectrumRecipeTypes.ANVIL_CRUSHING)) {
            class_3414 class_34142 = anvilCrushingRecipe.getSoundEvent();
            if (class_34142 != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Crushing] Recipe '" + anvilCrushingRecipe.method_8114() + "' has a nonexistent sound set");
        }
        for (Map.Entry enchantment2 : class_2378.field_11160.method_29722()) {
            SpectrumEnchantment spectrumEnchantment;
            class_2960 advancementIdentifier;
            class_161 advancementCriterionAdvancement;
            Object previousAdvancementIdentifier = enchantment2.getValue();
            if (!(previousAdvancementIdentifier instanceof SpectrumEnchantment) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (spectrumEnchantment = (SpectrumEnchantment)((Object)previousAdvancementIdentifier)).getUnlockAdvancementIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantments] Enchantment '" + ((class_5321)enchantment2.getKey()).method_29177() + "' references advancement '" + advancementIdentifier + "' that does not exist");
        }
        for (Map.Entry item : class_2378.field_11142.method_29722()) {
            class_1792 class_17922 = (class_1792)item.getValue();
            if (!(class_17922 instanceof ExtendedEnchantable)) continue;
            if (!new class_1799((class_1935)class_17922).method_7923()) {
                SpectrumCommon.logWarning("[SANITY: Enchantability] Item '" + ((class_5321)item.getKey()).method_29177() + "' is not set to be enchantable.");
            }
            if (class_17922.method_7837() >= 1) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantability] Item '" + ((class_5321)item.getKey()).method_29177() + "' is ExtendedEnchantable, but has enchantability of < 1");
        }
        HashMap<class_1887, class_1767> craftingColors = new HashMap<class_1887, class_1767>();
        HashMap<class_1887, class_1767> upgradeColors = new HashMap<class_1887, class_1767>();
        for (EnchanterRecipe recipe : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTER)) {
            Map enchantments;
            output = recipe.method_8110();
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_8222((class_1799)output)).isEmpty()) continue;
            for (class_1856 ingredient : recipe.method_8117()) {
                for (class_1799 matchingStack : ingredient.method_8105()) {
                    class_1792 class_17923 = matchingStack.method_7909();
                    if (!(class_17923 instanceof PigmentItem)) continue;
                    PigmentItem pigmentItem = (PigmentItem)class_17923;
                    craftingColors.put((class_1887)enchantments.keySet().stream().toList().get(0), pigmentItem.getColor());
                }
            }
        }
        for (EnchantmentUpgradeRecipe recipe : recipeManager.method_30027(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE)) {
            class_1792 class_17924;
            Map enchantments;
            output = recipe.method_8110();
            if (output.method_7909() != class_1802.field_8598 || (enchantments = class_1890.method_8222((class_1799)output)).isEmpty() || !((class_17924 = recipe.getRequiredItem()) instanceof PigmentItem)) continue;
            PigmentItem pigmentItem = (PigmentItem)class_17924;
            upgradeColors.put((class_1887)enchantments.keySet().stream().toList().get(0), pigmentItem.getColor());
        }
        for (Map.Entry entry : class_2378.field_11160.method_29722()) {
            enchantment = (class_1887)entry.getValue();
            if (!craftingColors.containsKey(enchantment)) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + ((class_5321)entry.getKey()).method_29177() + "' does not have a crafting recipe");
            }
            if (!upgradeColors.containsKey(enchantment) && enchantment.method_8183() > 1) {
                SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment '" + ((class_5321)entry.getKey()).method_29177() + "' does not have a upgrading recipe");
            }
            if (!craftingColors.containsKey(enchantment) || !upgradeColors.containsKey(enchantment) || craftingColors.get(enchantment) == upgradeColors.get(enchantment)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Recipes] Enchantment recipes for '" + ((class_5321)entry.getKey()).method_29177() + "' use different pigments");
        }
        for (Map.Entry entry : class_2378.field_11160.method_29722()) {
            enchantment = (class_1887)entry.getValue();
            if (!((class_5321)entry.getKey()).method_29177().method_12836().equals(modId) || SpectrumEnchantmentTags.isIn(SpectrumEnchantmentTags.SPECTRUM_ENCHANTMENT, enchantment)) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantment Tags] Enchantment '" + ((class_5321)entry.getKey()).method_29177() + "' is missing in the spectrum:enchantments tag");
        }
        for (Map.Entry item : class_2378.field_11142.method_29722()) {
            SpectrumTrinketItem trinketItem;
            class_2960 advancementIdentifier;
            class_161 advancementCriterionAdvancement;
            Object enchantments = item.getValue();
            if (!(enchantments instanceof SpectrumTrinketItem) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (trinketItem = (SpectrumTrinketItem)((Object)enchantments)).getUnlockIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Trinkets] Trinket '" + ((class_5321)item.getKey()).method_29177() + "' references advancement '" + advancementIdentifier + "' that does not exist");
        }
        SpectrumCommon.logInfo("##### SANITY CHECK FINISHED ######");
        SpectrumCommon.logInfo("##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap entry = (HashMap)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            SpectrumCommon.logInfo("[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.CYAN)).toString(), (int)3) + " M:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.MAGENTA)).toString(), (int)3) + " Y:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.YELLOW)).toString(), (int)3) + " K:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.BLACK)).toString(), (int)3) + " W:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.WHITE)).toString(), (int)3));
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 class_32222 = (class_3222)class_12972;
            class_32222.method_7353((class_2561)class_2561.method_43471((String)"commands.spectrum.progression_sanity.success"), false);
        }
        return 0;
    }

    private static <R extends GatedRecipe> void testRecipeUnlocks(class_3956<R> recipeType, String name, class_1863 recipeManager, class_2989 advancementLoader) {
        for (GatedRecipe recipe : recipeManager.method_30027(recipeType)) {
            class_2960 advancementIdentifier = recipe.getRequiredAdvancementIdentifier();
            if (advancementIdentifier == null || advancementLoader.method_12896(advancementIdentifier) != null) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe Unlocks] Advancement '" + recipe.getRequiredAdvancementIdentifier() + "' in recipe '" + recipe.method_8114() + "' does not exist");
        }
    }

    private static <R extends GatedRecipe> void testIngredientsAndOutputInColorRegistry(class_3956<R> recipeType, String name, class_1863 recipeManager, class_2989 advancementLoader) {
        for (GatedRecipe recipe : recipeManager.method_30027(recipeType)) {
            for (class_1856 inputIngredient : recipe.method_8117()) {
                for (class_1799 matchingItemStack : inputIngredient.method_8105()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Input '" + class_2378.field_11142.method_10221((Object)matchingItemStack.method_7909()) + "' in recipe '" + recipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            class_1792 outputItem = recipe.method_8110().method_7909();
            if (outputItem == null || outputItem == class_1802.field_8162 || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Output '" + class_2378.field_11142.method_10221((Object)outputItem) + "' in recipe '" + recipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
        }
    }
}

