/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.compat.REI.plugins.EnchanterDisplay;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class EnchantmentUpgradeDisplay
extends EnchanterDisplay {
    protected final class_1887 enchantment;
    protected final int enchantmentDestinationLevel;
    protected final int requiredExperience;
    protected final int requiredItemCount;

    public EnchantmentUpgradeDisplay(@NotNull EnchantmentUpgradeRecipe recipe) {
        super(recipe, EnchantmentUpgradeDisplay.buildIngredients(recipe), recipe.method_8110());
        this.enchantment = recipe.getEnchantment();
        this.enchantmentDestinationLevel = recipe.getEnchantmentDestinationLevel();
        this.requiredItemCount = recipe.getRequiredItemCount();
        this.requiredExperience = recipe.getRequiredExperience();
    }

    private static List<EntryIngredient> buildIngredients(EnchantmentUpgradeRecipe recipe) {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        inputs.add(EntryIngredients.ofIngredient((class_1856)((class_1856)recipe.method_8117().get(0))));
        int requiredItemCountSplit = recipe.getRequiredItemCount() / 8;
        int requiredItemCountModulo = recipe.getRequiredItemCount() % 8;
        for (int i = 0; i < 8; ++i) {
            int addAmount = i < requiredItemCountModulo ? 1 : 0;
            inputs.add(EntryIngredients.of((class_1935)recipe.getRequiredItem(), (int)(requiredItemCountSplit + addAmount)));
        }
        inputs.add(EntryIngredients.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience(), true)));
        return inputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.ENCHANTMENT_UPGRADE;
    }

    @Override
    public boolean isUnlocked() {
        if (!AdvancementHelper.hasAdvancement((class_1657)class_310.method_1551().field_1724, (class_2960)EnchanterRecipe.UNLOCK_IDENTIFIER) || !super.isUnlocked()) {
            return false;
        }
        if (this.enchantmentDestinationLevel > this.enchantment.method_8183()) {
            return AdvancementHelper.hasAdvancement((class_1657)class_310.method_1551().field_1724, (class_2960)EnchanterBlockEntity.OVERENCHANTING_ADVANCEMENT_IDENTIFIER);
        }
        return true;
    }
}

