/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.ae2.AE2Compat;
import de.dafuqs.spectrum.compat.alloy_forgery.AlloyForgeryCompat;
import de.dafuqs.spectrum.compat.create.CreateCompat;
import de.dafuqs.spectrum.compat.gobber.GobberCompat;
import de.dafuqs.spectrum.compat.mythic_metals.MythicMetalsCompat;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class SpectrumIntegrationPacks {
    protected static final Map<String, ModIntegrationPack> INTEGRATION_PACKS = new HashMap<String, ModIntegrationPack>();

    protected static void registerIntegrationPack(String modId, ModIntegrationPack container) {
        if (!SpectrumCommon.CONFIG.IntegrationPacksToSkipLoading.contains(modId) && FabricLoader.getInstance().isModLoaded(modId)) {
            INTEGRATION_PACKS.put(modId, container);
        }
    }

    public static void register() {
        SpectrumIntegrationPacks.registerIntegrationPack("ae2", new AE2Compat());
        SpectrumIntegrationPacks.registerIntegrationPack("gobber2", new GobberCompat());
        SpectrumIntegrationPacks.registerIntegrationPack("create", new CreateCompat());
        SpectrumIntegrationPacks.registerIntegrationPack("mythicmetals", new MythicMetalsCompat());
        SpectrumIntegrationPacks.registerIntegrationPack("alloy_forgery", new AlloyForgeryCompat());
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.register();
        }
    }

    public static void registerClient() {
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.registerClient();
        }
    }

    public static void registerMultiblocks() {
        for (ModIntegrationPack container : INTEGRATION_PACKS.values()) {
            container.registerMultiblocks();
        }
    }

    public static boolean isIntegrationPackActive(String modId) {
        return INTEGRATION_PACKS.containsKey(modId);
    }

    public static abstract class ModIntegrationPack {
        public abstract void register();

        public abstract void registerClient();

        public void registerMultiblocks() {
        }
    }
}

