/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.compat.emi.SpectrumEmiRecipeCategories;
import de.dafuqs.spectrum.helpers.NullableDyeColor;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CrystallarieumEmiRecipeGated
extends GatedSpectrumEmiRecipe<CrystallarieumRecipe> {
    private static final class_2960 BACKGROUND_TEXTURE = SpectrumCommon.locate("textures/gui/patchouli/crystallarieum.png");

    public CrystallarieumEmiRecipeGated(CrystallarieumRecipe recipe) {
        super(SpectrumEmiRecipeCategories.CRYSTALLARIEUM, CrystallarieumRecipe.UNLOCK_IDENTIFIER, recipe, 124, 100);
        this.inputs = List.of(EmiIngredient.of((class_1856)recipe.getIngredientStack()), EmiStack.of((class_1935)recipe.getGrowthStages().get(0).method_26204()));
        this.outputs = Stream.concat(Stream.concat(Stream.of(recipe.method_8110()), recipe.getAdditionalOutputs().stream()).map(EmiStack::of), recipe.getGrowthStages().stream().map(s -> EmiStack.of((class_1935)s.method_26204())).filter(s -> !s.isEmpty())).toList();
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 8);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)SpectrumBlocks.CRYSTALLARIEUM.asStackWithColor(NullableDyeColor.get(((CrystallarieumRecipe)this.recipe).getInkColor().getDyeColor()))), 20, 18).drawBack(false);
        widgets.addFillingArrow(40, 9, ((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage() * 1000);
        List<EmiStack> states = ((CrystallarieumRecipe)this.recipe).getGrowthStages().stream().map(s -> EmiStack.of((class_1935)s.method_26204())).toList();
        Iterator<EmiStack> it = states.iterator();
        widgets.addSlot((EmiIngredient)it.next(), 20, 0);
        int x = 66;
        while (it.hasNext()) {
            widgets.addSlot((EmiIngredient)it.next(), x, 8).recipeContext((EmiRecipe)this);
            x += 20;
        }
        widgets.addText((class_2561)class_2561.method_43471((String)"container.spectrum.rei.crystallarieum.catalyst"), 0, 42, 0x3F3F3F, false);
        widgets.addText((class_2561)class_2561.method_43471((String)"container.spectrum.rei.crystallarieum.accelerator"), 0, 58, 0x3F3F3F, false);
        widgets.addText((class_2561)class_2561.method_43471((String)"container.spectrum.rei.crystallarieum.ink_consumption"), 0, 68, 0x3F3F3F, false);
        widgets.addText((class_2561)class_2561.method_43471((String)"container.spectrum.rei.crystallarieum.used_up"), 0, 78, 0x3F3F3F, false);
        List<CrystallarieumCatalyst> catalysts = ((CrystallarieumRecipe)this.recipe).getCatalysts();
        for (int i = 0; i < catalysts.size(); ++i) {
            CrystallarieumCatalyst catalyst = catalysts.get(i);
            int xOff = 46 + 18 * i;
            widgets.addSlot(EmiIngredient.of((class_1856)catalyst.ingredient), xOff, 38);
            float growthAcceleration = catalyst.growthAccelerationMod;
            int uOff = growthAcceleration == 1.0f ? 97 : (growthAcceleration >= 6.0f ? 85 : (growthAcceleration > 1.0f ? 67 : ((double)growthAcceleration <= 0.25 ? 79 : 73)));
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 59, 6, 6, uOff, 0, 6, 6, 128, 128);
            float inkConsumption = catalyst.inkConsumptionMod;
            uOff = inkConsumption == 1.0f ? 97 : (inkConsumption >= 8.0f ? 85 : (inkConsumption > 1.0f ? 67 : ((double)inkConsumption <= 0.25 ? 79 : 73)));
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 69, 6, 6, uOff, 6, 6, 6, 128, 128);
            float consumeChance = catalyst.consumeChancePerSecond;
            uOff = consumeChance == 0.0f ? 97 : ((double)consumeChance >= 0.2 ? 85 : ((double)consumeChance >= 0.05 ? 67 : 91));
            widgets.addTexture(BACKGROUND_TEXTURE, xOff + 5, 79, 6, 6, uOff, 6, 6, 6, 128, 128);
        }
        if (((CrystallarieumRecipe)this.recipe).growsWithoutCatalyst()) {
            widgets.addText((class_2561)class_2561.method_43469((String)"container.spectrum.rei.crystallarieum.crafting_time_per_stage_seconds", (Object[])new Object[]{((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage()}), 0, 90, 0x3F3F3F, false);
        } else {
            widgets.addText((class_2561)class_2561.method_43469((String)"container.spectrum.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_required", (Object[])new Object[]{((CrystallarieumRecipe)this.recipe).getSecondsPerGrowthStage()}), 0, 90, 0x3F3F3F, false);
        }
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }
}

