/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli.pages;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2287;
import net.minecraft.class_2378;
import net.minecraft.class_4587;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

public class PageCollection
extends PageWithText {
    private static final int ENTRIES_PER_ROW = 6;
    String title;
    IVariable items;
    transient List<class_1799> stacks;

    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.stacks = new ArrayList<class_1799>();
        for (IVariable item : this.items.asList()) {
            class_1799 stack;
            String stackString = item.asString();
            try {
                stack = new class_2287(new class_7157((class_5455)class_5455.method_40302((class_2378)class_2378.field_11144))).method_9778(new StringReader(stackString)).method_9781(1, false);
            }
            catch (CommandSyntaxException e) {
                PatchouliAPI.LOGGER.warn("Unable to parse stack {} in collection page", (Object)stackString);
                continue;
            }
            this.stacks.add(stack);
            entry.addRelevantStack(builder, stack, pageNum);
        }
    }

    public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
        boolean hasTitle;
        super.render(ms, mouseX, mouseY, pticks);
        boolean bl = hasTitle = this.title != null && !this.title.isEmpty();
        if (hasTitle) {
            this.parent.drawCenteredStringNoShadow(ms, this.i18n(this.title), 58, 0, this.book.headerColor);
            GuiBook.drawSeparator((class_4587)ms, (Book)this.book, (int)0, (int)12);
        }
        int startY = hasTitle ? 18 : 0;
        int row = 0;
        int column = -1;
        int firstNonFullRowIndex = this.stacks.size() / 6;
        int unusedEntriesInLastRow = 6 - this.stacks.size() % 6;
        for (class_1799 stack : this.stacks) {
            if (++column == 6) {
                column = 0;
                ++row;
            }
            int startX = 5 + column * 18;
            if (row == firstNonFullRowIndex) {
                startX += unusedEntriesInLastRow * 9;
            }
            this.parent.renderItemStack(ms, startX, startY + row * 18, mouseX, mouseY, stack);
        }
        if (!this.text.asString().isEmpty()) {
            GuiBook.drawSeparator((class_4587)ms, (Book)this.book, (int)0, (int)(startY + 20 + row * 18));
        }
        super.render(ms, mouseX, mouseY, pticks);
    }

    public int getTextHeight() {
        boolean hasTitle = this.title != null && !this.title.isEmpty();
        return 8 + (hasTitle ? 18 : 0) + (int)Math.ceil((float)this.stacks.size() / 6.0f) * 18;
    }
}

