/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli.pages;

import com.google.gson.annotations.SerializedName;
import de.dafuqs.spectrum.compat.patchouli.pages.GatedPatchouliPage;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public abstract class PageGatedRecipe<T extends GatedRecipe>
extends PageWithText
implements GatedPatchouliPage {
    private final class_3956<T> recipeType;
    @SerializedName(value="recipe")
    class_2960 recipeId;
    String title;
    protected transient T recipe;
    protected transient class_2561 titleText;

    public PageGatedRecipe(class_3956<T> recipeType) {
        this.recipeType = recipeType;
    }

    @Nullable
    private T getRecipe(class_2960 id) {
        if (class_310.method_1551().field_1687 == null) {
            return null;
        }
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        return (T)((GatedRecipe)manager.method_8130(id).filter(recipe -> recipe.method_17716() == this.recipeType).orElse(null));
    }

    protected T loadRecipe(BookContentsBuilder builder, BookEntry entry, class_2960 identifier) {
        if (identifier == null) {
            return null;
        }
        T recipe = this.getRecipe(identifier);
        if (recipe != null) {
            entry.addRelevantStack(builder, recipe.method_8110(), this.pageNum);
            return recipe;
        }
        PatchouliAPI.LOGGER.warn("Recipe {} (of type {}) not found", (Object)identifier, (Object)class_2378.field_17597.method_10221(this.recipeType));
        return null;
    }

    public boolean isPageUnlocked() {
        if (!super.isPageUnlocked() || this.recipe == null) {
            return false;
        }
        return this.recipe.canPlayerCraft((class_1657)class_310.method_1551().field_1724);
    }

    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.recipe = this.loadRecipe(builder, entry, this.recipeId);
        boolean customTitle = this.title != null && !this.title.isEmpty();
        this.titleText = !customTitle ? this.getRecipeOutput(this.recipe).method_7964() : this.i18nText(this.title);
        GatedPatchouliPage.runSanityCheck(entry.getId(), pageNum, this.advancement, new GatedRecipe[]{this.recipe});
    }

    public void render(class_4587 ms, int mouseX, int mouseY, float tickDelta) {
        if (this.recipe != null) {
            int recipeX = this.getX();
            int recipeY = this.getY();
            this.drawRecipe(ms, this.recipe, recipeX, recipeY, mouseX, mouseY);
        }
        super.render(ms, mouseX, mouseY, tickDelta);
    }

    public int getTextHeight() {
        return this.getY() + this.getRecipeHeight() - 13;
    }

    public boolean shouldRenderText() {
        return this.getTextHeight() + 10 < 156;
    }

    protected abstract void drawRecipe(class_4587 var1, T var2, int var3, int var4, int var5, int var6);

    protected abstract class_1799 getRecipeOutput(T var1);

    protected abstract int getRecipeHeight();

    protected int getX() {
        return 9;
    }

    protected int getY() {
        return 4;
    }

    protected class_2561 getTitle() {
        return this.titleText;
    }
}

