/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class CrystalApothecarySimulationsDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "crystal_apothecary_simulations";
    public static final CrystalApothecarySimulationsDataLoader INSTANCE = new CrystalApothecarySimulationsDataLoader();
    public static final HashMap<class_2248, SimulatedBlockGrowthEntry> COMPENSATIONS = new HashMap();

    private CrystalApothecarySimulationsDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        COMPENSATIONS.clear();
        prepared.forEach((identifier, jsonElement) -> {
            class_1799 compensatedStack;
            JsonObject object = jsonElement.getAsJsonObject();
            String buddingBlockString = class_3518.method_15265((JsonObject)object, (String)"budding_block");
            class_2248 buddingBlock = (class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)buddingBlockString));
            if (buddingBlock == class_2246.field_10124) {
                SpectrumCommon.logError("Crystal Apothecary Simulation '" + identifier + "' has a non-existant 'budding_block' entry: '" + buddingBlockString + "'. Ignoring that one.");
                return;
            }
            HashSet<class_2248> validNeighbors = new HashSet<class_2248>();
            for (JsonElement entry : object.get("valid_neighbor_blocks").getAsJsonArray()) {
                class_2960 validNeighborBlockId = class_2960.method_12829((String)entry.getAsString());
                class_2248 validNeighborBlock = (class_2248)class_2378.field_11146.method_10223(validNeighborBlockId);
                if (validNeighborBlock == class_2246.field_10124 && !validNeighborBlockId.equals((Object)new class_2960("air"))) {
                    SpectrumCommon.logError("Crystal Apothecary Simulation '" + identifier + "' has a non-existant 'valid_neighbor_block' entry: '" + validNeighborBlockId + "'. Ignoring that one.");
                    continue;
                }
                validNeighbors.add(validNeighborBlock);
            }
            int ticksForCompensationLootPerValidNeighbor = class_3518.method_15282((JsonObject)object, (String)"ticks_for_compensation_loot_per_valid_neighbor", (int)10000);
            try {
                compensatedStack = RecipeUtils.itemStackWithNbtFromJson(object.get("compensated_loot").getAsJsonObject());
            }
            catch (JsonSyntaxException e) {
                SpectrumCommon.logError("Crystal Apothecary Simulation '" + identifier + "' has an invalid 'compensated_loot' tag, perhaps with a non-existing item. Ignoring that one.");
                return;
            }
            COMPENSATIONS.put(buddingBlock, new SimulatedBlockGrowthEntry(validNeighbors, ticksForCompensationLootPerValidNeighbor, compensatedStack));
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public record SimulatedBlockGrowthEntry(Collection<class_2248> validNeighbors, int ticksForCompensationLootPerValidNeighbor, class_1799 compensatedStack) {
    }
}

