/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.enchantments.resonance_processors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.dafuqs.spectrum.enchantments.resonance_processors.ResonanceDropProcessor;
import de.dafuqs.spectrum.predicate.block.BrokenBlockPredicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ModifyDropsResonanceProcessor
extends ResonanceDropProcessor {
    public Map<class_1856, class_1792> modifiedDrops;

    public ModifyDropsResonanceProcessor(BrokenBlockPredicate blockTarget, Map<class_1856, class_1792> modifiedDrops) throws Exception {
        super(blockTarget);
        this.modifiedDrops = modifiedDrops;
    }

    @Override
    public boolean process(class_2680 state, class_2586 blockEntity, List<class_1799> droppedStacks) {
        if (this.blockPredicate.test(state)) {
            this.modifyDrops(droppedStacks);
            return true;
        }
        return false;
    }

    private void modifyDrops(List<class_1799> droppedStacks) {
        block0: for (class_1799 stack : droppedStacks) {
            for (Map.Entry<class_1856, class_1792> modifiedDrop : this.modifiedDrops.entrySet()) {
                if (!modifiedDrop.getKey().method_8093(stack)) continue;
                class_1799 convertedStack = modifiedDrop.getValue().method_7854();
                convertedStack.method_7939(stack.method_7947());
                droppedStacks.remove(stack);
                droppedStacks.add(convertedStack);
                continue block0;
            }
        }
    }

    public static class Serializer
    implements ResonanceDropProcessor.Serializer {
        @Override
        public ResonanceDropProcessor fromJson(JsonObject json) throws Exception {
            BrokenBlockPredicate blockTarget = BrokenBlockPredicate.fromJson(json.get("block"));
            HashMap<class_1856, class_1792> modifiedDrops = new HashMap<class_1856, class_1792>();
            JsonArray modifyDropsArray = class_3518.method_15261((JsonObject)json, (String)"modify_drops");
            for (JsonElement entry : modifyDropsArray) {
                if (!(entry instanceof JsonObject)) {
                    throw new JsonSyntaxException("modify_drops is not an json object");
                }
                JsonObject entryObject = (JsonObject)entry;
                class_1856 ingredient = class_1856.method_8102((JsonElement)entryObject.get("input"));
                class_1792 output = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)entryObject, (String)"output")));
                modifiedDrops.put(ingredient, output);
            }
            return new ModifyDropsResonanceProcessor(blockTarget, modifiedDrops);
        }
    }
}

