/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy;

import de.dafuqs.spectrum.energy.color.InkColor;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public interface InkStorage {
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination) {
        long transferred = 0L;
        for (InkColor inkColor : source.getEnergy().keySet()) {
            transferred += InkStorage.transferInk(source, destination, inkColor);
        }
        return transferred;
    }

    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color) {
        long destinationAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && sourceAmount > (destinationAmount = destination.getEnergy(color)) + 1L) {
            long transferAmount = Math.max(1L, (sourceAmount - destinationAmount) / 32L);
            transferAmount = Math.min(transferAmount, Math.min(sourceAmount, destinationRoom));
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    @Deprecated
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color, long amount) {
        long transferAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && (transferAmount = Math.min(amount, Math.min(sourceAmount, destinationRoom))) > 0L) {
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    public boolean accepts(InkColor var1);

    public long addEnergy(InkColor var1, long var2);

    public long drainEnergy(InkColor var1, long var2);

    public boolean requestEnergy(InkColor var1, long var2);

    public long getEnergy(InkColor var1);

    @Deprecated
    public Map<InkColor, Long> getEnergy();

    @Deprecated
    public void setEnergy(Map<InkColor, Long> var1, long var2);

    public long getMaxPerColor();

    public long getMaxTotal();

    public long getCurrentTotal();

    public boolean isEmpty();

    public boolean isFull();

    public void fillCompletely();

    public void clear();

    public void addTooltip(List<class_2561> var1, boolean var2);

    public long getRoom(InkColor var1);
}

