/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy;

import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.InkColor;
import org.jetbrains.annotations.NotNull;

public interface InkStorageBlockEntity<PStorage extends InkStorage> {
    public PStorage getEnergyStorage();

    default public float drainInkForUpgrades(@NotNull Upgradeable upgradeable, @NotNull Upgradeable.UpgradeType upgradeType, @NotNull InkColor color, boolean useEfficiency) {
        long inkToDrain;
        Upgradeable.UpgradeHolder upgradeHolder = upgradeable.getUpgradeHolder();
        if (upgradeHolder.getRawValue(upgradeType) == 0) {
            return 1.0f;
        }
        long l = inkToDrain = useEfficiency ? upgradeHolder.getEffectiveCostUsingEfficiency(upgradeType) : upgradeHolder.getEffectiveCost(upgradeType);
        if (this.getEnergyStorage().drainEnergy(color, inkToDrain) == inkToDrain) {
            this.setInkDirty();
            return upgradeHolder.getEffectiveValue(upgradeType);
        }
        this.setInkDirty();
        return 1.0f;
    }

    default public boolean drainInkForUpgradesRequired(@NotNull Upgradeable upgradeable, @NotNull Upgradeable.UpgradeType upgradeType, @NotNull InkColor color, boolean useEfficiency) {
        long inkToDrain;
        Upgradeable.UpgradeHolder upgradeHolder = upgradeable.getUpgradeHolder();
        long l = inkToDrain = useEfficiency ? upgradeHolder.getEffectiveCostUsingEfficiency(upgradeType) : upgradeHolder.getEffectiveCost(upgradeType);
        if (this.getEnergyStorage().drainEnergy(color, inkToDrain) == inkToDrain) {
            this.setInkDirty();
            return true;
        }
        this.setInkDirty();
        return false;
    }

    default public boolean drainInkForUpgradesRequired(@NotNull Upgradeable upgradeable, @NotNull InkColor color, long amount, boolean useEfficiency) {
        long inkToDrain;
        long l = inkToDrain = useEfficiency ? upgradeable.getUpgradeHolder().getEffectiveCostUsingEfficiency(amount) : amount;
        if (this.getEnergyStorage().drainEnergy(color, inkToDrain) == inkToDrain) {
            this.setInkDirty();
            return true;
        }
        this.setInkDirty();
        return false;
    }

    public void setInkDirty();

    public boolean getInkDirty();
}

