/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.color.ElementalColor;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.energy.storage.TotalCappedElementalInkStorage;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndividualAndTotalCappedElementalInkStorage
extends TotalCappedElementalInkStorage {
    protected final long maxEnergyPerColor;

    public IndividualAndTotalCappedElementalInkStorage(long maxEnergyTotal, long maxEnergyPerColor) {
        super(maxEnergyTotal);
        this.maxEnergyPerColor = maxEnergyPerColor;
    }

    public IndividualAndTotalCappedElementalInkStorage(long maxEnergyTotal, long maxEnergyPerColor, long cyan, long magenta, long yellow, long black, long white) {
        super(maxEnergyTotal, cyan, magenta, yellow, black, white);
        this.maxEnergyPerColor = maxEnergyPerColor;
    }

    @Nullable
    public static IndividualAndTotalCappedElementalInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            long maxEnergyPerColor = compound.method_10537("MaxEnergyPerColor");
            long cyan = compound.method_10537("Cyan");
            long magenta = compound.method_10537("Magenta");
            long yellow = compound.method_10537("Yellow");
            long black = compound.method_10537("Black");
            long white = compound.method_10537("White");
            return new IndividualAndTotalCappedElementalInkStorage(maxEnergyTotal, maxEnergyPerColor, cyan, magenta, yellow, black, white);
        }
        return null;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        if (color instanceof ElementalColor) {
            ElementalColor elementalColor = (ElementalColor)color;
            long freeTotalEnergy = this.maxEnergyTotal - this.currentTotal;
            long currentAmount = (Long)this.storedEnergy.get(color);
            long freeColorEnergy = this.maxEnergyPerColor - currentAmount;
            long free = Math.min(freeTotalEnergy, freeColorEnergy);
            if (amount > free) {
                this.storedEnergy.put(elementalColor, currentAmount + free);
                return amount - free;
            }
            this.storedEnergy.put(elementalColor, currentAmount + amount);
            return 0L;
        }
        return amount;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyPerColor;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10544("MaxEnergyTotal", this.maxEnergyTotal);
        compound.method_10544("MaxEnergyPerColor", this.maxEnergyPerColor);
        compound.method_10544("Cyan", ((Long)this.storedEnergy.get(InkColors.CYAN)).longValue());
        compound.method_10544("Magenta", ((Long)this.storedEnergy.get(InkColors.MAGENTA)).longValue());
        compound.method_10544("Yellow", ((Long)this.storedEnergy.get(InkColors.YELLOW)).longValue());
        compound.method_10544("Black", ((Long)this.storedEnergy.get(InkColors.BLACK)).longValue());
        compound.method_10544("White", ((Long)this.storedEnergy.get(InkColors.WHITE)).longValue());
        return compound;
    }
}

