/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.Support;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndividualCappedInkStorage
implements InkStorage {
    protected final long maxEnergyPerColor;
    protected final Map<InkColor, Long> storedEnergy;
    protected long currentTotal;

    public IndividualCappedInkStorage(long maxEnergyPerColor) {
        this(maxEnergyPerColor, new HashSet<InkColor>(InkColor.all()));
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Set<InkColor> supportedColors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.currentTotal = 0L;
        this.storedEnergy = new HashMap<InkColor, Long>();
        for (InkColor color : supportedColors) {
            this.storedEnergy.put(color, 0L);
        }
    }

    public IndividualCappedInkStorage(long maxEnergyPerColor, Map<InkColor, Long> colors) {
        this.maxEnergyPerColor = maxEnergyPerColor;
        this.storedEnergy = colors;
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            this.storedEnergy.put(color.getKey(), color.getValue());
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Nullable
    public static IndividualCappedInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyPerColor", 4)) {
            long maxEnergyPerColor = compound.method_10537("MaxEnergyPerColor");
            HashMap<InkColor, Long> colors = new HashMap<InkColor, Long>();
            for (InkColor color : InkColor.all()) {
                if (!compound.method_10545(color.toString())) continue;
                colors.put(color, compound.method_10537(color.toString()));
            }
            return new IndividualCappedInkStorage(maxEnergyPerColor, colors);
        }
        return null;
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedEnergy.containsKey(color);
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long resultingAmount = this.storedEnergy.get(color) + amount;
        if (resultingAmount > this.maxEnergyPerColor) {
            long overflow = resultingAmount - this.maxEnergyPerColor;
            this.currentTotal = this.maxEnergyPerColor;
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            return overflow;
        }
        this.currentTotal += amount;
        this.storedEnergy.put(color, resultingAmount);
        return 0L;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.getOrDefault(color, 0L);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyPerColor * (long)this.storedEnergy.size();
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyPerColor;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.getMaxTotal();
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10544("MaxEnergyPerColor", this.maxEnergyPerColor);
        for (Map.Entry<InkColor, Long> color : this.storedEnergy.entrySet()) {
            compound.method_10544(color.getKey().toString(), color.getValue().longValue());
        }
        return compound;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip, boolean includeHeader) {
        if (includeHeader) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.pigment_palette.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyPerColor)}));
        }
        for (Map.Entry<InkColor, Long> color : this.storedEnergy.entrySet()) {
            if (color.getValue() <= 0L) continue;
            tooltip.add((class_2561)class_2561.method_43469((String)("spectrum.tooltip.ink_powered.bullet." + color.getKey().toString().toLowerCase(Locale.ROOT)), (Object[])new Object[]{Support.getShortenedNumberString(color.getValue())}));
        }
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyPerColor - this.storedEnergy.get(color);
    }

    @Override
    public void fillCompletely() {
        this.currentTotal = 0L;
        for (InkColor color : this.storedEnergy.keySet()) {
            this.storedEnergy.put(color, this.maxEnergyPerColor);
            this.currentTotal += this.maxEnergyPerColor;
        }
    }

    @Override
    public void clear() {
        this.storedEnergy.replaceAll((c, v) -> 0L);
    }

    public Set<InkColor> getSupportedColors() {
        return this.storedEnergy.keySet();
    }
}

