/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigmentPaletteInkStorage
extends IndividualCappedInkStorage {
    public PigmentPaletteInkStorage(long maxEnergyPerColor) {
        super(maxEnergyPerColor);
    }

    public PigmentPaletteInkStorage(long maxEnergyPerColor, Map<InkColor, Long> colors) {
        super(maxEnergyPerColor, colors);
    }

    @Nullable
    public static PigmentPaletteInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyPerColor", 4)) {
            long maxEnergyPerColor = compound.method_10537("MaxEnergyPerColor");
            HashMap<InkColor, Long> colors = new HashMap<InkColor, Long>();
            for (InkColor color : InkColor.all()) {
                colors.put(color, compound.method_10537(color.toString()));
            }
            return new PigmentPaletteInkStorage(maxEnergyPerColor, colors);
        }
        return null;
    }

    public long addEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        long leftoverEnergy = super.addEnergy(color, amount);
        if (leftoverEnergy != amount) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, amount - leftoverEnergy);
        }
        return leftoverEnergy;
    }

    public boolean requestEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        boolean success = super.requestEnergy(color, amount);
        if (success) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, -amount);
        }
        return success;
    }

    public long drainEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        long drainedAmount = super.drainEnergy(color, amount);
        if (drainedAmount != 0L) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, -drainedAmount);
        }
        return drainedAmount;
    }
}

