/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.CompoundColor;
import de.dafuqs.spectrum.energy.color.ElementalColor;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.Support;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotalCappedElementalInkStorage
implements InkStorage {
    protected final long maxEnergyTotal;
    protected final Map<ElementalColor, Long> storedEnergy = new HashMap<ElementalColor, Long>();
    protected long currentTotal;

    public TotalCappedElementalInkStorage(long maxEnergyTotal) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.currentTotal = 0L;
        for (ElementalColor color : InkColor.elementals()) {
            this.storedEnergy.put(color, 0L);
        }
    }

    public TotalCappedElementalInkStorage(long maxEnergyTotal, long cyan, long magenta, long yellow, long black, long white) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.currentTotal = cyan + magenta + yellow + black + white;
        this.storedEnergy.put(InkColors.CYAN, cyan);
        this.storedEnergy.put(InkColors.MAGENTA, magenta);
        this.storedEnergy.put(InkColors.YELLOW, yellow);
        this.storedEnergy.put(InkColors.BLACK, black);
        this.storedEnergy.put(InkColors.WHITE, white);
    }

    @Nullable
    public static TotalCappedElementalInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            long cyan = compound.method_10537("Cyan");
            long magenta = compound.method_10537("Magenta");
            long yellow = compound.method_10537("Yellow");
            long black = compound.method_10537("Black");
            long white = compound.method_10537("White");
            return new TotalCappedElementalInkStorage(maxEnergyTotal, cyan, magenta, yellow, black, white);
        }
        return null;
    }

    @Override
    public boolean accepts(InkColor color) {
        return color instanceof ElementalColor;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        if (color instanceof ElementalColor) {
            ElementalColor elementalColor = (ElementalColor)color;
            long currentAmount = this.storedEnergy.get(color);
            if (amount > this.maxEnergyTotal - this.currentTotal) {
                long resultingAmount = currentAmount + amount;
                long overflow = resultingAmount - this.maxEnergyTotal + this.currentTotal;
                this.currentTotal += resultingAmount - this.maxEnergyTotal;
                this.storedEnergy.put(elementalColor, this.maxEnergyTotal);
                return overflow;
            }
            this.currentTotal += amount;
            this.storedEnergy.put(elementalColor, currentAmount + amount);
            return 0L;
        }
        return amount;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        if (color instanceof ElementalColor) {
            ElementalColor elementalColor = (ElementalColor)color;
            long storedAmount = this.storedEnergy.get(elementalColor);
            if (storedAmount < amount) {
                return false;
            }
            this.currentTotal -= amount;
            this.storedEnergy.put(elementalColor, storedAmount - amount);
            return true;
        }
        if (color instanceof CompoundColor) {
            long requiredAmount;
            long storedAmount;
            CompoundColor compoundColor = (CompoundColor)color;
            Map<ElementalColor, Float> requiredElementals = compoundColor.getElementalColorsToMix();
            for (Map.Entry<ElementalColor, Float> entry : requiredElementals.entrySet()) {
                storedAmount = this.storedEnergy.get(entry.getKey());
                if (storedAmount >= (requiredAmount = (long)((int)Math.ceil(entry.getValue().floatValue() * (float)amount)))) continue;
                return false;
            }
            for (Map.Entry<ElementalColor, Float> entry : requiredElementals.entrySet()) {
                storedAmount = this.storedEnergy.get(entry.getKey());
                requiredAmount = (int)Math.ceil(entry.getValue().floatValue() * (float)amount);
                this.currentTotal -= requiredAmount;
                this.storedEnergy.put(entry.getKey(), storedAmount - requiredAmount);
            }
            return true;
        }
        return false;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        if (color instanceof ElementalColor) {
            ElementalColor elementalColor = (ElementalColor)color;
            long storedAmount = this.storedEnergy.get(elementalColor);
            long drainedAmount = Math.min(storedAmount, amount);
            this.storedEnergy.put(elementalColor, storedAmount - drainedAmount);
            this.currentTotal -= drainedAmount;
            return drainedAmount;
        }
        if (color instanceof CompoundColor) {
            long storedAmount;
            CompoundColor compoundColor = (CompoundColor)color;
            Map<ElementalColor, Float> requiredElementals = compoundColor.getElementalColorsToMix();
            float percentageAbleToDrain = 1.0f;
            for (Map.Entry<ElementalColor, Float> entry : requiredElementals.entrySet()) {
                long requiredAmount;
                storedAmount = this.storedEnergy.get(entry.getKey());
                if (storedAmount >= (requiredAmount = (long)((int)Math.ceil(entry.getValue().floatValue() * (float)amount)))) continue;
                percentageAbleToDrain = Math.min(percentageAbleToDrain, (float)storedAmount / (float)requiredAmount);
            }
            for (Map.Entry<ElementalColor, Float> entry : requiredElementals.entrySet()) {
                storedAmount = this.storedEnergy.get(entry.getKey());
                long drainedAmount = (int)Math.ceil(entry.getValue().floatValue() * (float)amount * percentageAbleToDrain);
                this.storedEnergy.put(entry.getKey(), storedAmount - drainedAmount);
            }
            long drainedAmount = (int)Math.floor(percentageAbleToDrain * (float)amount);
            this.currentTotal -= drainedAmount;
            return drainedAmount;
        }
        return 0L;
    }

    @Override
    public long getEnergy(InkColor color) {
        if (color instanceof ElementalColor) {
            ElementalColor elementalColor = (ElementalColor)color;
            return this.storedEnergy.get(elementalColor);
        }
        if (color instanceof CompoundColor) {
            CompoundColor compoundColor = (CompoundColor)color;
            long maxAmount = Long.MAX_VALUE;
            Map<ElementalColor, Float> requiredElementals = compoundColor.getElementalColorsToMix();
            for (Map.Entry<ElementalColor, Float> entry : requiredElementals.entrySet()) {
                long mixedAmount = (long)Math.floor(entry.getValue().floatValue() * (float)this.storedEnergy.get(entry.getKey()).longValue());
                maxAmount = Math.min(maxAmount, mixedAmount);
            }
            return maxAmount;
        }
        return 0L;
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return new HashMap<InkColor, Long>(this.storedEnergy);
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            if (!(color instanceof ElementalColor)) continue;
            ElementalColor elementalColor = (ElementalColor)((Object)color);
            this.storedEnergy.put(elementalColor, color.getValue());
        }
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.maxEnergyTotal;
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10544("MaxEnergyTotal", this.maxEnergyTotal);
        compound.method_10544("Cyan", this.storedEnergy.get(InkColors.CYAN).longValue());
        compound.method_10544("Magenta", this.storedEnergy.get(InkColors.MAGENTA).longValue());
        compound.method_10544("Yellow", this.storedEnergy.get(InkColors.YELLOW).longValue());
        compound.method_10544("Black", this.storedEnergy.get(InkColors.BLACK).longValue());
        compound.method_10544("White", this.storedEnergy.get(InkColors.WHITE).longValue());
        return compound;
    }

    @Override
    public void fillCompletely() {
        long energyPerColor = this.maxEnergyTotal / (long)this.storedEnergy.size();
        this.storedEnergy.replaceAll((c, v) -> energyPerColor);
        this.currentTotal += (long)this.storedEnergy.size() * energyPerColor;
    }

    @Override
    public void clear() {
        this.storedEnergy.replaceAll((c, v) -> 0L);
    }

    @Override
    public long getRoom(InkColor color) {
        if (color instanceof ElementalColor) {
            return this.maxEnergyTotal - this.currentTotal;
        }
        return 0L;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip, boolean includeHeader) {
        long white;
        long black;
        long yellow;
        long magenta;
        long cyan;
        if (includeHeader) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.artists_palette.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyTotal)}));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.artists_palette.tooltip.mix_on_demand"));
        }
        if ((cyan = this.storedEnergy.get(InkColors.CYAN).longValue()) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet.cyan", (Object[])new Object[]{Support.getShortenedNumberString(cyan)}));
        }
        if ((magenta = this.storedEnergy.get(InkColors.MAGENTA).longValue()) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet.magenta", (Object[])new Object[]{Support.getShortenedNumberString(magenta)}));
        }
        if ((yellow = this.storedEnergy.get(InkColors.YELLOW).longValue()) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet.yellow", (Object[])new Object[]{Support.getShortenedNumberString(yellow)}));
        }
        if ((black = this.storedEnergy.get(InkColors.BLACK).longValue()) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet.black", (Object[])new Object[]{Support.getShortenedNumberString(black)}));
        }
        if ((white = this.storedEnergy.get(InkColors.WHITE).longValue()) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_powered.bullet.white", (Object[])new Object[]{Support.getShortenedNumberString(white)}));
        }
    }
}

