/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.entity.entity.LizardEntity;
import de.dafuqs.spectrum.entity.entity.PackEntity;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class EraserEntity
extends class_1628
implements PackEntity<EraserEntity>,
class_5761 {
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(EraserEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_1293 effectOnHit;
    @Nullable
    private EraserEntity leader;
    private int groupSize = 1;

    public EraserEntity(class_1299<? extends EraserEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createEraserAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23717, 28.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, LizardEntity.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(3, (class_1352)new class_1371((class_1308)this));
        this.field_6201.method_6277(4, new PackEntity.FollowClanLeaderGoal<EraserEntity>(this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public boolean method_6049(class_1293 effect) {
        return super.method_6049(effect) && effect.method_5579() != SpectrumStatusEffects.DEADLY_POISON;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_5819 random = world.method_8409();
        this.effectOnHit = this.getRandomOnHitEffect();
        if (entityData == null) {
            entityData = new SwarmingSpiderData();
            ((SwarmingSpiderData)((Object)entityData)).method_7168(random);
        }
        if (entityData instanceof SwarmingSpiderData) {
            SwarmingSpiderData swarmingSpiderData = (SwarmingSpiderData)((Object)entityData);
            class_1291 statusEffect = swarmingSpiderData.effect;
            if (statusEffect != null) {
                this.method_6092(swarmingSpiderData.getEffectInstance());
            }
        }
        return entityData;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_6121(class_1297 target) {
        if (super.method_6121(target)) {
            if (this.effectOnHit != null && target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                livingTarget.method_37222(this.effectOnHit, (class_1297)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    @Override
    @Nullable
    public EraserEntity getLeader() {
        return this.leader;
    }

    @Override
    public boolean isCloseEnoughToLeader() {
        return this.method_5858((class_1297)this.leader) <= 121.0;
    }

    @Override
    public void leaveGroup() {
        if (this.leader != null) {
            this.leader.decreaseGroupSize();
            this.leader = null;
        }
    }

    @Override
    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.method_5942().method_6335((class_1297)this.leader, 1.0);
        }
    }

    @Override
    public int getMaxGroupSize() {
        return super.method_5945();
    }

    @Override
    public void joinGroupOf(EraserEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    protected void increaseGroupSize() {
        ++this.groupSize;
    }

    protected void decreaseGroupSize() {
        --this.groupSize;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("FromBucket", this.method_6453());
        this.putEffectOnHit(nbt);
    }

    private void putEffectOnHit(class_2487 nbt) {
        if (this.effectOnHit != null) {
            class_2487 effectNbt = new class_2487();
            this.effectOnHit.method_5582(effectNbt);
            nbt.method_10566("EffectOnHit", (class_2520)effectNbt);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_6454(nbt.method_10577("FromBucket"));
        this.readEffectOnHit(nbt);
    }

    private void readEffectOnHit(class_2487 nbt) {
        if (nbt.method_10573("EffectOnHit", 10)) {
            this.effectOnHit = class_1293.method_5583((class_2487)nbt.method_10562("EffectOnHit"));
        }
    }

    public class_1293 getRandomOnHitEffect() {
        class_1291 statusEffect;
        class_1267 difficulty = this.field_6002.method_8407();
        int amplifier = 0;
        switch (this.field_6002.field_9229.method_43048(8)) {
            case 1: {
                statusEffect = SpectrumStatusEffects.STIFFNESS;
                amplifier = this.field_5974.method_43048(2);
                break;
            }
            case 2: {
                statusEffect = SpectrumStatusEffects.FRENZY;
                amplifier = this.field_5974.method_43048(2);
                break;
            }
            case 3: {
                statusEffect = SpectrumStatusEffects.SCARRED;
                break;
            }
            case 4: {
                statusEffect = SpectrumStatusEffects.VULNERABILITY;
                amplifier = this.field_5974.method_43048(2);
                break;
            }
            default: {
                statusEffect = SpectrumStatusEffects.DEADLY_POISON;
                amplifier = this.field_5974.method_43048(2);
            }
        }
        int duration = 120 * difficulty.method_5461();
        return new class_1293(statusEffect, duration, amplifier);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.2f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return EraserEntity.tryBucket(player, hand, this).orElse(super.method_5992(player, hand));
    }

    static <T extends class_1309> Optional<class_1269> tryBucket(class_1657 player, class_1268 hand, T entity) {
        class_1799 handStack = player.method_5998(hand);
        if (handStack.method_7909() == class_1802.field_8550 && entity.method_5805()) {
            entity.method_5783(((class_5761)entity).method_35171(), 1.0f, 1.0f);
            class_1799 bucketedStack = ((class_5761)entity).method_6452();
            ((class_5761)entity).method_6455(bucketedStack);
            class_1799 exchangedStack = class_5328.method_30270((class_1799)handStack, (class_1657)player, (class_1799)bucketedStack, (boolean)false);
            player.method_6122(hand, exchangedStack);
            class_1937 world = entity.field_6002;
            if (!world.field_9236) {
                class_174.field_1208.method_8932((class_3222)player, bucketedStack);
            }
            entity.method_31472();
            return Optional.of(class_1269.method_29236((boolean)world.field_9236));
        }
        return Optional.empty();
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_6453() && !this.method_16914();
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_2487 nbtCompound = stack.method_7948();
        this.putEffectOnHit(nbtCompound);
    }

    public void method_35170(class_2487 nbt) {
        class_5761.method_35168((class_1308)this, (class_2487)nbt);
        this.readEffectOnHit(nbt);
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)SpectrumItems.BUCKET_OF_ERASER);
    }

    public class_3414 method_35171() {
        return class_3417.field_15126;
    }

    public static class SwarmingSpiderData
    extends class_1628.class_1630 {
        public class_1291 effect;
        public int amplifier = 0;

        public void method_7168(class_5819 random) {
            switch (random.method_43048(5)) {
                case 0: {
                    this.effect = class_1294.field_5904;
                    this.amplifier = random.method_43048(2);
                    break;
                }
                case 1: {
                    this.effect = class_1294.field_5910;
                    this.amplifier = random.method_43048(2);
                    break;
                }
                case 2: {
                    this.effect = class_1294.field_5924;
                    this.amplifier = random.method_43048(2);
                    break;
                }
                case 3: {
                    this.effect = class_1294.field_5905;
                    break;
                }
                default: {
                    this.effect = SpectrumStatusEffects.MAGIC_ANNULATION;
                    this.amplifier = 5;
                }
            }
        }

        public class_1293 getEffectInstance() {
            return new class_1293(this.effect, Integer.MAX_VALUE, this.amplifier);
        }
    }
}

