/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.blocks.gravity.FloatBlock;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import net.id.incubus_core.blocklikeentities.api.BlockLikeEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2346;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;

public class FloatBlockEntity
extends BlockLikeEntity {
    private static final float MAX_DAMAGE = 8.0f;
    private static final float DAMAGE_PER_FALLEN_BLOCK = 0.5f;
    private static final class_2940<Float> GRAVITY_MODIFIER = class_2945.method_12791(FloatBlockEntity.class, (class_2941)class_2943.field_13320);

    public FloatBlockEntity(class_1299<? extends FloatBlockEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FloatBlockEntity(class_1937 world, double x, double y, double z, class_2680 blockState) {
        super(SpectrumEntityTypes.FLOAT_BLOCK, world, x, y, z, blockState);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof FloatBlock) {
            FloatBlock floatBlock = (FloatBlock)class_22482;
            this.setGravity(floatBlock.getGravityMod());
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GRAVITY_MODIFIER, (Object)Float.valueOf(0.0f));
    }

    public float getGravity() {
        return ((Float)this.field_6011.method_12789(GRAVITY_MODIFIER)).floatValue();
    }

    protected void setGravity(float modifier) {
        this.field_6011.method_12778(GRAVITY_MODIFIER, (Object)Float.valueOf(modifier));
    }

    public boolean method_5740() {
        return (double)this.getGravity() == 0.0 || super.method_5740();
    }

    public void postTickMoveEntities() {
        if (class_2346.method_10128((class_2680)this.blockState)) {
            return;
        }
        for (class_1297 entity : this.field_6002.method_8335((class_1297)this, this.method_5829().method_989(0.0, 0.5, 0.0).method_991(this.method_5829().method_989(3.0 * (this.field_6014 - this.method_23317()), 3.0 * (this.field_6036 - this.method_23318()), 3.0 * (this.field_5969 - this.method_23321()))))) {
            BlockLikeEntity other;
            if (entity instanceof BlockLikeEntity && this.isPaltaeriaStratineCollision(other = (BlockLikeEntity)entity)) {
                this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, class_1927.class_4179.field_18685);
                class_1799 collisionStack = SpectrumBlocks.HOVER_BLOCK.method_8389().method_7854();
                class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), collisionStack);
                itemEntity.method_5762(0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2, 0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2, 0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2);
                this.field_6002.method_8649((class_1297)itemEntity);
                this.method_31472();
                other.method_31472();
                continue;
            }
            if (!entity.method_5810()) continue;
            entity.method_5784(class_1313.field_6306, this.method_18798());
            entity.method_24830(true);
            entity.method_5762(this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350);
            entity.field_6017 = 0.0f;
            this.postTickEntityCollision(entity);
        }
    }

    public void postTickMovement() {
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1021(0.98));
            double additionalYVelocity = this.field_6012 > 100 ? (double)(this.getGravity() / 10.0f) : Math.min(Math.sin(Math.PI * (double)this.field_6012 / 100.0), 1.0) * (double)(this.getGravity() / 10.0f);
            this.method_5762(0.0, additionalYVelocity, 0.0);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        if (movementType != class_1313.field_6308) {
            this.method_18799(movement);
        }
    }

    public boolean shouldCease() {
        return this.field_5992 || super.shouldCease();
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 damageSource) {
        int damage;
        int traveledDistance;
        if (!this.field_6002.field_9236 && (traveledDistance = class_3532.method_15386((float)(distance - 1.0f))) > 0 && (damage = (int)Math.min((float)class_3532.method_15375((float)((float)traveledDistance * 0.5f)), 8.0f)) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_6002.method_8335((class_1297)this, this.method_5829().method_1009(0.0, 3.0 * Math.signum(this.method_18798().field_1351), 0.0).method_1009(0.0, -0.5 * Math.signum(this.method_18798().field_1351), 0.0)));
            for (class_1297 entity : list) {
                entity.method_5643(SpectrumDamageSources.FLOATBLOCK, (float)damage);
            }
        }
        return false;
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("GravityModifier", this.getGravity());
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("GravityModifier", 5)) {
            this.setGravity(compound.method_10583("GravityModifier"));
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            if (this.field_6002.field_9236) {
                return class_1269.field_5812;
            }
            class_1792 item = this.blockState.method_26204().method_8389();
            if (item != null) {
                player.method_31548().method_7398(item.method_7854());
            }
            this.method_31472();
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public class_1799 method_31480() {
        return this.blockState.method_26204().method_8389().method_7854();
    }

    public boolean isPaltaeriaStratineCollision(BlockLikeEntity other) {
        class_2248 thisBlock = this.blockState.method_26204();
        class_2248 otherBlock = other.getBlockState().method_26204();
        return thisBlock == SpectrumBlocks.PALTAERIA_FRAGMENT_BLOCK && otherBlock == SpectrumBlocks.STRATINE_FRAGMENT_BLOCK || thisBlock == SpectrumBlocks.STRATINE_FRAGMENT_BLOCK && otherBlock == SpectrumBlocks.PALTAERIA_FRAGMENT_BLOCK;
    }

    public boolean method_30949(class_1297 other) {
        return other.method_30948() && !this.method_5794(other);
    }
}

