/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.entity.ai.EmptyBodyControl;
import de.dafuqs.spectrum.entity.entity.LightMineEntity;
import de.dafuqs.spectrum.entity.entity.LightShardBaseEntity;
import de.dafuqs.spectrum.entity.entity.LightShardEntity;
import de.dafuqs.spectrum.entity.entity.LightSpearEntity;
import de.dafuqs.spectrum.entity.entity.SpectrumBossEntity;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.sound.MonstrositySoundInstance;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1330;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1395;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class MonstrosityEntity
extends SpectrumBossEntity
implements class_1603 {
    public static final UUID BONUS_DAMAGE_UUID = UUID.fromString("4425979b-f987-4937-875a-1e26d727c67f");
    @Nullable
    public static MonstrosityEntity theOneAndOnly = null;
    public static final class_2960 KILLED_MONSTROSITY_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("lategame/killed_monstrosity");
    public static final Predicate<class_1309> ENTITY_TARGETS = entity -> {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_7325() || player.method_7337()) {
                return false;
            }
            return !AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)KILLED_MONSTROSITY_ADVANCEMENT_IDENTIFIER);
        }
        return false;
    };
    private final class_4051 TARGET_PREDICATE = class_4051.method_36625().method_18420(ENTITY_TARGETS);
    private static final float MAX_LIFE_LOST_PER_TICK = 20.0f;
    private static final int GROW_STRONGER_EVERY_X_TICKS = 400;
    private class_243 targetPosition = class_243.field_1353;
    private MovementType movementType = MovementType.SWOOPING_TO_POSITION;
    private float previousHealth;
    private int timesGottenStronger = 0;
    private int ticksWithoutTarget = 0;

    public MonstrosityEntity(class_1299<? extends MonstrosityEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new MonstrosityMoveControl((class_1308)this);
        this.field_6194 = 500;
        this.field_5960 = true;
        this.field_5985 = true;
        this.previousHealth = this.method_6032();
        if (!(world.field_9236 || theOneAndOnly != null && !theOneAndOnly.method_31481() && theOneAndOnly.method_5805())) {
            theOneAndOnly = this;
        } else {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void method_5990() {
        super.method_5990();
    }

    public void method_36209() {
        if (theOneAndOnly == this) {
            theOneAndOnly = null;
        }
        super.method_36209();
    }

    protected class_1330 method_5963() {
        return new EmptyBodyControl((class_1308)this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new StartSwoopAttackGoal());
        this.field_6201.method_6277(2, (class_1352)new SwoopMovementGoal());
        this.field_6201.method_6277(3, (class_1352)new RetreatAndAttackGoal(40.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1381((class_1603)this, 1.0, 40, 28.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 0, false, false, ENTITY_TARGETS));
        this.field_6185.method_6277(2, (class_1352)new FindTargetGoal());
    }

    @Override
    protected void method_5958() {
        float currentHealth = this.method_6032();
        if (currentHealth < this.previousHealth - 20.0f) {
            this.method_6033(this.previousHealth - 20.0f);
        }
        this.previousHealth = currentHealth;
        this.tickInvincibility();
        if (!this.field_6002.field_9236 && this.field_6012 % 400 == 0) {
            this.growStronger(1);
        }
        super.method_5958();
        if (this.field_6012 % 10 == 0) {
            this.method_6025(1.0f);
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() || this.method_5787()) {
            float f = 0.91f;
            float g = 0.16277137f / (f * f * f);
            this.method_5724(this.field_5952 ? 0.1f * g : 0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)f));
        }
        this.method_29242((class_1309)this, false);
    }

    public boolean method_6101() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            if (this.field_6012 == 0) {
                MonstrositySoundInstance.startSoundInstance(this);
            }
        } else {
            this.method_5982();
        }
        if (this.hasInvincibilityTicks()) {
            for (int j = 0; j < 3; ++j) {
                this.field_6002.method_8406((class_2394)class_2398.field_11226, this.method_23317() + this.field_5974.method_43059(), this.method_23318() + (double)(this.field_5974.method_43057() * 3.3f), this.method_23321() + this.field_5974.method_43059(), 0.7, 0.7, 0.7);
            }
        }
    }

    @Override
    public void method_5982() {
        super.method_5982();
        if (this.hasValidTarget()) {
            this.ticksWithoutTarget = 0;
        } else {
            ++this.ticksWithoutTarget;
            if (this.ticksWithoutTarget > 600) {
                this.method_5966();
                this.method_31472();
            }
        }
    }

    public boolean hasValidTarget() {
        class_1309 target = this.method_5968();
        return target != null && this.method_18391(target, this.TARGET_PREDICATE);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (spawnReason == class_3730.field_16459 && theOneAndOnly != null && theOneAndOnly != this) {
            this.method_31472();
        }
        this.targetPosition = this.method_19538();
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6332(true);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public void growStronger(int amount) {
        this.timesGottenStronger += amount;
        Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        class_1322 jeopardantModifier = new class_1322(BONUS_DAMAGE_UUID, "spectrum:monstrosity_bonus", 1.0 + (double)this.timesGottenStronger * 0.1, class_1322.class_1323.field_6331);
        map.put((Object)class_5134.field_23721, (Object)jeopardantModifier);
        this.method_6127().method_26854(map);
        this.method_5783(SpectrumSoundEvents.ENTITY_MONSTROSITY_GROWL, 1.0f, 1.0f);
        float i = 0.0f;
        while ((double)i <= 1.0) {
            SpectrumS2CPacketSender.playParticleWithPatternAndVelocity(null, (class_3218)this.field_6002, new class_243(this.method_23317(), this.method_23323(i), this.method_23321()), (class_2394)SpectrumParticleTypes.WHITE_SPARKLE_RISING, VectorPattern.SIXTEEN, 0.05f);
            i = (float)((double)i + 0.2);
        }
    }

    public static class_5132 createMonstrosityAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 600.0).method_26868(class_5134.field_23721, 24.0).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23724, 18.0).method_26868(class_5134.field_23725, 4.0).method_26868(class_5134.field_23722, 2.0).method_26868(AdditionalEntityAttributes.MAGIC_PROTECTION, 4.0).method_26866();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.field_6002.field_9236 && this.isNonVanillaKillCommandDamage(source, amount)) {
            this.method_6033(this.method_6032() + this.method_6063() / 2.0f);
            this.growStronger(8);
            this.method_5783(this.method_6011(class_1282.field_5849), 2.0f, 1.5f);
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_6057(class_1297 entity) {
        if (entity.field_6002 != this.field_6002) {
            return false;
        }
        return entity.method_19538().method_1022(this.method_19538()) < 128.0;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43470((String)"\u00a7kLivingNightmare");
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.field_6002.field_9229.method_43056()) {
            LightShardBaseEntity.summonBarrageInternal(this.field_6002, (class_1309)this, () -> {
                LightSpearEntity entity = new LightSpearEntity(this.field_6002, (class_1309)this, Optional.of(target), 6.0f, 800);
                entity.setTargetPredicate(ENTITY_TARGETS);
                return entity;
            }, this.method_33571(), (class_6017)class_6019.method_35017((int)5, (int)7));
        } else {
            LightShardBaseEntity.summonBarrageInternal(this.field_6002, (class_1309)this, () -> {
                LightMineEntity entity = new LightMineEntity(this.field_6002, (class_1309)this, Optional.empty(), 4.0f, 8.0f, 800.0f);
                entity.setEffects(List.of(this.getRandomMineStatusEffect(this.field_5974)));
                entity.setTargetPredicate(ENTITY_TARGETS);
                return entity;
            }, this.method_33571(), (class_6017)class_6019.method_35017((int)7, (int)11));
        }
        this.method_5783(SpectrumSoundEvents.ENTITY_MONSTROSITY_SHOOT, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
    }

    protected class_1293 getRandomMineStatusEffect(class_5819 random) {
        int i = random.method_43054();
        switch (i) {
            case 0: {
                return new class_1293(SpectrumStatusEffects.SCARRED, 200, 0);
            }
            case 1: {
                return new class_1293(SpectrumStatusEffects.STIFFNESS, 200, 1);
            }
            case 2: {
                return new class_1293(SpectrumStatusEffects.DENSITY, 200, 2);
            }
            case 3: {
                return new class_1293(SpectrumStatusEffects.VULNERABILITY, 200, 1);
            }
        }
        return new class_1293(SpectrumStatusEffects.LIFE_DRAIN, 200, 0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("previous_health", this.previousHealth);
        nbt.method_10569("times_gotten_stronger", this.timesGottenStronger);
        nbt.method_10569("ticks_without_target", this.ticksWithoutTarget);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("previous_health", 5)) {
            this.previousHealth = nbt.method_10583("previous_health");
        }
        if (nbt.method_10573("times_gotten_stronger", 99)) {
            this.timesGottenStronger = nbt.method_10550("times_gotten_stronger");
        }
        if (nbt.method_10573("ticks_without_target", 99)) {
            this.ticksWithoutTarget = nbt.method_10550("ticks_without_target");
        }
    }

    private static enum MovementType {
        SWOOPING_TO_POSITION,
        START_SWOOPING,
        RETREATING;

    }

    private class MonstrosityMoveControl
    extends class_1335 {
        private float targetSpeed;

        public MonstrosityMoveControl(class_1308 owner) {
            super(owner);
            this.targetSpeed = 0.1f;
        }

        public void method_6240() {
            if (MonstrosityEntity.this.field_5976) {
                MonstrosityEntity.this.method_36456(MonstrosityEntity.this.method_36454() + 180.0f);
                this.targetSpeed = 0.1f;
            }
            double d = MonstrosityEntity.this.targetPosition.field_1352 - MonstrosityEntity.this.method_23317();
            double e = MonstrosityEntity.this.targetPosition.field_1351 - MonstrosityEntity.this.method_23318();
            double f = MonstrosityEntity.this.targetPosition.field_1350 - MonstrosityEntity.this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            if (Math.abs(g) > 1.0E-5) {
                double h = 1.0 - Math.abs(e * 0.7) / g;
                g = Math.sqrt((d *= h) * d + (f *= h) * f);
                double i = Math.sqrt(d * d + f * f + e * e);
                float j = MonstrosityEntity.this.method_36454();
                float k = (float)class_3532.method_15349((double)f, (double)d);
                float l = class_3532.method_15393((float)(MonstrosityEntity.this.method_36454() + 90.0f));
                float m = class_3532.method_15393((float)(k * 57.295776f));
                MonstrosityEntity.this.method_36456(class_3532.method_15388((float)l, (float)m, (float)4.0f) - 90.0f);
                MonstrosityEntity.this.field_6283 = MonstrosityEntity.this.method_36454();
                this.targetSpeed = class_3532.method_15356((float)j, (float)MonstrosityEntity.this.method_36454()) < 3.0f ? class_3532.method_15348((float)this.targetSpeed, (float)1.8f, (float)(0.005f * (1.8f / this.targetSpeed))) : class_3532.method_15348((float)this.targetSpeed, (float)0.2f, (float)0.025f);
                float n = (float)(-(class_3532.method_15349((double)(-e), (double)g) * 57.2957763671875));
                MonstrosityEntity.this.method_36457(n);
                float o = MonstrosityEntity.this.method_36454() + 90.0f;
                double p = (double)(this.targetSpeed * class_3532.method_15362((float)(o * ((float)Math.PI / 180)))) * Math.abs(d / i);
                double q = (double)(this.targetSpeed * class_3532.method_15374((float)(o * ((float)Math.PI / 180)))) * Math.abs(f / i);
                double r = (double)(this.targetSpeed * class_3532.method_15374((float)(n * ((float)Math.PI / 180)))) * Math.abs(e / i);
                class_243 vec3d = MonstrosityEntity.this.method_18798();
                MonstrosityEntity.this.method_18799(vec3d.method_1019(new class_243(p, r, q).method_1020(vec3d).method_1021(0.2)));
            }
        }
    }

    private class StartSwoopAttackGoal
    extends class_1352 {
        private int cooldown;

        private StartSwoopAttackGoal() {
        }

        public boolean method_6264() {
            class_1309 target = MonstrosityEntity.this.method_5968();
            return target != null && MonstrosityEntity.this.method_18391(target, MonstrosityEntity.this.TARGET_PREDICATE);
        }

        public void method_6269() {
            this.cooldown = this.method_38847(10);
            MonstrosityEntity.this.movementType = MovementType.SWOOPING_TO_POSITION;
            this.aimAtTarget();
        }

        public void method_6268() {
            if (MonstrosityEntity.this.movementType == MovementType.SWOOPING_TO_POSITION) {
                --this.cooldown;
                if (this.cooldown <= 0) {
                    MonstrosityEntity.this.movementType = MovementType.START_SWOOPING;
                    this.aimAtTarget();
                    this.cooldown = this.method_38847((8 + MonstrosityEntity.this.field_5974.method_43048(4)) * 20);
                    MonstrosityEntity.this.method_5783(SpectrumSoundEvents.ENTITY_MONSTROSITY_SWOOP, 10.0f, 0.95f + MonstrosityEntity.this.field_5974.method_43057() * 0.1f);
                }
            }
        }

        private void aimAtTarget() {
            MonstrosityEntity.this.targetPosition = MonstrosityEntity.this.method_5968().method_19538();
        }
    }

    private class SwoopMovementGoal
    extends class_1352 {
        SwoopMovementGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return MonstrosityEntity.this.method_5968() != null && MonstrosityEntity.this.movementType == MovementType.START_SWOOPING;
        }

        public boolean method_6266() {
            class_1309 livingEntity = MonstrosityEntity.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (livingEntity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)livingEntity;
                if (livingEntity.method_7325() || playerEntity.method_7337()) {
                    return false;
                }
            }
            return this.method_6264();
        }

        public void method_6270() {
            MonstrosityEntity.this.movementType = MovementType.SWOOPING_TO_POSITION;
        }

        public void method_6268() {
            class_1309 livingEntity = MonstrosityEntity.this.method_5968();
            if (livingEntity != null) {
                MonstrosityEntity.this.targetPosition = new class_243(livingEntity.method_23317(), livingEntity.method_23323(0.5), livingEntity.method_23321());
                if (MonstrosityEntity.this.method_5829().method_1014(0.2).method_994(livingEntity.method_5829())) {
                    MonstrosityEntity.this.method_6121((class_1297)livingEntity);
                    MonstrosityEntity.this.movementType = MovementType.SWOOPING_TO_POSITION;
                    if (!MonstrosityEntity.this.method_5701()) {
                        MonstrosityEntity.this.field_6002.method_20290(1039, MonstrosityEntity.this.method_24515(), 0);
                    }
                } else if (MonstrosityEntity.this.field_5976 || MonstrosityEntity.this.field_6235 > 0) {
                    MonstrosityEntity.this.movementType = MovementType.SWOOPING_TO_POSITION;
                }
            }
        }
    }

    private class RetreatAndAttackGoal
    extends class_1352 {
        protected final float retreatDistance;

        RetreatAndAttackGoal(float retreatDistance) {
            this.retreatDistance = retreatDistance;
        }

        public boolean method_6264() {
            return MonstrosityEntity.this.movementType == MovementType.START_SWOOPING && MonstrosityEntity.this.method_5968() != null && MonstrosityEntity.this.field_6002.field_9229.method_43056() && MonstrosityEntity.this.method_5739((class_1297)MonstrosityEntity.this.method_5968()) < this.retreatDistance - 4.0f;
        }

        public boolean method_6266() {
            return MonstrosityEntity.this.method_5968() != null && MonstrosityEntity.this.method_18391(MonstrosityEntity.this.method_5968(), MonstrosityEntity.this.TARGET_PREDICATE) && MonstrosityEntity.this.method_5739((class_1297)MonstrosityEntity.this.method_5968()) < this.retreatDistance;
        }

        public void method_6269() {
            super.method_6269();
            class_243 differenceToTarget = MonstrosityEntity.this.method_19538().method_1020(MonstrosityEntity.this.method_5968().method_19538());
            class_243 multipliedDifference = differenceToTarget.method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.retreatDistance);
            MonstrosityEntity.this.targetPosition = MonstrosityEntity.this.method_19538().method_1019(multipliedDifference);
            MonstrosityEntity.this.movementType = MovementType.RETREATING;
        }

        public void method_6270() {
            class_1309 target = MonstrosityEntity.this.method_5968();
            if (target != null && MonstrosityEntity.this.method_18391(target, MonstrosityEntity.this.TARGET_PREDICATE)) {
                LightShardEntity.summonBarrage(MonstrosityEntity.this.field_6002, (class_1309)MonstrosityEntity.this, target);
            }
            MonstrosityEntity.this.movementType = MovementType.START_SWOOPING;
            super.method_6270();
        }
    }

    private class FindTargetGoal
    extends class_1352 {
        private int delay = FindTargetGoal.method_38848((int)20);

        FindTargetGoal() {
        }

        public boolean method_6264() {
            if (this.delay > 0) {
                --this.delay;
                return false;
            }
            this.delay = FindTargetGoal.method_38848((int)60);
            class_1657 newTarget = MonstrosityEntity.this.field_6002.method_18462(MonstrosityEntity.this.TARGET_PREDICATE, (class_1309)MonstrosityEntity.this);
            if (newTarget == null) {
                return false;
            }
            MonstrosityEntity.this.method_5980((class_1309)newTarget);
            return true;
        }

        public boolean method_6266() {
            class_1309 target = MonstrosityEntity.this.method_5968();
            return target != null && MonstrosityEntity.this.method_18391(target, MonstrosityEntity.this.TARGET_PREDICATE);
        }
    }
}

