/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.type_specific_predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.dafuqs.spectrum.entity.SpectrumTypeSpecificPredicates;
import de.dafuqs.spectrum.entity.entity.EggLayingWoolyPigEntity;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_7376;
import org.jetbrains.annotations.Nullable;

public class EggLayingWoolyPigPredicate
implements class_7376 {
    private static final String COLOR_KEY = "color";
    private static final String HATLESS_KEY = "hatless";
    private static final String SHEARED_KEY = "sheared";
    private final Optional<class_1767> color;
    private final Optional<Boolean> hatless;
    private final Optional<Boolean> sheared;

    private EggLayingWoolyPigPredicate(Optional<class_1767> color, Optional<Boolean> hatless, Optional<Boolean> sheared) {
        this.color = color;
        this.hatless = hatless;
        this.sheared = sheared;
    }

    public static EggLayingWoolyPigPredicate of(Optional<class_1767> color, Optional<Boolean> hatless, Optional<Boolean> sheared) {
        return new EggLayingWoolyPigPredicate(color, hatless, sheared);
    }

    public static EggLayingWoolyPigPredicate fromJson(JsonObject json) {
        JsonElement colorElement = json.get(COLOR_KEY);
        Optional<class_1767> color = colorElement == null ? Optional.empty() : Optional.of(class_1767.valueOf((String)json.get(COLOR_KEY).getAsString().toUpperCase(Locale.ROOT)));
        JsonElement hatlessElement = json.get(HATLESS_KEY);
        Optional<Boolean> hatless = hatlessElement == null ? Optional.empty() : Optional.of(hatlessElement.getAsBoolean());
        JsonElement shearedElement = json.get(SHEARED_KEY);
        Optional<Boolean> sheared = shearedElement == null ? Optional.empty() : Optional.of(shearedElement.getAsBoolean());
        return new EggLayingWoolyPigPredicate(color, hatless, sheared);
    }

    public JsonObject method_22494() {
        JsonObject jsonObject = new JsonObject();
        this.hatless.ifPresent(clipped -> jsonObject.add(HATLESS_KEY, (JsonElement)new JsonPrimitive(clipped)));
        this.sheared.ifPresent(angry -> jsonObject.add(SHEARED_KEY, (JsonElement)new JsonPrimitive(angry)));
        jsonObject.add(COLOR_KEY, (JsonElement)new JsonPrimitive(this.color.toString().toLowerCase(Locale.ROOT)));
        return jsonObject;
    }

    public class_7376.class_7377 method_43099() {
        return SpectrumTypeSpecificPredicates.EGG_LAYING_WOOLY_PIG;
    }

    public boolean method_22497(class_1297 entity, class_3218 world, @Nullable class_243 pos) {
        if (!(entity instanceof EggLayingWoolyPigEntity)) {
            return false;
        }
        EggLayingWoolyPigEntity wooly = (EggLayingWoolyPigEntity)entity;
        return !(!this.color.isEmpty() && this.color.get() != wooly.getColor() || !this.hatless.isEmpty() && this.hatless.get().booleanValue() != wooly.isHatless() || !this.sheared.isEmpty() && this.sheared.get().booleanValue() != wooly.isSheared());
    }
}

