/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.type_specific_predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.entity.SpectrumTypeSpecificPredicates;
import de.dafuqs.spectrum.entity.entity.LizardEntity;
import de.dafuqs.spectrum.entity.variants.LizardFrillVariant;
import de.dafuqs.spectrum.entity.variants.LizardHornVariant;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7376;
import org.jetbrains.annotations.Nullable;

public class LizardPredicate
implements class_7376 {
    private static final String COLOR_KEY = "color";
    private static final String FRILLS_VARIANT_KEY = "frills_variant";
    private static final String HORN_VARIANT_KEY = "horn_variant";
    private final Optional<InkColor> color;
    private final Optional<LizardFrillVariant> frills;
    private final Optional<LizardHornVariant> horns;

    private LizardPredicate(Optional<InkColor> color, Optional<LizardFrillVariant> frills, Optional<LizardHornVariant> horns) {
        this.color = color;
        this.frills = frills;
        this.horns = horns;
    }

    public static LizardPredicate of(Optional<InkColor> color, Optional<LizardFrillVariant> frills, Optional<LizardHornVariant> horns) {
        return new LizardPredicate(color, frills, horns);
    }

    public static LizardPredicate fromJson(JsonObject json) {
        JsonElement colorElement = json.get(COLOR_KEY);
        Optional<InkColor> color = colorElement == null ? Optional.empty() : Optional.of(InkColor.of(json.get(COLOR_KEY).getAsString().toUpperCase(Locale.ROOT)));
        JsonElement frillsElement = json.get(HORN_VARIANT_KEY);
        Optional frills = frillsElement == null ? Optional.empty() : SpectrumRegistries.LIZARD_FRILL_VARIANT.method_17966(class_2960.method_12829((String)frillsElement.getAsString()));
        JsonElement hornsElement = json.get(HORN_VARIANT_KEY);
        Optional horns = hornsElement == null ? Optional.empty() : SpectrumRegistries.LIZARD_HORN_VARIANT.method_17966(class_2960.method_12829((String)hornsElement.getAsString()));
        return new LizardPredicate(color, frills, horns);
    }

    public JsonObject method_22494() {
        JsonObject jsonObject = new JsonObject();
        this.color.ifPresent(color -> jsonObject.add(COLOR_KEY, (JsonElement)new JsonPrimitive(color.toString())));
        this.frills.ifPresent(frills -> jsonObject.add(FRILLS_VARIANT_KEY, (JsonElement)new JsonPrimitive(SpectrumRegistries.LIZARD_FRILL_VARIANT.method_10221(frills).toString())));
        this.horns.ifPresent(horns -> jsonObject.add(HORN_VARIANT_KEY, (JsonElement)new JsonPrimitive(SpectrumRegistries.LIZARD_HORN_VARIANT.method_10221(horns).toString())));
        return jsonObject;
    }

    public class_7376.class_7377 method_43099() {
        return SpectrumTypeSpecificPredicates.LIZARD;
    }

    public boolean method_22497(class_1297 entity, class_3218 world, @Nullable class_243 pos) {
        if (!(entity instanceof LizardEntity)) {
            return false;
        }
        LizardEntity lizard = (LizardEntity)entity;
        return !(!this.color.isEmpty() && this.color.get() != lizard.getColor() || !this.frills.isEmpty() && this.frills.get() != lizard.getFrills() || !this.horns.isEmpty() && this.horns.get() != lizard.getHorns());
    }
}

