/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.explosion;

import java.util.Locale;
import net.minecraft.class_2561;

public enum ExplosionArchetype {
    COSMETIC("cosmetic", false, false),
    DESTROY_BLOCKS("destroy_blocks", true, false),
    DAMAGE_ENTITIES("damage_entities", false, true),
    ALL("all", true, true);

    private final class_2561 name;
    public final boolean affectsBlocks;
    public final boolean affectsEntities;

    private ExplosionArchetype(String id, boolean affectsBlocks, boolean affectsEntities) {
        this.affectsBlocks = affectsBlocks;
        this.affectsEntities = affectsEntities;
        this.name = class_2561.method_43471((String)("explosion_archetype.spectrum." + id));
    }

    public static ExplosionArchetype tryParse(String name) {
        try {
            return ExplosionArchetype.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return COSMETIC;
        }
    }

    public static ExplosionArchetype get(boolean affectsBlocks, boolean affectsEntities) {
        if (affectsBlocks) {
            return affectsEntities ? ALL : DESTROY_BLOCKS;
        }
        return affectsEntities ? DAMAGE_ENTITIES : COSMETIC;
    }

    public class_2561 getName() {
        return this.name;
    }
}

