/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.features.GilledFungusFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class GilledFungusFeature
extends class_3031<GilledFungusFeatureConfig> {
    public GilledFungusFeature(Codec<GilledFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<GilledFungusFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        GilledFungusFeatureConfig hugeFungusFeatureConfig = (GilledFungusFeatureConfig)context.method_33656();
        class_2248 validBaseBlock = hugeFungusFeatureConfig.validBase();
        class_2680 baseBlock = structureWorldAccess.method_8320(blockPos.method_10074());
        if (!baseBlock.method_27852(validBaseBlock)) {
            return false;
        }
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        int stemHeight = class_3532.method_15395((class_5819)random, (int)4, (int)9);
        if (random.method_43048(12) == 0) {
            stemHeight *= 2;
        }
        if (blockPos.method_10264() + stemHeight + 1 >= chunkGenerator.method_12104()) {
            return false;
        }
        structureWorldAccess.method_8652(blockPos, class_2246.field_10124.method_9564(), 4);
        this.generateStem((class_1936)structureWorldAccess, hugeFungusFeatureConfig, blockPos, stemHeight);
        this.generateHat((class_1936)structureWorldAccess, random, hugeFungusFeatureConfig, blockPos, stemHeight);
        return true;
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos, boolean replacePlants) {
        return world.method_16358(pos, state -> {
            class_3614 material = state.method_26207();
            return state.method_26207().method_15800() || replacePlants && material == class_3614.field_15935;
        });
    }

    private void generateStem(class_1936 world, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 blockState = config.stem().method_9564();
        int i = 0;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    mutable.method_25504((class_2382)pos, x, y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (class_2338)mutable, true)) continue;
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(class_1936 world, class_5819 random, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight) {
        int hatWidth;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int currentHatWidth = hatWidth = Math.min(random.method_43048(2 + stemHeight / 4) + 3, 4);
        int outerThreshold = hatWidth / 2;
        class_2680 stemState = config.stem().method_9564();
        class_2680 gillsState = config.gills().method_9564();
        class_2680 capState = config.cap().method_9564();
        for (int y = 0; y <= hatWidth; ++y) {
            for (int x = -currentHatWidth; x <= currentHatWidth; ++x) {
                for (int z = -currentHatWidth; z <= currentHatWidth; ++z) {
                    boolean isLowestLevel;
                    boolean isCorner;
                    boolean bl = isCorner = Math.abs(x) == currentHatWidth && Math.abs(z) == currentHatWidth;
                    if (isCorner) continue;
                    mutable.method_25504((class_2382)pos, x, stemHeight + y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (class_2338)mutable, false)) continue;
                    boolean isInnerCorner = Math.abs(x) == currentHatWidth - 1 && Math.abs(z) == currentHatWidth - 1;
                    boolean isInner = Math.abs(x) < currentHatWidth && Math.abs(z) < currentHatWidth;
                    boolean bl2 = isLowestLevel = y == 0;
                    if (x == 0 && z == 0) {
                        this.method_13153((class_1945)world, (class_2338)mutable, currentHatWidth < 2 ? capState : stemState);
                        continue;
                    }
                    if (isInner && !isInnerCorner) {
                        if (isLowestLevel && Math.abs(x) <= outerThreshold && Math.abs(z) <= outerThreshold) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, (class_2680)gillsState.method_11657((class_2769)class_2465.field_11459, (Comparable)(Math.abs(x) < Math.abs(z) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)));
                        continue;
                    }
                    this.method_13153((class_1945)world, (class_2338)mutable, capState);
                }
            }
            --currentHatWidth;
        }
    }
}

