/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class BlockVariantHelper {
    private static final Map<class_2248, Map<class_1767, class_2248>> coloredStates = new HashMap<class_2248, Map<class_1767, class_2248>>();
    private static final List<String> COLOR_STRINGS = List.of("light_blue", "light_gray", "white", "orange", "magenta", "yellow", "lime", "pink", "gray", "cyan", "purple", "blue", "brown", "green", "red", "black");
    private static final Map<class_2248, class_2248> repairedStates = new HashMap<class_2248, class_2248>(){
        {
            this.put(class_2246.field_29222, class_2246.field_28900);
            this.put(class_2246.field_29223, class_2246.field_28896);
            this.put(class_2246.field_23867, class_2246.field_10266);
            this.put(class_2246.field_23875, class_2246.field_23874);
            this.put(class_2246.field_10416, class_2246.field_10056);
            this.put(class_2246.field_10100, class_2246.field_10387);
            this.put(class_2246.field_10414, class_2246.field_10105);
            this.put(class_2246.field_10105, class_2246.field_10535);
            this.put(class_2246.field_27118, class_2246.field_27119);
            this.put(class_2246.field_27117, class_2246.field_27118);
            this.put(class_2246.field_27116, class_2246.field_27117);
            this.put(class_2246.field_27123, class_2246.field_27124);
            this.put(class_2246.field_27122, class_2246.field_27123);
            this.put(class_2246.field_27121, class_2246.field_27122);
        }
    };

    public static class_2680 getCursedBlockColorVariant(class_1937 world, class_2338 blockPos, class_1767 newColor) {
        class_2960 newIdentifier;
        class_2248 newIdentifierBlock;
        Map<class_1767, class_2248> colorMap;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            return class_2246.field_10124.method_9564();
        }
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26164(SpectrumBlockTags.INK_EFFECT_BLACKLISTED)) {
            return class_2246.field_10124.method_9564();
        }
        class_2248 block = blockState.method_26204();
        if (coloredStates.containsKey(block) && (colorMap = coloredStates.get(block)).containsKey(newColor)) {
            class_2248 newBlock = colorMap.get(newColor);
            return newBlock.method_34725(blockState);
        }
        class_2960 identifier = class_2378.field_11146.method_10221((Object)block);
        String newPath = null;
        for (String colorString : COLOR_STRINGS) {
            if (!identifier.method_12832().contains(colorString)) continue;
            newPath = identifier.method_12832().replace(colorString, newColor.toString());
            break;
        }
        class_2248 returnBlock = class_2246.field_10124;
        if (newPath != null && (newIdentifierBlock = (class_2248)class_2378.field_11146.method_10223(newIdentifier = new class_2960(identifier.method_12836(), newPath))) != block) {
            returnBlock = newIdentifierBlock;
        }
        if (coloredStates.containsKey(block)) {
            colorMap = coloredStates.get(block);
            colorMap.put(newColor, returnBlock);
        } else {
            colorMap = new HashMap();
            colorMap.put(newColor, returnBlock);
            coloredStates.put(block, colorMap);
        }
        return returnBlock.method_34725(blockState);
    }

    public static class_2248 getCursedRepairedBlockVariant(class_1937 world, class_2338 blockPos) {
        class_2960 newIdentifier;
        class_2248 newIdentifierBlock;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            return class_2246.field_10124;
        }
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26164(SpectrumBlockTags.INK_EFFECT_BLACKLISTED)) {
            return class_2246.field_10124;
        }
        class_2248 block = blockState.method_26204();
        if (repairedStates.containsKey(block)) {
            return repairedStates.get(block);
        }
        class_2960 identifier = class_2378.field_11146.method_10221((Object)block);
        String newPath = identifier.method_12832();
        newPath = newPath.replace("cracked_", "");
        newPath = newPath.replace("damaged_", "");
        newPath = newPath.replace("chipped_", "");
        class_2248 returnBlock = class_2246.field_10124;
        if (!newPath.equals(identifier.method_12832()) && (newIdentifierBlock = (class_2248)class_2378.field_11146.method_10223(newIdentifier = new class_2960(identifier.method_12836(), newPath))) != block) {
            returnBlock = newIdentifierBlock;
        }
        repairedStates.put(block, returnBlock);
        return returnBlock;
    }
}

