/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.items.PigmentItem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ColorHelper {
    public static List<class_1767> VANILLA_DYE_COLORS = Arrays.stream(class_1767.values()).filter(dyeColor -> dyeColor.method_7789() < 16).toList();

    public static class_1160 getRGBVec(class_1767 dyeColor) {
        return InkColor.of(dyeColor).getColor();
    }

    public static int getInt(class_1767 dyeColor) {
        class_1160 vec = ColorHelper.getRGBVec(dyeColor);
        return new Color(vec.method_4943(), vec.method_4945(), vec.method_4947()).getRGB() & 0xFFFFFF;
    }

    public static int getRandomColor(int seed) {
        return Color.getHSBColor((float)seed / 2.1474836E9f, 0.7f, 0.9f).getRGB();
    }

    @NotNull
    public static class_1160 colorIntToVec(int color) {
        Color colorObj = new Color(color);
        float[] argb = new float[4];
        colorObj.getColorComponents(argb);
        return new class_1160(argb[0], argb[1], argb[2]);
    }

    public static Optional<class_1767> getDyeColorOfItemStack(@NotNull class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            class_1792 item = itemStack.method_7909();
            if (item instanceof class_1769) {
                class_1769 dyeItem = (class_1769)item;
                return Optional.of(dyeItem.method_7802());
            }
            if (item instanceof PigmentItem) {
                PigmentItem pigmentItem = (PigmentItem)item;
                return Optional.of(pigmentItem.getColor());
            }
        }
        return Optional.empty();
    }
}

