/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3215;
import net.minecraft.class_3568;
import net.minecraft.class_4076;

public class ExplosionUtils {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public static void attemptExplosion(class_1937 world, int x, int y, int z, int power) {
        if (!world.field_9236) {
            ExplosionUtils.explode(world, x, y, z, power);
        }
    }

    private static long explode(class_1937 access, int x, int y, int z, int radius) {
        int cr = radius >> 4;
        int blocks = 0;
        for (int cox = -cr; cox <= cr + 1; ++cox) {
            for (int coz = -cr; coz <= cr + 1; ++coz) {
                int box = cox * 16;
                int boz = coz * 16;
                if (!ExplosionUtils.touchesOrIsIn(box, 0, boz, box + 15, 255, boz + 15, radius)) continue;
                int cx = (x >> 4) + cox;
                int cz = (z >> 4) + coz;
                class_2818 chunk = access.method_8497(cx, cz);
                blocks = (int)((long)blocks + ExplosionUtils.forSubChunks(chunk, box, boz, x, y, z, radius));
                chunk.method_12008(true);
                class_3215 manager = (class_3215)access.method_8398();
                manager.field_17254.method_17210(new class_1923(cx, cz), false).forEach(player -> player.field_13987.method_14364((class_2596)new class_2672(chunk, (class_3568)manager.method_17293(), null, null, true)));
            }
        }
        return blocks;
    }

    private static boolean touchesOrIsIn(int x1, int y1, int z1, int x2, int y2, int z2, int radius) {
        int squared = radius * radius;
        if (0 < x1) {
            squared -= x1 * x1;
        } else if (0 > x2) {
            squared -= x2 * x2;
        }
        if (0 < y1) {
            squared -= y1 * y1;
        } else if (0 > y2) {
            squared -= y2 * y2;
        }
        if (0 < z1) {
            squared -= z1 * z1;
        } else if (0 > z2) {
            squared -= z2 * z2;
        }
        return squared > 0;
    }

    private static long forSubChunks(class_2818 chunk, int bx, int bz, int x, int y, int z, int radius) {
        int scr = radius >> 4;
        int sc = y >> 4;
        int destroyed = 0;
        class_2826[] sections = chunk.method_12006();
        for (int i = -scr; i <= scr; ++i) {
            class_2826 section;
            int by = i * 16;
            int val = i + sc;
            if (val < 0 || val >= 16 || (section = sections[val]) == null) continue;
            for (int ox = 0; ox < 16; ++ox) {
                for (int oy = 0; oy < 16; ++oy) {
                    for (int oz = 0; oz < 16; ++oz) {
                        if (!ExplosionUtils.isIn(bx + ox, by + oy, bz + oz, radius) || section.method_12254(ox, oy, oz).method_26214((class_1922)chunk, class_2338.field_10980) == -1.0f) continue;
                        section.method_16675(ox, oy, oz, AIR);
                        ++destroyed;
                    }
                }
            }
            chunk.method_12200().method_22336().method_15551(class_4076.method_18676((int)(bx >> 4), (int)i, (int)(bz >> 4)), false);
        }
        return destroyed;
    }

    private static boolean isIn(int ox, int oy, int oz, int radius) {
        return ox * ox + oy * oy + oz * oz <= radius * radius;
    }
}

