/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3954;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryHelper {
    public static int getItemCountInInventory(class_1263 inventory, class_1792 item) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31574(item)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static boolean removeFromInventoryWithRemainders(@NotNull class_1657 playerEntity, @NotNull class_1799 stackToRemove) {
        if (playerEntity.method_7337()) {
            return true;
        }
        class_1661 playerInventory = playerEntity.method_31548();
        ArrayList<class_3545> matchingStacks = new ArrayList<class_3545>();
        int paymentStackItemCount = 0;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 currentStack = playerInventory.method_5438(i);
            if (!currentStack.method_7909().equals(stackToRemove.method_7909())) continue;
            matchingStacks.add(new class_3545((Object)i, (Object)currentStack));
            if ((paymentStackItemCount += currentStack.method_7947()) >= stackToRemove.method_7947()) break;
        }
        if (paymentStackItemCount < stackToRemove.method_7947()) {
            return false;
        }
        int amountToRemove = stackToRemove.method_7947();
        for (class_3545 matchingStack : matchingStacks) {
            if (((class_1799)matchingStack.method_15441()).method_7947() <= amountToRemove) {
                playerEntity.method_31548().method_5447(((Integer)matchingStack.method_15442()).intValue(), class_1799.field_8037);
                if ((amountToRemove -= ((class_1799)matchingStack.method_15441()).method_7947()) > 0) continue;
                break;
            }
            ((class_1799)matchingStack.method_15441()).method_7934(amountToRemove);
            return true;
        }
        return true;
    }

    public static boolean isItemCountInInventory(List<class_1799> inventory, ItemVariant itemVariant, int maxSearchAmount) {
        int count = 0;
        for (class_1799 inventoryStack : inventory) {
            if (!itemVariant.matches(inventoryStack) || (count += inventoryStack.method_7947()) < maxSearchAmount) continue;
            return true;
        }
        return false;
    }

    public static class_3545<Integer, List<class_1799>> getStackCountInInventory(class_1799 itemStack, List<class_1799> inventory, int maxSearchAmount) {
        ArrayList<class_1799> foundStacks = new ArrayList<class_1799>();
        int count = 0;
        for (class_1799 inventoryStack : inventory) {
            if (!inventoryStack.method_7929(itemStack)) continue;
            foundStacks.add(inventoryStack);
            if ((count += inventoryStack.method_7947()) < maxSearchAmount) continue;
            return new class_3545((Object)count, foundStacks);
        }
        return new class_3545((Object)count, foundStacks);
    }

    public static class_1799 smartAddToInventory(class_1799 itemStack, class_1263 inventory, @Nullable class_2350 side) {
        if (inventory instanceof class_1278 && side != null) {
            int acceptableSlot;
            int[] acceptableSlots;
            int[] nArray = acceptableSlots = ((class_1278)inventory).method_5494(side);
            int n = nArray.length;
            for (int i = 0; !(i >= n || ((class_1278)inventory).method_5492(acceptableSlot = nArray[i], itemStack, side) && (itemStack = InventoryHelper.setOrCombineStack(inventory, acceptableSlot, itemStack)).method_7960()); ++i) {
            }
        } else {
            for (int i = 0; i < inventory.method_5439() && !(itemStack = InventoryHelper.setOrCombineStack(inventory, i, itemStack)).method_7960(); ++i) {
            }
        }
        return itemStack;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static class_1799 setOrCombineStack(class_1263 inventory, int slot, class_1799 addingStack) {
        class_1799 existingStack = inventory.method_5438(slot);
        if (!existingStack.method_7960()) {
            InventoryHelper.combineStacks(existingStack, addingStack);
            return addingStack;
        }
        if (addingStack.method_7947() > addingStack.method_7914()) {
            int amount = Math.min(addingStack.method_7914(), addingStack.method_7947());
            amount = Math.min(amount, inventory.method_5444());
            class_1799 newStack = addingStack.method_7972();
            newStack.method_7939(amount);
            addingStack.method_7934(amount);
            inventory.method_5447(slot, newStack);
            return addingStack;
        }
        inventory.method_5447(slot, addingStack);
        return class_1799.field_8037;
    }

    public static void combineStacks(class_1799 originalStack, class_1799 addingStack) {
        int leftOverAmountInExistingStack;
        if (class_1799.method_31577((class_1799)originalStack, (class_1799)addingStack) && (leftOverAmountInExistingStack = originalStack.method_7914() - originalStack.method_7947()) > 0) {
            int addAmount = Math.min(leftOverAmountInExistingStack, addingStack.method_7947());
            originalStack.method_7933(addAmount);
            addingStack.method_7934(addAmount);
        }
    }

    public static boolean addToInventory(class_1263 inventory, class_1799 stackToAdd, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (currentStack.method_7960()) {
                inventory.method_5447(i, stackToAdd);
                return true;
            }
            if (!stackToAdd.method_7946()) continue;
            InventoryHelper.combineStacks(currentStack, stackToAdd);
            if (!stackToAdd.method_7960()) continue;
            return true;
        }
        return false;
    }

    public static boolean addToInventory(class_1263 inventory, List<class_1799> stacksToAdd, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960()) {
                inventory.method_5447(i, stacksToAdd.get(0));
                stacksToAdd.remove(0);
                if (stacksToAdd.isEmpty()) {
                    return true;
                }
            }
            for (int j = 0; j < stacksToAdd.size(); ++j) {
                class_1799 stackToAdd = stacksToAdd.get(j);
                if (!stackToAdd.method_7946()) continue;
                InventoryHelper.combineStacks(inventoryStack, stackToAdd);
                if (!stackToAdd.method_7960()) continue;
                stacksToAdd.remove(j);
                if (stacksToAdd.isEmpty()) {
                    return true;
                }
                --j;
            }
        }
        return false;
    }

    public static void addToInventory(List<class_1799> inventory, class_1799 itemStack, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            class_1799 currentStack = inventory.get(i);
            if (currentStack.method_7960()) {
                inventory.set(i, itemStack);
                return;
            }
            if (!itemStack.method_7946()) continue;
            InventoryHelper.combineStacks(currentStack, itemStack);
            if (!itemStack.method_7960()) continue;
            return;
        }
    }

    public static boolean hasInInventory(List<class_1856> ingredients, class_1263 inventory) {
        ArrayList<class_1856> ingredientsToFind = new ArrayList<class_1856>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (class_1856 ingredient : ingredients) {
            if (ingredient.method_8103()) continue;
            ingredientsToFind.add(ingredient);
            if (ingredient.method_8105().length > 0) {
                requiredIngredientAmounts.add(ingredient.method_8105()[0].method_7947());
                continue;
            }
            requiredIngredientAmounts.add(1);
        }
        block1: for (int i = 0; i < inventory.method_5439() && ingredientsToFind.size() != 0; ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (currentStack.method_7960()) continue;
            int amount = currentStack.method_7947();
            for (int j = 0; j < ingredientsToFind.size(); ++j) {
                if (!((class_1856)ingredientsToFind.get(j)).method_8093(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                if (amount >= ingredientCount) {
                    ingredientsToFind.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - amount);
                }
                if ((amount -= ingredientCount) < 1) continue block1;
            }
        }
        return ingredientsToFind.size() == 0;
    }

    public static List<class_1799> removeFromInventoryWithRemainders(List<class_1856> ingredients, class_1263 inventory) {
        ArrayList<class_1799> remainders = new ArrayList<class_1799>();
        ArrayList<class_1856> requiredIngredients = new ArrayList<class_1856>();
        ArrayList<Integer> requiredIngredientAmounts = new ArrayList<Integer>();
        for (class_1856 ingredient : ingredients) {
            if (ingredient.method_8103()) continue;
            requiredIngredients.add(ingredient);
            if (ingredient.method_8105().length > 0) {
                requiredIngredientAmounts.add(ingredient.method_8105()[0].method_7947());
                continue;
            }
            requiredIngredientAmounts.add(1);
        }
        for (int i = 0; i < inventory.method_5439() && requiredIngredients.size() != 0; ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (currentStack.method_7960()) continue;
            for (int j = 0; j < requiredIngredients.size(); ++j) {
                int currentStackCount = currentStack.method_7947();
                if (!((class_1856)requiredIngredients.get(j)).method_8093(currentStack)) continue;
                int ingredientCount = (Integer)requiredIngredientAmounts.get(j);
                class_1799 remainder = currentStack.getRecipeRemainder();
                if (currentStackCount >= ingredientCount) {
                    if (!remainder.method_7960()) {
                        remainder.method_7939(((Integer)requiredIngredientAmounts.get(j)).intValue());
                        remainders.add(remainder);
                    }
                    requiredIngredients.remove(j);
                    requiredIngredientAmounts.remove(j);
                    --j;
                } else {
                    if (!remainder.method_7960()) {
                        remainder.method_7939(currentStackCount);
                        remainders.add(remainder);
                    }
                    requiredIngredientAmounts.set(j, (Integer)requiredIngredientAmounts.get(j) - currentStackCount);
                }
                currentStack.method_7939(currentStackCount - ingredientCount);
            }
        }
        return remainders;
    }

    public static List<class_1799> removeFromInventoryWithRemainders(class_1799 removeItemStack, class_1263 inventory) {
        ArrayList<class_1799> remainders = new ArrayList<class_1799>();
        int removeItemStackCount = removeItemStack.method_7947();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (removeItemStack.method_7929(currentStack)) {
                class_1799 remainder = currentStack.getRecipeRemainder();
                int amountAbleToDecrement = Math.min(currentStack.method_7947(), removeItemStackCount);
                currentStack.method_7934(amountAbleToDecrement);
                removeItemStackCount -= amountAbleToDecrement;
                if (!remainder.method_7960()) {
                    remainder.method_7939(amountAbleToDecrement);
                    remainders.add(remainder);
                }
            }
            if (removeItemStackCount != 0) continue;
            return remainders;
        }
        return remainders;
    }

    public static boolean canExtract(class_1263 inv, class_1799 stack, int slot, class_2350 facing) {
        return !(inv instanceof class_1278) || ((class_1278)inv).method_5493(slot, stack, facing);
    }

    public static boolean canCombineItemStacks(class_1799 currentItemStack, class_1799 additionalItemStack) {
        return currentItemStack.method_7960() || additionalItemStack.method_7960() || currentItemStack.method_7929(additionalItemStack) && currentItemStack.method_7947() + additionalItemStack.method_7947() <= currentItemStack.method_7914();
    }

    @Nullable
    public static class_1263 getInventoryAt(class_1937 world, double x, double y, double z) {
        List list;
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2338 blockPos = new class_2338(x, y, z);
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.method_8333(null, new class_238(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), class_1301.field_6152)).isEmpty()) {
            inventory = (class_1263)list.get(world.field_9229.method_43048(list.size()));
        }
        return inventory;
    }

    public static Optional<class_1799> extractLastStack(class_1263 inventory) {
        for (int i = inventory.method_5439() - 1; i >= 0; --i) {
            class_1799 currentStack = inventory.method_5438(i);
            if (currentStack.method_7960()) continue;
            inventory.method_5447(i, class_1799.field_8037);
            return Optional.of(currentStack);
        }
        return Optional.empty();
    }

    public static class_1799 addToInventoryUpToSingleStackWithMaxTotalCount(class_1799 itemStack, class_1263 inventory, int maxTotalCount) {
        int itemCount = 0;
        int firstEmptySlot = -1;
        class_1799 matchingStack = null;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 slotStack = inventory.method_5438(i);
            if (slotStack.method_7960()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            itemCount += slotStack.method_7947();
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)slotStack)) continue;
            matchingStack = slotStack;
        }
        int storageLeft = maxTotalCount - itemCount;
        if (storageLeft <= 0) {
            return itemStack;
        }
        if (matchingStack != null) {
            int addedCount = Math.min(matchingStack.method_7914() - matchingStack.method_7947(), itemStack.method_7947());
            if ((addedCount = Math.min(storageLeft, addedCount)) > 0) {
                matchingStack.method_7939(matchingStack.method_7947() + addedCount);
                itemStack.method_7934(addedCount);
            }
            return itemStack;
        }
        if (firstEmptySlot == -1) {
            return itemStack;
        }
        inventory.method_5447(firstEmptySlot, itemStack.method_7971(storageLeft));
        return itemStack;
    }

    public static int countItemsInInventory(class_1263 inventory) {
        int contentCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            contentCount += stack.method_7947();
        }
        return contentCount;
    }
}

